/*** I_ICMP.C ***/						#include	"main.h"

#define	MAX_PACKET	65535				// Max Frame Size for {TCP|UDP|ICMP}/IP Packet [Byte]

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_icmp_socket(ctree *ctr){		/*** TT-Lang: A = ICMP_SOCKET(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;			int		cnt;
int		sock,flag_bind;					// Socket for Network / Flag for BIND(2)

/* Set Param(s) & Check Type(s) */
	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 1:	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SID",0);	// IP  (I)
				flag_bind = TRUE; break;
		case 0:
				flag_bind = FALS; break;
		default:
			flag_exerr=NgARGCnn; epar[0]=cnt,epar[1]=0,epar[2]=1,epar[3]=INVA; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TCP_SOCKET()!! */
	if( flag_bind )
		sock = mk_socket('I',TRUE,   x,NULL);
	else
		sock = mk_socket('I',FALS,NULL,NULL);
	if( sock<0 ){						// Error!!
		null_dtab(a);
		return ans;
	}

	ICMP_SOCKET()->type = 'I';			// Save to Default ICMP_SOCKET!!
	ICMP_SOCKET()->ival = sock;			// Save to Default ICMP_SOCKET!!
	a->type = 'I'; a->ival = sock; return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_tx_ping(ctree *ctr){			/*** TT-Lang: A = TX_PING(S,X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*s,*x;					int		cnt,flag_mode;
struct sockaddr_in re_addr;				// {*****|Remote} Internet Address (IP+Port)
struct icmphdr *p_icmphdr;				// Struct for ICMP Header
struct timeval *p_timeval;				// Struct TIMEVAL - tv_sec[Sec] & tv_usec[uSec]
char	buf[MAX_PACKET+1];				// Buffer for TX ICMP Frame ( +1 for NULL )
tint	t_ip,t_port;					// IP Address / Port Number
int		len,opt,ret;					// Length of Data / Option Value / Return Value

       uint16_t t_pid=0xFFFF&getpid();	// ICMP ID       ( 0xFFFF & PID )
static uint16_t t_seq=0;				// ICMP Sequence ( 0,1,2,3, ... )

/* Set Param(s) & Check Type(s) */

// Mode-A(ARGC=2): Sock(I) IP(I)
// Mode-B(ARGC=1):         IP(I)

	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 2: flag_mode='A';
			s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"ID"  ,0);	// Sock(I)
			x = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(x,"SID" ,1);	// IP  (I)
			break;
		case 1: flag_mode='B';
			s = ICMP_SOCKET(); if( cint(s)<=0 ){ s->type='I'; s->ival=mk_socket('I',FALS,NULL,NULL); }
			x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SID" ,0);	// IP  (I)
			break;
		default:
			flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=1,epar[2]=2; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TX_ECHO()!! */
	t_ip  = conv_diphn2tint(    x);
	t_port= 0;							// Not Used!!
	if( t_ip  <0 ){ flag_exerr=IpAddr; epos=(flag_mode=='A')?1:0; return NULL; }

	len   = 0;
	opt   = 0;
	re_addr.sin_family      = AF_INET;
	re_addr.sin_addr.s_addr = htonl(t_ip  );
	re_addr.sin_port        = htons(t_port);

/* ( Make ICMP Header ) */
	p_icmphdr = (struct icmphdr *)&buf[0];
	p_icmphdr->type = ICMP_ECHO;
	p_icmphdr->code = 0;
	p_icmphdr->checksum = 0;
	p_icmphdr->un.echo.id = t_pid;
	p_icmphdr->un.echo.sequence = t_seq++;
	len += sizeof(struct icmphdr);

	p_timeval = (struct timeval *)&buf[len];
	if( gettimeofday(p_timeval,NULL)==-1 ){ flag_exerr=NullSYS; return NULL; }
	len += sizeof(struct timeval);

//	for( int i=0x10 ; i<=0x37 ; i++,len++ ){ buf[len]=(0xFF&i); }

	p_icmphdr->checksum = net_checksum((uint16_t *)buf,len);
/* -------------------  */

	ret = sendto( cint(s), buf, len, opt, (struct sockaddr *)&re_addr, sizeof(re_addr) );
	if( ret<0 ){						// Network Error!!
		flag_exerr=IcmpSend; /*last_ct=par;*/ return(NULL);
	}

	a->type = 'I';
	a->ival = ret;
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_rx_ping(ctree *ctr){			/*** TT-Lang: A = RX_PING(S) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*s;					int		cnt,flag_mode;
struct sockaddr_in re_addr;				// {*****|Remote} Internet Address (IP+Port)
char	buf[MAX_PACKET+1];				// Buffer for RX ICMP Frame ( +1 for NULL )
int		len,opt,ret;					// Length of Data / Option Value / Return Value

/* Set Param(s) & Check Type(s) */

// Mode-A(ARGC=1): Sock(I)
// Mode-B(ARGC=0):

	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 1:	flag_mode='A';
				s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"ID",0);	// Sock(I)
				break;
		case 0:	flag_mode='B';
				s = ICMP_SOCKET(); if( cint(s)<=0 ){ s->type='I'; s->ival=mk_socket('I',TRUE,NULL,NULL); } /* Must Bind!! */
				break;
		default:
			flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=0,epar[2]=1; return NULL;
	}
	ans = ext_ctrdtabmult(ctr,4);

/* Do RX_PING()!! */
	len = sizeof(re_addr);
	opt = 0;
	ret = recvfrom( cint(s), buf, MAX_PACKET, opt, (struct sockaddr *)&re_addr, (unsigned int *)&len );
	if( ret<0 ){						// Network Error!!
		flag_exerr=IcmpRecv; /*last_ct=par;*/ return(NULL);
	}

	buf[ret] = '\0';
	a = ctr2p_dtab(lptr(ans,0)); a->type='I'; a->ival=ntohl(re_addr.sin_addr.s_addr);	// IP  (I)
	a = ctr2p_dtab(lptr(ans,1)); a->type='I'; a->ival=ntohs(re_addr.sin_port       );	// Port(I)
	a = ctr2p_dtab(lptr(ans,2)); a->type='P'; a->ptr =X_NDUP(buf,ret);					// Data(P)
	a = ctr2p_dtab(lptr(ans,3)); a->type='I'; a->ival=ret;								// Size(I)
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
// NET_CHECKSUM() calcurate & return {TCP|UDP|ICMP} Checksum.
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
uint16_t net_checksum(uint16_t *buf,int len){
uint64_t sum=0;

	while( len>1 ){
		sum += *buf;					// Add as 16[Bit] UINT
		buf++;							// Goto Next Word
		len-=2;							// -2[Byte]
	}
	if( len==1 )
		sum += *(uint8_t*)buf;			// Add as  8[Bit] UINT
	sum = (sum&0xFFFF)+(sum>>16);
	sum = (sum&0xFFFF)+(sum>>16);
	return ~sum;
}
