/*** BSUP.C - Bison Support Code ( General Function ) ***/

/* Define Macro(s) for BISON */
#define	b(MSG)		if( flag_debug&DF_BISON ){ eprin("[%sBp%s] %s\n", C_RED(2), C_DEF(2), MSG); fflush(NULL); }

#define	new_glcdx(NAM)		idx2cdx('G',wr_dtab(GL_DTAB        ,NAM,'U',0))
#define	new_stcdx(NAM)		idx2cdx('S',wr_dtab(mp_base+ST_DTAB,NAM,'U',0))
#define	new_lccdx(NAM)		idx2cdx('L',wr_dtab(mp_base+LC_DTAB,NAM,'U',0))
#define	opeq(OPEQ,OP,LC,RC)	mk_ctree('=',tkpos(OPEQ),LC,mk_ctree(OP,tkpos(OPEQ),LC,RC,00),00);

#define	deptk(ARG)			(ARG.name),(ARG.file),(ARG.line),(ARG.colm),(ARG.gl),(ARG.st),(ARG.lc),(ARG.p_elmt)
#define	tkpos(ARG)			(ARG.              file),(ARG.              line),(ARG.              colm)
#define	ctpos(ARG)			(ARG==NULL?00:ARG->file),(ARG==NULL?00:ARG->line),(ARG==NULL?00:ARG->colm)

/************************************************************************************************/
// ISCGAP() check CTREE Node is <GAP>. (TRUE/FALS)
/************************************************************************************************/
int iscgap(ctree *node){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	return( (node->op==0x00||node->op==0xFF) && node->x==NULL );
}

/************************************************************************************************/
// LGAP() check and return <GAP> Node index in CTREE CSL. ( Index=0,1,2,... / NonGAP=INVA )
/************************************************************************************************/
int lgap(ctree *ctr){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		cnt = lcnt(ctr);
	for( int i=0 ; i<cnt ; i++ )
		if( iscgap(lptr(ctr,i)) ){ return(i); }
	return(INVA);
}

/************************************************************************************************/
// LCNT()|LCNTA()|LCNTG() return node count in { CTREE CSL | Argv CSL | Generic CTREE }.
/************************************************************************************************/
int lcnt (ctree *ctr){					/* Node Count in CTREE CSL								*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( ctr==NULL ){ return 0x00; }		/* ( No Node ) */
	if( ctr->op==',' )
		return( lcnt(ctr->l) + lcnt(ctr->r) );
	return(1);
}

int lcnta(ctree *ctr){					/* Node Count in Argv CSL ( Allow Root OP )				*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		lc,rc;
	if( ctr==NULL ){ return 0x00; }		/* ( No Node ) */
	if( ctr->op==0x00 || ctr->op==0xFF )
		return 1;
	if( ctr->l ==NULL && ctr->r ==NULL )
		return 1;
	lc = (ctr->l==NULL) ? 0 : (ctr->l->op==','?lcnta(ctr->l):1);
	rc = (ctr->r==NULL) ? 0 : (                              1);
	return( lc + rc );
}

int lcntg(ctree *ctr){					/* Node Count in Generic CTREE							*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( ctr==NULL ){ return 0x00; }		/* ( No Node ) */
	if( ctr->op!=0x00 && ctr->op!=0xFF )
		return( lcntg(ctr->l) + lcntg(ctr->r) );
	return(1);
}

/************************************************************************************************/
// LPTR()|LPTRA()|LPTRG() return node pointer in { CTREE CSL | Argv CSL | Generic CTREE }.
/************************************************************************************************/
ctree *lptr (ctree *ctr,int idx){		/* Node Pointer in CTREE CSL							*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		lc;								/* >Left Node Count										*/
	if( ctr==NULL ){ return NULL; }		/* ( No Node ) */
	if( ctr->op==',' ){
		lc=lcnt (ctr->l); return((idx<=lc-1) ? lptr (ctr->l,idx) : lptr (ctr->r,idx-lc));
	}
	return( idx==0 ? ctr : NULL );
}

ctree *lptra(ctree *ctr,int idx){		/* Node Pointer in Argv CSL ( Allow Root OP )			*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		lc,rc;							/* >Left&Right Node Count								*/
	if( ctr==NULL ){ return NULL; }		/* ( No Node ) */
	if( ctr->op==0x00 || ctr->op==0xFF )
		return( idx==0?ctr:NULL );
	rc = (ctr->r==NULL?0:1);
	lc = lcnta(ctr) - rc;
	if( idx<lc+rc-1 ){
		if( lc==1 ) return( idx==0 ? ctr->l : NULL );
		else return( lptra(ctr->l,idx) );
	}
	if( idx==lc+rc-1 ){
		if( rc==1 ) return( ctr->r );
		else return( lc==1 ? ctr->l : ctr->l->r );
	}
	return(NULL);
}

ctree *lptrg(ctree *ctr,int idx){		/* Node Pointer in Generic CTREE						*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		lc;								/* >Left Node Count										*/
	if( ctr==NULL ){ return NULL; }		/* ( No Node ) */
	if( ctr->op!=0x00 && ctr->op!=0xFF ){
		lc=lcntg(ctr->l); return( idx<=lc-1 ? lptrg(ctr->l,idx) : lptrg(ctr->r,idx-lc) );
	}
	return( idx==0?ctr:NULL );
}
