/*** FLEX.L - Scanner Definition [ => lex.yy.c ] ***/

%{
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N***O***P***Q***R***S***T****/
#include	"main.h"					// "TwinTail_de_AngelMode!!" System Header File
#include	"fsup.c"					// Flex(1) Support Code in C-Lang
#include	"y.tab.h"					// TokenID Definition Table Generated by Bison(1)
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N***O***P***Q***R***S***T****/
%}

%option		noyywrap nounput yylineno
%x			X_CODE X_DATA X_RDLL X_RDRR X_WRLL X_WRRR X_CSTR X_HERE X_RENE X_BKQT X_IGNR
%s			S_OPER S_IMED S_KEEP        INITIA

int_cnst	[0-9]+
ip_addr		[0-9]+[ \t]*(\.[ \t]*[0-9]+){3}

hex_cnst	0[xX][0-9a-fA-F]+
dec_cnst	0[dD][0-9]+
oct_cnst	0[oO][0-7]+
bin_cnst	0[bB][0-1]+
embx		\\[xX][0-9a-fA-F]{2}

dbl_cnst1	([0-9]+\.[0-9]*)([eE][+-]?[0-9]+)?
dbl_cnst2	([0-9]*\.[0-9]+)([eE][+-]?[0-9]+)?
dbl_cnst3	([0-9]+)([eE][+-]?[0-9]+)

id_name		[a-zA-Z_][a-zA-Z_0-9]*
fp_code		(:code)|(__code__)
fp_data		(:data)|(__data__)

eoln		([ \t;]*(#.*)?\n)|([ \t;]*(\/\/.*)?\n)|([ \t;]*(\/\*.*\*\/)?\n)

%%/*1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N***O***P***Q***R***S***T****/

^:[h?]{eoln}	{ disp_colhelp(); set_p(); adj_i(INITIA); return('\n'); }
^:cpu{eoln}		{ dump_cpu();     set_p(); adj_i(INITIA); return('\n'); }
^:mem{eoln}		{ dump_mem();     set_p(); adj_i(INITIA); return('\n'); }
^:ds{eoln}		{ dump_ds ();     set_p(); adj_i(INITIA); return('\n'); }
^:rs{eoln}		{ dump_rs ();     set_p(); adj_i(INITIA); return('\n'); }

^:dt(ab)?[ \t]*{int_cnst}{eoln}		{ tint x=param1(&yytext[4]); dump_dt(x  ); set_p(); adj_i(INITIA); return('\n'); }
^:dt(ab)?[ \t]*{hex_cnst}{eoln}		{ tint x=param1(&yytext[4]); dump_dt(x  ); set_p(); adj_i(INITIA); return('\n'); }
^:ct(re|ree)?[ \t]*{int_cnst}{eoln}	{ tint x=param1(&yytext[4]); dump_ct(x,0); set_p(); adj_i(INITIA); return('\n'); }
^:ct(re|ree)?[ \t]*{hex_cnst}{eoln}	{ tint x=param1(&yytext[4]); dump_ct(x,0); set_p(); adj_i(INITIA); return('\n'); }

^[ \t]*{fp_code}{eoln}	{ f(":code"); reinit_code(fn(sx),yylineno-1); set_p(); adj_i(INITIA); return('\n'); }
^[ \t]*{fp_data}{eoln}	{ f(":data"); reinit_data(fn(sx),yylineno-1); set_p(); adj_i(X_DATA); return('\n'); }
<X_DATA>^.*"\n"			{ f("(Ignored)");                             set_p(); adj_i(S_KEEP); return('\n'); }

^:r(ead)?[ \t]+			{ f(":read"); adj_i(X_RDLL); /* SET_P() will be done at <X_RDLL> only!! */ }
^:w(rit|rite)?[ \t]+	{ f(":writ"); adj_i(X_WRLL); /* SET_P() will be done at <X_WRLL> only!! */ }
^:q(uit)?{eoln}			{ f(":quit"); exit(0);                                                     }

<X_RDLL>([^ \t\n]+)|(\"[^\n]+\")	{ f(":name"); set_p(); adj_i(X_RDRR);
/* Check Overflow */
	if( IFT_SIZE<=sx ){ dying("Panic!! - too many files or too deep nests (FileNo=%d) %s", sx, sloc(sx,yylineno)); }
/* Save <New> File Info */
	if( yytext[0]=='"'&&yytext[yyleng-1]=='"' ) sbuf=X_NDUP(&yytext[1],yyleng-2);	/*** "FILENAME" ***/
	else                                        sbuf=X_NDUP(&yytext[0],yyleng  );	/***  FILENAME  ***/
}
<X_RDRR>.*"\n"			{ f("*** Swch To <File> ***"); savchg_f4yy('N',sbuf); adj_i(INITIA); return(SYNC); }

<X_WRLL>([^ \t\n]+)|(\"[^\n]+\")	{ f(":name"); set_p(); adj_i(X_WRRR);
/* Write History */
	if( yytext[0]=='"'&&yytext[yyleng-1]=='"' ) write_history( X_NDUP(&yytext[1],yyleng-2) );	/*** "FILENAME" ***/
	else                                        write_history( X_NDUP(&yytext[0],yyleng  ) );	/***  FILENAME  ***/
}
<X_WRRR>.*"\n"			{ f("*** Save To <File> ***");                        adj_i(INITIA); return('\n'); }

<X_RDLL,X_WRLL>"\n"		{ f("(Err.EOL)"); set_p(); adj_i(INITIA);
	dying("Master!! - illegal :read or :write %s", sloc(sx,yylineno-(yytext[0]=='\n'?1:0)));
}

#.*"\n"					{ f("(Comment)"       ); set_p(); adj_i(INITIA); return('\n'); }
\/\/.*"\n"				{ f("(Comment)"       ); set_p(); adj_i(INITIA); return('\n'); }
"/*"					{ f("(Comment)->Start"); set_x(); adj_i(X_IGNR); }
<X_IGNR>[^\n]			{                                 adj_i(S_KEEP); }
<X_IGNR>"\n"			{                                 adj_i(S_KEEP); }
<X_IGNR>"*/"			{ f("(Comment)->End"  ); set_p(); adj_i(INITIA); }

\"					{ f("<X_CSTR>"); slen=1; sbuf=X_SDUP("" ); set_x(); adj_i(X_CSTR); /* 開始 */ }
\`					{ f("<X_BKQT>"); slen=1; sbuf=X_SDUP("" ); set_x(); adj_i(X_BKQT); /* 開始 */ }
<INITIAL>\/			{ f("<X_RENE>"); slen=2; sbuf=X_SDUP("/"); set_x(); adj_i(X_RENE); /* 開始 */ }
<INITIAL>\<\<"\n"	{ f("<X_HERE>"); slen=1; sbuf=X_SDUP("" ); set_x(); adj_i(X_HERE); /* 開始 */ }
<INITIAL>\<\<		{ f("<X_HERE>"); slen=1; sbuf=X_SDUP("" ); set_x(); adj_i(X_HERE); /* 開始 */ }

<X_CSTR>[^\\\n"]+	{ f("(Append)"); slen+=yyleng; sbuf=X_SCAT(sbuf,yytext); adj_i(S_KEEP); /* 追加 */ }
<X_BKQT>[^\\\n`]+	{ f("(Append)"); slen+=yyleng; sbuf=X_SCAT(sbuf,yytext); adj_i(S_KEEP); /* 追加 */ }
<X_RENE>[^\\\n/]+	{ f("(Append)"); slen+=yyleng; sbuf=X_SCAT(sbuf,yytext); adj_i(S_KEEP); /* 追加 */ }
<X_HERE>"\n"		{ f("(Append)"); slen+=yyleng; sbuf=X_SCAT(sbuf,yytext); adj_i(S_KEEP); /* 追加 */ }
<X_HERE>[^\n]		{ f("(Append)"); slen+=yyleng; sbuf=X_SCAT(sbuf,yytext); adj_i(S_KEEP); /* 追加 */ }

<X_CSTR,X_BKQT,X_RENE>\\[^\n]	{ f("(EscSeq)"); slen+=1; sbuf=X_RALL(sbuf,slen  ); adj_i(S_KEEP);
	sbuf[slen-2]=conv_esc2int(yytext[1]);           sbuf[slen-1]='\0';                             /* Ｃ言語制御文字 */ }
<X_CSTR,X_BKQT,X_RENE>{embx}	{ f("(\\xFF)" ); slen+=1; sbuf=X_RALL(sbuf,slen  ); adj_i(S_KEEP);
	sbuf[slen-2]=strtol(yytext+2,(char **)NULL,16); sbuf[slen-1]='\0';                             /* 任意バイト文字 */ }
<X_CSTR,X_BKQT,X_RENE>\\\n		{ f("(\\\\n)" ); /* Ignore */                       adj_i(S_KEEP); /* 継続改行の指定 */ }

<X_CSTR,X_BKQT,X_RENE>\n		{ f("[Err.\\n]"); set_p(); adj_i(INITIA); flag_exerr=E_SCANER;
	msg_r("Error: illegal end of line (Text=\"%s...\") %s" ,sbuf, sloc(sx,yylineno-1)); return(0);   /* 未完 */ }
<X_HERE><<EOF>>		{ f("[Err.EOF]"); flag_exerr=E_SCANER; gl_colm=x_colm;
	msg_r("Error: illegal end of [[string]] Start at %s" , sloc(x_file,x_line)); return(0);   /* 未完 */ }
<X_IGNR><<EOF>>		{ f("[Err.EOF]"); flag_exerr=E_SCANER; gl_colm=x_colm;
	msg_r("Error: illegal end of /*comment*/ Start at %s", sloc(x_file,x_line)); return(0);   /* 未完 */ }

<X_CSTR>\"			{ f("Type=IMED(S)-New!!"); inst_imedstr(sbuf); set_p(); adj_i(S_OPER); return(IMED); /* 終了 */ }
<X_BKQT>\`			{ f("Type=BKQT(S)-New!!"); inst_imedstr(sbuf); set_p(); adj_i(S_OPER); return(BKQT); /* 終了 */ }
<X_RENE>\/[a-zA-Z]?	{ f("Type=IMED/R/-New!!");
	slen+=yyleng; sbuf=X_SCAT(sbuf,yytext);    inst_imedreg(sbuf); set_p(); adj_i(S_OPER); return(IMED); /* 終了 */ }
<X_HERE>\>\>		{ f("Type=IMED(S)-New!!"); inst_imedstr(sbuf); set_p(); adj_i(S_OPER); return(IMED); /* 終了 */ }

<<EOF>>									{ set_p(); adj_i(INITIA);	/* Reset State!! */
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// Note1: If there is some unscaned & unparsed TT-Script that follows this EOF,
//   we need to continue to process them.  This only applys to [ :read "file" ] syntax.
// Note2:  EVAL() & EVALDOL() strings are literal strings which are evaluated in exec phase.
//   (A) This means that scan & parse phase for mother script is a past event.
//   (B) There is no script to continue to process after EOF, even nested EVAL() string.
	if( FileTb[0].next!=0x00 ){	f("<<EOF>> -> INITIAL *** End of <InclFile> ***"); reschg_f4yy();   return(SYNC);  }
	else{						f("<<EOF>> -> INITIAL *** End of <MainFile> ***"); flag_eofin=TRUE; yyterminate(); }
}

'[^\\\n']'	{ f("Type=IMED(C)-New!!"); inst_imedint(             yytext[1]  ); set_p(); adj_i(S_OPER); return(IMED); }
'\\[^\n]'	{ f("Type=IMED(C)-New!!"); inst_imedint(conv_esc2int(yytext[2]) ); set_p(); adj_i(S_OPER); return(IMED); }
{int_cnst}	{ f("Type=IMED(I)-New!!"); inst_imedint(atol(yytext)            ); set_p(); adj_i(S_OPER); return(IMED); }
{ip_addr}	{ f("Type=IMED(I)-New!!"); tint ip=conv_siphn2tint(yytext);        set_p(); adj_i(S_OPER); /* For SlOC() */
	if( ip<0 ){ flag_exerr=E_SCANER; msg_r("Error: illegal IP address (%s) %s" ,yytext, sloc(sx,yylineno)); return(0); }
                                       inst_imedint(ip                      );                         return(IMED); }
{dbl_cnst1}|{dbl_cnst2}|{dbl_cnst3}		{
              f("Type=IMED(D)-New!!"); inst_imeddbl(atof2(yytext)           ); set_p(); adj_i(S_OPER); return(IMED); }
{hex_cnst}	{ f("Type=IMED(x)-New!!"); inst_imedint(strtol(yytext+2,NULL,16)); set_p(); adj_i(S_OPER); return(IMED); }
{dec_cnst}	{ f("Type=IMED(d)-New!!"); inst_imedint(strtol(yytext+2,NULL,10)); set_p(); adj_i(S_OPER); return(IMED); }
{oct_cnst}	{ f("Type=IMED(o)-New!!"); inst_imedint(strtol(yytext+2,NULL, 8)); set_p(); adj_i(S_OPER); return(IMED); }
{bin_cnst}	{ f("Type=IMED(b)-New!!"); inst_imedint(strtol(yytext+2,NULL, 2)); set_p(); adj_i(S_OPER); return(IMED); }

{id_name}|{fp_code}|{fp_data}|"$$"|"$?"	{ /*** {Keyword|IdName|Special} ***/
int vtmp;
/*** Reserved Keyword ***/
	if( (vtmp=chk_rsvdkeywd(yytext))!=0 ){ set_p(); adj_i(INITIA); return(vtmp); }
/*** IdName|Special ***/
	f("Type=INAM ( LookUp & Installed by Parser not by Scanner!! )");
	yylval.tk.name= X_SDUP(yytext);
	yylval.tk.gl  = flag_global;
	yylval.tk.st  = flag_static;
	yylval.tk.lc  = flag_local;
	yylval.tk.cdx = 0x00;				// Clear!!
	yylval.tk.p_dtab = NULL;			// Clear!!
	yylval.tk.p_elmt = NULL;			// Clear!!
	set_p(); adj_i(S_OPER); return(INAM);
}

"**"		{ f("Type=POW" ); set_p(); adj_i(S_IMED); return(POW ); }
"<>"		{ f("Type=SOP" ); set_p(); adj_i(S_IMED); return(SOP ); }
"><"		{ f("Type=VOP" ); set_p(); adj_i(S_IMED); return(VOP ); }
"++"		{ f("Type=VPP" ); set_p(); adj_i(S_IMED); return(VPP ); }
"--"		{ f("Type=VMM" ); set_p(); adj_i(S_IMED); return(VMM ); }
"<<"		{ f("Type=SLL" ); set_p(); adj_i(S_IMED); return(SLL ); }
">>"		{ f("Type=SRR" ); set_p(); adj_i(S_IMED); return(SRR ); }
"=>"		{ f("Type=PTR" ); set_p(); adj_i(S_IMED); return(PTR ); }

">="		{ f("Type=CGE" ); set_p(); adj_i(S_IMED); return(CGE ); }
"<="		{ f("Type=CLE" ); set_p(); adj_i(S_IMED); return(CLE ); }
"=="		{ f("Type=CEQ" ); set_p(); adj_i(S_IMED); return(CEQ ); }
"!="		{ f("Type=CNE" ); set_p(); adj_i(S_IMED); return(CNE ); }
"~~"		{ f("Type=REQ" ); set_p(); adj_i(S_IMED); return(REQ ); }
"!~"		{ f("Type=RNE" ); set_p(); adj_i(S_IMED); return(RNE ); }
"@~"		{ f("Type=RAT" ); set_p(); adj_i(S_IMED); return(RAT ); }

"+="		{ f("Type=ADDQ"); set_p(); adj_i(S_IMED); return(ADDQ); }
"-="		{ f("Type=SUBQ"); set_p(); adj_i(S_IMED); return(SUBQ); }
"*="		{ f("Type=MULQ"); set_p(); adj_i(S_IMED); return(MULQ); }
"/="		{ f("Type=DIVQ"); set_p(); adj_i(S_IMED); return(DIVQ); }
"%="		{ f("Type=MODQ"); set_p(); adj_i(S_IMED); return(MODQ); }
"**="		{ f("Type=POWQ"); set_p(); adj_i(S_IMED); return(POWQ); }
"<>="		{ f("Type=SOPQ"); set_p(); adj_i(S_IMED); return(SOPQ); }
"><="		{ f("Type=VOPQ"); set_p(); adj_i(S_IMED); return(VOPQ); }

"&="		{ f("Type=ANDQ"); set_p(); adj_i(S_IMED); return(ANDQ); }
"|="		{ f("Type=IORQ"); set_p(); adj_i(S_IMED); return(IORQ); }
"^="		{ f("Type=XORQ"); set_p(); adj_i(S_IMED); return(XORQ); }
"<<="		{ f("Type=SLLQ"); set_p(); adj_i(S_IMED); return(SLLQ); }
">>="		{ f("Type=SRRQ"); set_p(); adj_i(S_IMED); return(SRRQ); }

"&&"		{ f("Type=LAND"); set_p(); adj_i(S_IMED); return(LAND); }
"||"		{ f("Type=LIOR"); set_p(); adj_i(S_IMED); return(LIOR); }
"^^"		{ f("Type=LXOR"); set_p(); adj_i(S_IMED); return(LXOR); }

[ \t]+		{                        adj_i(S_KEEP);               }	/* 空白文字 - Ignored!! */
\\"\n"		{                        adj_i(S_KEEP);               }	/* 継 続 行 - Ignored!! */
"\n"		{ f("\'\\n\'"); set_p(); adj_i(INITIA); return('\n'); }	/* 通常改行             */

")"			{ f("\')\' <- ( Default Rule - S_OPER )"); set_p(); adj_i(S_OPER); return(yytext[0]); }
"]"			{ f("\']\' <- ( Default Rule - S_OPER )"); set_p(); adj_i(S_OPER); return(yytext[0]); }
.			{ f("\'.\' <- ( Default Rule )"         ); set_p(); adj_i(S_IMED); return(yytext[0]); }

%%/*1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N***O***P***Q***R***S***T****/
