/*** MDTYPE.H - A part of MAIN.H ( Included into MAIN.H ) ***/

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// マクロの定義
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// ★ＡＮＳＩカラー表示判定マクロ [ マクロ C_???()/R_???()/W_???() のみ利用 ]
// > 判定対象 = <FILENO> , 判定結果 = TRUE( Should Be Color ) / FALS( Should *Not* Be Color )
#define	sbcolor(FILENO)	(flag_color=='C'||(flag_color=='A'&&isatty(FILENO)))

// ★ＡＮＳＩカラー文字生成マクロ
// > 生成対象 = <FILENO> , 生成結果 = カラー文字列 or 空文字列("") ★環境より自動判定★
// ( Attr:     00=none 01=bold 04=underscore 05=blink 07=reverse 08=concealed					)
// ( FG-Color: 30=black 31=red 32=green 33=yellow 34=blue 35=magenta 36=cyan 37=white			)
// ( BG-Color: 40=black 41=red 42=green 43=yellow 44=blue 45=magenta 46=cyan 47=white			)
#define	C_RED(FILENO)	(sbcolor(FILENO)?"[01;31m"   :"")	/* (Bold)FG=赤色/BG=		*/
#define	C_GRE(FILENO)	(sbcolor(FILENO)?"[01;32m"   :"")	/* (Bold)FG=緑色/BG=		*/
#define	C_YEL(FILENO)	(sbcolor(FILENO)?"[01;33m"   :"")	/* (Bold)FG=黄色/BG=		*/
#define	C_BLU(FILENO)	(sbcolor(FILENO)?"[01;34m"   :"")	/* (Bold)FG=青色/BG=		*/
#define	C_MAG(FILENO)	(sbcolor(FILENO)?"[01;35m"   :"")	/* (Bold)FG=紫色/BG=		*/
#define	C_CYA(FILENO)	(sbcolor(FILENO)?"[01;36m"   :"")	/* (Bold)FG=水色/BG=		*/
#define	C_WHI(FILENO)	(sbcolor(FILENO)?"[01;37m"   :"")	/* (Bold)FG=白色/BG=		*/
#define	C_DEF(FILENO)	(sbcolor(FILENO)?"[00m"      :"")	/* (共通)デフォルト復帰		*/

#define	R_RED(FILENO)	(sbcolor(FILENO)?"[01;30;41m":"")	/* (Bold)FG=黒色/BG=赤色	*/
#define	R_GRE(FILENO)	(sbcolor(FILENO)?"[01;30;42m":"")	/* (Bold)FG=黒色/BG=緑色	*/
#define	R_YEL(FILENO)	(sbcolor(FILENO)?"[01;30;43m":"")	/* (Bold)FG=黒色/BG=黄色	*/
#define	R_BLU(FILENO)	(sbcolor(FILENO)?"[01;30;44m":"")	/* (Bold)FG=黒色/BG=青色	*/
#define	R_MAG(FILENO)	(sbcolor(FILENO)?"[01;30;45m":"")	/* (Bold)FG=黒色/BG=紫色	*/
#define	R_CYA(FILENO)	(sbcolor(FILENO)?"[01;30;46m":"")	/* (Bold)FG=黒色/BG=水色	*/
#define	R_WHI(FILENO)	(sbcolor(FILENO)?"[01;30;47m":"")	/* (Bold)FG=黒色/BG=白色	*/
#define	R_DEF(FILENO)	(sbcolor(FILENO)?"[00m"      :"")	/* (共通)デフォルト復帰		*/

#define	W_RED(FILENO)	(sbcolor(FILENO)?"[01;37;41m":"")	/* (Bold)FG=白色/BG=赤色	*/
#define	W_GRE(FILENO)	(sbcolor(FILENO)?"[01;37;42m":"")	/* (Bold)FG=白色/BG=緑色	*/
#define	W_YEL(FILENO)	(sbcolor(FILENO)?"[01;37;43m":"")	/* (Bold)FG=白色/BG=黄色	*/
#define	W_BLU(FILENO)	(sbcolor(FILENO)?"[01;37;44m":"")	/* (Bold)FG=白色/BG=青色	*/
#define	W_MAG(FILENO)	(sbcolor(FILENO)?"[01;37;45m":"")	/* (Bold)FG=白色/BG=紫色	*/
#define	W_CYA(FILENO)	(sbcolor(FILENO)?"[01;37;46m":"")	/* (Bold)FG=白色/BG=水色	*/
#define	W_WHI(FILENO)	(sbcolor(FILENO)?"[01;37;47m":"")	/* (Bold)FG=白色/BG=白色	*/
#define	W_DEF(FILENO)	(sbcolor(FILENO)?"[00m"      :"")	/* (共通)デフォルト復帰		*/

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// ★PRINT() 互換メッセージ表示マクロ [ 標準エラー出力                                 ]
#define	eprin(FMT,ARG...)	fprintf(stderr,FMT,##ARG)

// ★PRINT() 互換メッセージ表示マクロ [ 標準エラー出力 + プログラムＩＤ表示            ]
#define	msg(FMT,ARG...  )	fprintf(stderr,"%s%s%s: "FMT,C_BLU(2),TTdeAM_CMD,C_DEF(2),##ARG)
#define	msg_g(FMT,ARG...)	fprintf(stderr,"%s%s%s: "FMT,C_GRE(2),TTdeAM_CMD,C_DEF(2),##ARG)
#define	msg_y(FMT,ARG...)	fprintf(stderr,"%s%s%s: "FMT,C_YEL(2),TTdeAM_CMD,C_DEF(2),##ARG)
#define	msg_r(FMT,ARG...)	fprintf(stderr,"%s%s%s: "FMT,C_RED(2),TTdeAM_CMD,C_DEF(2),##ARG)

// ★PRINT() 互換メッセージ表示マクロ [ 標準エラー出力 + プログラムＩＤ表示 + 異常終了 ]
#define	dying(FMT,ARG...  )	fprintf(stderr,"%s%s%s: "FMT,C_RED(2),TTdeAM_CMD,C_DEF(2),##ARG),exit(1)

// ★インデント表示マクロ(デバッグ用)
#define	indent(N)			for( int i=0 ; i<abs(N) ; i++ ){ fprintf(stderr,"    "); }

// ★仮想実行メモリ Segmentation Fault 検査用マクロ
#define	chk_overflow(CTR)	{\
	if( (tint)(mem[0]     )<=mp ){ dying("Panic!! - Out Of MEM[] (mp=%d)\n",mp); }\
	if( (tint)(ds [0].ival)<=dp ){ dying("Panic!! - Out Of DS [] (dp=%d)\n",dp); }\
	if( (tint)(rs [0].mp  )<=rp ){ dying("Panic!! - Out Of RS [] (rp=%d)\n",rp); }\
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// ★組み込み言語機能: エラーチェック用マクロ（トレース情報付き）
#define	chk_point(CTR)	{ if( flag_debug&DF_CTRDP ){ disp_trace(CTR);dump_ct((tint)CTR,0);fflush(NULL); } chk_error(CTR); }
#define	chk_light(CTR)	{ if( flag_debug&DF_CTRDP ){ disp_trace(CTR);                     fflush(NULL); } chk_error(CTR); }
#define disp_trace(CTR)	{				/*** トレース情報出力処理			***/\
	eprin("%s%-12s <Ptr=[%p],Err=%d,Ret=%d,Ctl=%d%d%d>%s MP=%04d _B=%04d DP=%04d _B=%04d RP=%04d FX=%04d\n",\
	C_BLU(2),__func__,CTR,flag_exerr,flag_retning,flag_redo,flag_next,flag_last,C_DEF(2),mp,mp_base,dp,dp_base,rp,fx);\
}

// ★組み込み言語機能:エラーチェック用マクロ
#define chk_error(CTR)	{				/*** NULLorFLAG 即時リターン処理	***/\
	if( CTR==NULL||flag_exerr||flag_retning||(flag_redo||flag_next||flag_last) ){ return(NULL); }\
	last_ct=CTR; epos=0;				/*** LastParam(s) 更新処理			***/\
}

// ★DTAB 変数: 型検査マクロ( OK=>通過 / NG=>Flagセット&NULLリターン ) 注意:'*'は'U'に非マッチ
#define	chk_vtype(P2D,STR,POS)	{ if(flag_exerr){ return(NULL); } epos=POS;\
	if( P2D==NULL ){ flag_exerr=NullPTR; return(NULL); }\
	if     ( P2D->type=='U' ){  if( strchr(STR,'U'      )==NULL ){ flag_exerr=UnDEFD_V; return(NULL); } }\
	else if( strchr(STR,'*')==NULL&&strchr(STR,P2D->type)==NULL ){ flag_exerr=NgTYPE_V; return(NULL); } }

// ★DTAB 関数: 型検査マクロ( OK=>通過 / NG=>Flagセット&NULLリターン ) 注意:'*'は'U'に非マッチ
#define	chk_ftype(P2D,STR    )	{ if(flag_exerr){ return(NULL); }               \
	if( P2D==NULL ){ flag_exerr=NullPTR; return(NULL); }\
	if     ( P2D->type=='U' ){  if( strchr(STR,'U'      )==NULL ){ flag_exerr=UnDEFD_F; return(NULL); } }\
	else if( strchr(STR,'*')==NULL&&strchr(STR,P2D->type)==NULL ){ flag_exerr=NgTYPE_F; return(NULL); } }

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// ★数値{整数値|実数値} ＆ 参照{文字列|ポインタ} の取得マクロ ( 型指定 )
#define	cint(P2D)	( (P2D)->type=='I' ? (P2D)->ival : (tint)((P2D)->type=='D'?(tint)((P2D)->dval):(tint)((P2D)->ptr)) )
#define	cdbl(P2D)	( (P2D)->type=='D' ? (P2D)->dval : (tdbl)((P2D)->type=='I'?(tdbl)((P2D)->ival):(tint)((P2D)->ptr)) )
#define	cstr(P2D)	( (P2D)->type=='S' ? (P2D)->str  : (char*)((P2D)->ptr) )	/* (CHAR*) S->P */
#define	cptr(P2D)	( (P2D)->type=='P' ? (P2D)->ptr  : (void*)((P2D)->str) )	/* (VOID*) P->S */

// ★行列情報の{制御|設定|取得}マクロ
#define	matx_ena(P2D)		{ if((P2D)->type=='A'){ (P2D)->attr|= ATTR_MAID; (P2D)->ival=0; } }
#define	matx_dis(P2D)		{ if((P2D)->type=='A'){ (P2D)->attr&=~ATTR_MAID; (P2D)->ival=0; } }
#define	matx_setrow(P2D,N)	{ if((P2D)->attr&ATTR_MAID){\
	int R=(((P2D)->ival)>>16)&0xFFFF; int C=((P2D)->ival)&0xFFFF; if(N>R) (P2D)->ival=((N)<<16)|(C); } }
#define	matx_setcol(P2D,N)	{ if((P2D)->attr&ATTR_MAID){\
	int R=(((P2D)->ival)>>16)&0xFFFF; int C=((P2D)->ival)&0xFFFF; if(N>C) (P2D)->ival=((R)<<16)|(N); } }
#define	matx_getrow(P2D  )	( (P2D)->attr&ATTR_MAID ? (((P2D)->ival)>>16)&0xFFFF : 0 )
#define	matx_getcol(P2D  )	( (P2D)->attr&ATTR_MAID ? (((P2D)->ival)    )&0xFFFF : 0 )

// ★標準Ｃ関数の安全対策マクロ ( NULL対策 ＆ NULL終端 )
#define	strlen2(SRC    )	( (SRC)==NULL ? ( 0 ) : strlen((SRC)      )                    )
#define	strcpy2(DST,SRC)	( (SRC)==NULL ? (DST) : strcpy((DST),(SRC))                    )
#define	strcat2(DST,SRC)	( (SRC)==NULL ? (DST) : strcat((DST),(SRC))                    )
#define	strncpy2(DST,SRC,N)	( (SRC)==NULL ? (DST) : (*(DST)='\0',strncat((DST),(SRC),(N))) )
#define	strncat2(DST,SRC,N)	( (SRC)==NULL ? (DST) : (            strncat((DST),(SRC),(N))) )

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// データ型の定義
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
typedef	intptr_t	tint;				// DTAB 用符号付き整数型(ポインタ互換)	- 通常  ６４ビット
#define	PRIdTINT	PRIdPTR				// printf("%d",tint) 用書式指定マクロ
#define	PRIiTINT	PRIiPTR				// printf("%i",tint) 用書式指定マクロ
#define	PRIoTINT	PRIoPTR				// printf("%o",tint) 用書式指定マクロ
#define	PRIuTINT	PRIuPTR				// printf("%u",tint) 用書式指定マクロ
#define	PRIxTINT	PRIxPTR				// printf("%x",tint) 用書式指定マクロ
#define	PRIXTINT	PRIXPTR				// printf("%X",tint) 用書式指定マクロ
typedef	     double	tdbl;				// DTAB 用実数型(２倍精度実数)			- 通常  ６４ビット
#define	PFX_TDBL	""					// printf("%[AaEeFfGg]",tdbl) 用書式指定マクロ(Prefix部)
#define	M_Ex		M_E
#define	M_PIx		M_PI
#define	atoi2(SRC)				( (SRC)==NULL ? ( 0 ) : atoi   ((SRC)     ) )
#define	atof2(SRC)				( (SRC)==NULL ? (0.0) : strtod ((SRC),NULL) )

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// 構造体型の定義
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
typedef struct dtab{					/* DTAB: データテーブル(Data-TABle)要素型				*/
/*----------------------------------------------------------------------------------------------*/
	char	*name;						// >識別子名
	struct dtab *base;	char	*ukey;	// >要素元DTAB【X_RALL()未対応】、及び、ハッシュキー(Ukey)
	char	type;		int		attr;	// >データ型、及び、データ属性

// 'U' = 未定義状態 又は UnDefined		- 有効項目: N/A
// 'S' = 通常文字列 又は String			- 有効項目: { Attr=EDOL/FALS } str=(char*)    & ptr =FILE
//     = /RE/文字列 又は /RE/			- 有効項目: { Attr=Don'tCare } str=(char*)    & ptr2=/RE/
// 'I' = 整数値     又は Tint Value		- 有効項目: ival(論理型は [ival=TRUE|FALS] で表現)
// 'D' = 実数値     又は Tdbl Value		- 有効項目: dval(２倍精度実数、又は、４倍精度実数)
// 'P' = ポインタ値 又は Pointer		- 有効項目: { Attr=FPCD/FALS } ptr=NULL/SIG_DFL/SIG_IGN/SIG_ERR 又は FILE
// 'X' = システム定義関数 又は SysFunc	- 有効項目: { (Attr&FXID)=00 } ptr=&i_func()  & ival=ARGC
//     = ユーザー定義関数 又は UsrFunc	- 有効項目: { (Attr&FXID)=FX } ptr=NULL       & ival=ARGC
// 'A' = 統合配列(Arry[Idx]&Hash[Idx])	- 有効項目: { Attr=STID/MAID } ptr=Std.Arry[] & ptr2=Ext.Hash[] (ival=RowXCol)
// 'R' = 参照配列(Str [Idx]&Ptr [Idx])	- 有効項目: { Attr=slen/INVA } str=OBJ ival=IDX ptr=ORG

	char	*str;						/* >Pointer to String									*/
	tint	ival;						/* >(tint) Value  { 印刷時は "%"PRI[dx ]TINT を使用 }	*/
	tdbl	dval;						/* >(tdbl) Value  { 印刷時は "%"PRI[efg]TDBL を使用 }	*/
	void	*ptr;						/* >Pointer       { 印刷時は "%p"            を使用 }	*/
	void	*ptr2;						/* >Pointer2      { 印刷時は "%p"            を使用 }	*/
	struct dtab *link;					/* >{ Std.Arry[]=多次元Link | Ext.Hash[]=データLINK }	*/
}dtab;		/// dtab[0].ival => (Admin) Alloc Cntr ///

/*----------------------------------------------------------------------------------------------*/
typedef struct rtab{					/* RTAB: レジスタテーブル(Register-TABle)要素型			*/
/*----------------------------------------------------------------------------------------------*/
	int		mp,mp_base;					/* >Main Memory Pointer (MP) & MP Base					*/
	int		dp,dp_base;					/* >Data Stack  Pointer (DP) & DP Base					*/
	int 	fx;							/* >FuncXX Index [ 0=MAIN() / 1,2,3,...=(UsrDef)Func ]	*/
	int 	sx;							/* >Script Index [ 0=NoData / 1,2,3,...              ]	*/
	int 	mode;						/* >Exec Mode    [ Norm | Intr | Eval | Fltr | ${..} ]	*/
	void	*ptr;						/* >( Hold MEM[] for EvalDol() )						*/
}rtab;		/// rtab[0].mp => (Admin) Alloc Cntr ///

/*----------------------------------------------------------------------------------------------*/
typedef struct ctree{					/* CTREE: 構文木(Common Syntax Tree)ノード型			*/
/*----------------------------------------------------------------------------------------------*/
	int		op;							/* >Operator                [ Leaf Node = 0x00|0xFF   ]	*/
	int		file;						/* >TT-Script FileTb Number [ File=0,1,2,...          ]	*/
	int		line;						/* >TT-Script Line   Number [ Line=  1,2,3,...(N/A=0) ]	*/
	int		colm;						/* >TT-Script Colm   Number [ Colm=  1,2,3,...(N/A=0) ]	*/
	int		init;						/* >Init Flag for ST_DTAB!! [*** 0=NotYet / 1=Done ***]	*/
	struct ctree *l,*r,*x;				/* >Pointer to L/R/X Node   [ Leaf Node = CDX |P_DTAB ]	*/
}ctree;

/*----------------------------------------------------------------------------------------------*/
typedef struct tkval{					/* TKVAL: YYLVAL用トークン値(ToKen VALue)データ型		*/
/*----------------------------------------------------------------------------------------------*/
/// NOTE: IT IS REQUIRED TO REDEFINE TKVAL HERE, BECAUSE BISON.Y DEFINITION IS OUT OF SCOPE !! ///
	char	*name;						/*> Pointer to VNAM Name or FILENAME					*/
	int		gl,st,lc;					/*> Flag for {GLOBAL|STATIC|LOCAL} Scope    (TRUE/FALS)	*/
	intptr_t     cdx;					/*> Composite DTAB Index (CDX) Value -> Full Specifier	*/
	struct dtab  *p_dtab;				/*> Pointer to DTAB					 -> Full Specifier	*/
	struct ctree *p_elmt;				/*> Pointer to Arry[] Elmt or NULL	 -> Full Specifier	*/
	int		file,line,colm;				/*> TT-Script File/Line/Colm Number						*/
}tkval;

/*----------------------------------------------------------------------------------------------*/
typedef struct ftab{					/* FTAB: ファイルテーブル(File-TABle)要素型				*/
/*----------------------------------------------------------------------------------------------*/
	int		alloc,valid;				/* Alloc Size & Valid Size								*/
	char	*path;						/* Current Path Name		( NULL = N/A       )		*/
	char	*name;						/* File Name				( NULL = N/A       )		*/
	char	**linv;						/* Line Vect				( NULL = N/A       )		*/
// 本来は YY_BUFFER_STATE ybuf; とすべきですが、YY_BUFFER_STATE はスキャナーコード内でしか有効に
// ならないので、ここでは void *ybuf; としています。( YY_BUFFER_STATE は構造体へのポインタです。)
	void	*ybuf;						/* (Temp) YY_BUFFER_STATE	( NULL = N/A       )		*/
	int		ylin;						/* (Temp) Line Number	    ( 0 = No Data      )		*/
	int		mode;						/* Exec Mode = { 'N'orm|'I'ntr|'E'val|'$'{...} }		*/
	int		next,prev;					/* Next Index / Prev Index	( 0 = End Of Link  )		*/
}ftab;
