/*** I_SOCKET.C ***/					#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
// MK_SOCKET() - make & return {TCP|UDP|RAW} socket with BIND(2).  On error -1 is returned.
// If possilbe, it will enable broadcast TX for UDP. ( Pointer NULL is treated as integer 0. )
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
int mk_socket(int ip_proto,int flag_bind,dtab *p2ip,dtab *p2port){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
struct sockaddr_in lo_addr;				// {Local|******} Internet Address (IP+Port)
struct ip_mreq mreq;					// Struct for Multicast Address
tint	t_ip,t_port;					// IP Address / Port Number
int		sock,opt,ret;					// Socket for Network / Option Value / Return Value

/*** [0] Assign IP Address & Port Number ***/
	if( p2ip  ==NULL ){ t_ip  =0; }else{ t_ip  =(p2ip  ->type=='S')?str_iphn2tint(         p2ip  ->str):cint(p2ip  ); }
	if( p2port==NULL ){ t_port=0; }else{ t_port=(p2port->type=='S')?str_posn2tint(ip_proto,p2port->str):cint(p2port); }
	if( t_ip<0 || t_port<0 )			// Error!!
		return INVA;

/*** [1] Make {TCP|UDP|RAW} Socket ***/
	switch(ip_proto){
		case 'U': sock = socket(PF_INET,SOCK_DGRAM ,IPPROTO_UDP ); break;
		case 'T': sock = socket(PF_INET,SOCK_STREAM,IPPROTO_TCP ); break;
		case 'R': sock = socket(PF_INET,SOCK_RAW   ,IPPROTO_ICMP); break;
		default: return INVA;
	}
	if( sock<0 )						// Error!!
		return INVA;

/*** [2] Enable Broad Cast ( UDP Only!! ) ***/
// 可能であれば、ブロードキャスト送信ができるようにしておく。(送信用。なお、できなくても構わない。)
	if( ip_proto=='U' ){
		opt = 1;							// Enable
		setsockopt( sock, SOL_SOCKET, SO_BROADCAST, &opt, sizeof(opt) );
	}

/*** [3] Do Bind ( Option!! ) ***/
// バインドが指定されている時は、作成したソケットに対してバインドする。(これは、ローカルアドレス。)
	if( flag_bind ){
		memset(&lo_addr,0,sizeof(lo_addr));		/* Zero Clear!!									*/
		lo_addr.sin_family      = AF_INET;		/* Address Family = Intenet						*/
		lo_addr.sin_addr.s_addr = htonl(t_ip  );/* IP Address  (32Bit) [ Network Byte Order ]	*/
		lo_addr.sin_port        = htons(t_port);/* Port Number (16Bit) [ Network Byte Order ]	*/
		ret = bind( sock, (struct sockaddr *)&lo_addr, sizeof(lo_addr) );
		if( ret<0 )
			return INVA;
	}

/*** [4] Enable Multi Cast ( UDP Only!! ) ***/
// もし、IPアドレスがマルチキャストアドレスならば、それを受信できるようにしておく。(受信用。)
	if( (t_ip&0xF0000000)==0xE0000000 ){		/* IP = 1110.XXXX.XXXX.XXXX						*/
		memset(&mreq,0,sizeof(mreq));			/* Zero Clear!!									*/
		mreq.imr_interface.s_addr = INADDR_ANY;	/* IP Address  (32Bit) [ Network Byte Order ]	*/
		mreq.imr_multiaddr.s_addr = htonl(t_ip);/* IP Address  (32Bit) [ Network Byte Order ]	*/
		ret = setsockopt( sock, IPPROTO_IP, IP_ADD_MEMBERSHIP, (char *)&mreq, sizeof(mreq) );
		if( ret<0 )
			return INVA;
	}

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] mk_socket() -> socket=%d\n", C_CYA(2), C_DEF(2), sock); }

/*** [5] Return Socket ***/
	return sock;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_sockname(ctree *ctr){			/*** TT-Lang: A = SOCKNAME(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a[10],*s;					int		cnt;
struct sockaddr_in lo_addr,re_addr;		// {Local|Remote} Ineternet Address (IP+Port)
struct servent *p_dbase;				// Pointer to DataBase-Element for Service
int		len,opt,ret;					// Length of Data / Option Value / Return Value

/* Set Param(s) & Check Type(s) */
	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 1:	s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"ID",0);
				break;
		default:
			flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=1,epar[2]=1; return NULL;
	}
	ans = ext_ctrdtabmult(ctr,10);
	for( int i=0 ; i<10 ; i++ )
		a[i] = ctr2p_dtab(lptr(ans,i));

/* Do SOCKNAME()!! */

/*** Local Info ***/
	len = sizeof(lo_addr);				// LO IP&Port
	ret = getsockname( cint(s), &lo_addr, (unsigned int *)&len );

	if( ret<0 || lo_addr.sin_family!=AF_INET )
		for( int i=0 ; i< 5 ; i++ ){ null_dtab(a[i]); }
	else{
	/* ( IP   ) */
		a[0]->type='I'; a[0]->ival=ntohl           (lo_addr.sin_addr.s_addr) ;
		a[1]->type='S'; a[1]->str =X_SDUP(inet_ntoa(lo_addr.sin_addr       ));
	/* ( Port ) */
		a[2]->type='I'; a[2]->ival=ntohs           (lo_addr.sin_port       ) ;

		opt = 0; len = sizeof(opt);		// LO Option
		ret = getsockopt( cint(s), SOL_SOCKET, SO_TYPE, &opt, (unsigned int *)&len );
		if( opt==SOCK_DGRAM || opt==SOCK_STREAM )
			p_dbase = getservbyport( lo_addr.sin_port, (opt==SOCK_DGRAM)?"udp":"tcp" );
		else
			p_dbase = NULL;
		if( ret<0 || p_dbase==NULL ){ null_dtab(a[3]); }
		else{
			a[3]->type='S'; a[3]->str =X_SDUP(p_dbase->s_name);
		}
	/* ( Type ) */
		if( ret<0                  ){ null_dtab(a[4]); }
		else{
			if( opt==SOCK_DGRAM || opt==SOCK_STREAM )
				{ a[4]->type='S'; a[4]->str =(opt==SOCK_DGRAM)?"UDP":"TCP";                  }
			else						// On raw sockets sin_port is set to the IP protocol. ( See: man 7 ip )
				{ a[4]->type='S'; a[4]->str =(opt==SOCK_RAW  )?"RAW":"???"; null_dtab(a[2]); }
		}
	}

/*** Remote Info ***/
	len = sizeof(re_addr);				// RE IP&Port
	ret = getpeername( cint(s), &re_addr, (unsigned int *)&len );

	if( ret<0 || re_addr.sin_family!=AF_INET )
		for( int i=5 ; i<10 ; i++ ){ null_dtab(a[i]); }
	else{
	/* ( IP   ) */
		a[5]->type='I'; a[5]->ival=ntohl           (re_addr.sin_addr.s_addr) ;
		a[6]->type='S'; a[6]->str =X_SDUP(inet_ntoa(re_addr.sin_addr       ));
	/* ( Port ) */
		a[7]->type='I'; a[7]->ival=ntohs           (re_addr.sin_port       ) ;

		opt = 0; len = sizeof(opt);		// RE Option
		ret = getsockopt( cint(s), SOL_SOCKET, SO_TYPE, &opt, (unsigned int *)&len );
		if( opt==SOCK_DGRAM || opt==SOCK_STREAM )
			p_dbase = getservbyport( re_addr.sin_port, (opt==SOCK_DGRAM)?"udp":"tcp" );
		else
			p_dbase = NULL;

		if( ret<0 || p_dbase==NULL ){ null_dtab(a[8]); }
		else{
			a[8]->type='S'; a[8]->str =X_SDUP(p_dbase->s_name);
		}
	/* ( Type ) */
		if( ret<0                  ){ null_dtab(a[9]); }
		else{
			if( opt==SOCK_DGRAM || opt==SOCK_STREAM )
				{ a[9]->type='S'; a[9]->str =(opt==SOCK_DGRAM)?"UDP":"TCP";                  }
			else						// On raw sockets sin_port is set to the IP protocol. ( See: man 7 ip )
				{ a[9]->type='S'; a[9]->str =(opt==SOCK_RAW  )?"RAW":"???"; null_dtab(a[7]); }
		}
	}

	return ans;
}
