/*** I_XRAND.C ***/						#include	"main.h"

static int flag_srand=FALS;				/* Flag for SRAND() Execution (T/F)						*/

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_srand(ctree *ctr){				/*** TT-Lang: VOID = RAND(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do SRAND()!! */
	flag_srand=TRUE; srand(cint(x));
	void_dtab(a); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_rand(ctree *ctr){				/*** TT-Lang: A = RAND(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
struct timeval tv;						/* Struct for GETTIMEOFDAY()							*/

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do RAND()!! */						// Ans = 0,1,2, ... ,X-1
	if( flag_srand==FALS )
		{ flag_srand=TRUE; gettimeofday(&tv,NULL); srand( (unsigned int)((tv.tv_sec)^(tv.tv_usec)) ); }
	a->type='I'; a->ival=(tint)( (rand()/(RAND_MAX+1.0))*cint(x) ); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_urand(ctree *ctr){				/*** TT-Lang: A = URAND() ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans;			dtab	*a;
struct timeval tv;						/* Struct for GETTIMEOFDAY()							*/

/* Set Param(s) & Check Type(s) */
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do URAND()!! */						// Ans = Uniform RAND() { 0.0 < Ans < 1.0 }
	if( flag_srand==FALS )
		{ flag_srand=TRUE; gettimeofday(&tv,NULL); srand( (unsigned int)((tv.tv_sec)^(tv.tv_usec)) ); }
	a->type='D'; a->dval=(rand()+1.0)/(RAND_MAX+2.0); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_nrand(ctree *ctr){				/*** TT-Lang: A = NRAND()|NRAND(X,Y) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;		int		cnt;
struct timeval tv;						/* Struct for GETTIMEOFDAY()							*/
tdbl	ave,dev,srd,ur1,ur2;

/* Set Param(s) & Check Type(s) */
	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 0: ave=0.0; dev=1.0; break;		// Standard Normal Distribution //
		case 2:									// General  Normal Distribution //
			x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
			y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);
			ave = cdbl(x); dev = cdbl(y); break;
		default: flag_exerr=NgARGCnn; epar[0]=cnt,epar[1]=0,epar[2]=2,epar[3]=INVA; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do NRAND()!! */						// Ans = Normal Dist RAND() { X=Ave / Y=StdDev }
	if( flag_srand==FALS )
		{ flag_srand=TRUE; gettimeofday(&tv,NULL); srand( (unsigned int)((tv.tv_sec)^(tv.tv_usec)) ); }
	ur1 = (rand()+1.0)/(RAND_MAX+2.0);
	ur2 = (rand()+1.0)/(RAND_MAX+2.0);
	srd = sqrt(-2.0*log(ur1))*sin(2.0*M_PIx*ur2);
	a->type='D'; a->dval=ave+dev*srd; return ans;
}
