/*** ARRYHS-MAIN.C ***/					#include	"main.h"

/************************************************************************************************/
// CA2P_DTAB() translates CTREE ARRY & CTREE STID into pointer to its DTAB Elmt.
// ( It will make new Arry-Table, Hash-Table and/or Elmt on its 1st reference )
/************************************************************************************************/
dtab *ca2p_dtab(ctree *ptr){			/* (CTREE*) Arry[Key,Key,Key,...] => (DTAB*) Elmt		*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*a,*k,*e;						/* Pointer to Arry/Key/Elmt								*/
char	*ukey=NULL;		int		idx[MAX_SADIM],dim,i;

/* Set Param(s) & Check Type(s) */
	if( ptr->op!=ARRY && ptr->op!=STID ) return NULL;
	a   = ctr2p_dtab( eva_expr(last_ar=ptr->l,1) );	if(a  ==NULL) return NULL;
	dim = lcnt(ptr->r);								if(dim==0   ) return NULL;
	if( ptr->op==STID ){ a->attr |= ( ATTR_STID); }
	else               { a->attr &= (~ATTR_STID); }
	dim = ckasgn_saidx(ptr->r,idx); if( flag_exerr ) return NULL;
/* Std.Arry[] */
	if( dim!=0 && ((a->type!='S'&&a->type!='P')||isnull(a)) ){
		e = dn2p_dtab(a,idx,dim); return(e);
	}
/* Ext.Arry[] */
	dim = lcnt(ptr->r);
	if( dim==1 ){												// dim==1
		k = ctr2p_dtab( eva_expr(ptr->r,1) );	if(k==NULL) return NULL;
		if( (a->type=='S'||a->type=='P') && k->type=='I' && !isnull(a) )	// STR[IDX] | PTR[IDX]
			{ e = ri2p_dtab(a,k->ival); return(e); }
		if( k->type=='S' && (k->str)[0]==0x1C )								// RAW Ukey
			ukey = k->str;
		else
			if( (ukey=mk_ukey(ukey,k)) == NULL ){ return NULL; }
		e = du2p_dtab(a,ukey); return(e);
	}
	else{														// dim>=2
		for( i=0 ; i<dim ; i++ ){
			k = ctr2p_dtab( eva_expr(lptr(ptr->r,i),1) );
			if( (ukey=mk_ukey(ukey,k)) == NULL ){ return NULL; }
		}
		e = du2p_dtab(a,ukey); return(e);
	}
}

/************************************************************************************************/
// DI2P_DTAB() translates Std.Arry[] (Arry[Ival]) into pointer to its DTAB Elmt.
// ( It will make new Arry-Table, Hash-Table and/or Elmt on its 1st reference. )
/************************************************************************************************/
dtab *di2p_dtab(dtab *a,int idx){ return(dn2p_dtab(a,&idx,1)); }
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

/************************************************************************************************/
// DM2P_DTAB() translates Matrix into pointer to its DTAB Elmt. [ Vector -> DI2P_DTAB() ]
// ( It will make new Arry-Table, Hash-Table and/or Elmt on its 1st reference. )
/************************************************************************************************/
dtab *dm2p_dtab(dtab *a,int row,int col){ int idx[2]; idx[0]=row; idx[1]=col; return(dn2p_dtab(a,idx,2)); }
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

/************************************************************************************************/
// DN2P_DTAB() translates Std.Arry[] (Arry[Ival,Ival,Ival, ... ]) into pointer to its DTAB Elmt.
// ( It will make new Arry-Table, Hash-Table and/or Elmt on its 1st reference. )
/************************************************************************************************/
dtab *dn2p_dtab(dtab *a,int idx[],int dim){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	**p2p,*e,u;						/* Pointer to Ptr2Dbar & Elmt | Dummy for Ukey			*/
char	*ukey=NULL;		int		i,t,flag_exthash=FALS;

/* Check Index ( Ext.Hash[] ) */
	for( i=0 ; i<dim ; i++ ){ if( idx[i]<0 || MAX_SAIDX<=idx[i] || i>MAX_SADIM ){ flag_exthash=TRUE; break; } }
	if( flag_exthash==TRUE ){
		init_dtab(&u); u.type='I'; for( i=0 ; i<dim ; i++ ){ u.ival=idx[i]; ukey=mk_ukey(ukey,&u); }
		return du2p_dtab(a,ukey);				// matx_dis(a) in du2p_dtab()
	}
/* Init Arry[] */
	if( a->type!='A' ){ init_dtab(a); a->type='A'; if( dim<=2 ) matx_ena(a); }
/* Init Dtab BAR */
	p2p=(dtab**)&(a->ptr); e=a->ptr;
	for( i=0 ; i<dim ; i++ ){
		if( e==NULL ){
			e = *p2p = X_MALL(sizeof(dtab)*MAX_SAIDX);
			for( t=0 ; t<MAX_SAIDX ; t++ ){ init_dtab(&e[t]); }
		}
		p2p = (i==dim-1) ? NULL      :&(e[idx[i]].link);
		e   = (i==dim-1) ? &e[idx[i]]: (e[idx[i]].link);
	}
/* Init Base & Ukey in Elmt */
	init_dtab(&u); u.type='I';
	for( i=0 ; i<dim ; i++ ){
		u.ival=idx[i];
		if( (ukey=mk_ukey(ukey,&u)) == NULL ) return(NULL);
	}
	e->base = a;						/* Base - Valid for this refs only !!					*/
	e->ukey = ukey;						/* Ukey - Valid for this refs only !!					*/
/* Renew Raw&Col (Matrix) */
	if( dim==1 ){ matx_setrow(a,       0); matx_setcol(a,idx[0]+1); }	/*** Vector ***/
	if( dim==2 ){ matx_setrow(a,idx[0]+1); matx_setcol(a,idx[1]+1); }	/*** Matrix ***/
/* Return */
	return(e);
}

/************************************************************************************************/
// DU2P_DTAB() translates Ext.Arry (Arry[Ukey]) | Strt.Id into pointer to its DTAB Element.
// ( It will make new Arry-Table, Hash-Table and/or Elmt on its 1st reference. )
/************************************************************************************************/
dtab *du2p_dtab(dtab *a,char *ukey){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*e,*h;							/* Pointer to Elmt										*/
int		hval,i,j;

/* Init Arry[] */
	if( a->type!='A' ){ init_dtab(a); a->type='A'; }
	matx_dis(a);
/* Init Dtab BAR */
	if( a->ptr2==NULL ){
		a->ptr2=X_MALL(sizeof(dtab)*MAX_EHIDX);
		for( i=0,h=a->ptr2 ; i<MAX_EHIDX ; i++ ){ init_dtab(&h[i]); }
	}
	h=a->ptr2;
/* Seek & Retn ELMT */
	hval = fx_hash(ukey)%MAX_EHIDX;				/* Calc Hash Value								*/
	e=h[hval].link;								/* First DTAB at Synonym List					*/
	for( j=0 ; j<h[hval].ival ; j++ ){			/* For All Synonyms in HVAL						*/
		if( strcmp(ukey,e[j].ukey)==0 )			/* Compare: Ukey v.s. Ukey						*/
			return(&e[j]);						/*** Found!! ***/
	}
/* Rall & Init ELMT */
	h[hval].ival++;
	h[hval].link = X_RALL( h[hval].link , sizeof(dtab)*h[hval].ival );
	e=h[hval].link; j=h[hval].ival-1;			/* e[j] = Last DTAB at Synonym List ( New )		*/
	init_dtab(&e[j]);
/* Renew Base & Ukey in Elmt */
	e[j].base = a;						/* Base - Valid for this refs only !!					*/
	e[j].ukey = ukey;					/* Ukey - Valid for this refs only !!					*/
/* Return */
	return(&e[j]);
}

/************************************************************************************************/
// DS2P_DTAB() translates "DTAB[STR]" into pointer to its DTAB Elmt.
// ( It will make new Arry-Table, Hash-Table and/or Elmt on its 1st reference. )
/************************************************************************************************/
dtab *ds2p_dtab(dtab *a,char *str){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*e,k;							/* Pointer to Elmt | Temp DTAB for Making UKey			*/
char	*ukey=NULL;						/* Pointer to Ukey										*/

/* Make Ukey */
	init_dtab(&k); k.type='S'; k.str=str;
	if( (ukey=mk_ukey(ukey,&k))==NULL ) return(NULL);
	e = du2p_dtab(a,ukey);
/* Renew Base & Ukey field in Elmt */
	e->base = a;						/* Base - Valid for this refs only !!					*/
	e->ukey = X_SDUP(ukey);				/* Ukey - Valid for this refs only !!					*/
/* Return */
	return(e);
}

/************************************************************************************************/
// RI2P_DTAB() translates STR[IDX]|PTR[IDX] into reference to its DATA.
// It will always generate & return new 'R'efer DTAB for later use.
// 'R'efer DTAB is required because STR[IDX]|PTR[IDX] can be LVAL & RVAL.
/************************************************************************************************/
dtab *ri2p_dtab(dtab *a,int idx){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*r;								/* Pointer to Refs										*/

/* Make Refs ( Alloc & Init ) */
	r = X_MALL(sizeof(dtab)); init_dtab(r);
	r->type = 'R';
	r->attr = (a->type=='P') ? INVA    :strlen2(a->str);	// String Length
	r->str  = (a->type=='P') ? (a->ptr):       (a->str);	// Pointer to Object
	r->ival = idx;											// Index Value
	r->ptr  = a;											// Pointer to Original-DTAB
/* Return */
	return(r);
}

static dtab *_p_elmt(dtab *e,int *p_cnt,int n){
dtab	*t;
	for( int i=0 ; i<MAX_SAIDX ; i++ ){			// For All Dtab BAR
		if(e[i].type!='U' ){ if( *p_cnt==n ){ return &e[i]; }else{ (*p_cnt)++; } }
		if(e[i].link!=NULL){ if( (t=_p_elmt(e[i].link,p_cnt,n))!=NULL ) return(t); }
	}
	return(NULL);
}

/************************************************************************************************/
// P_ELMT() retuns pointer to N'th (N) Elmt in Arry&Hash (X).  It retuns NULL on error.
/************************************************************************************************/
dtab *p_elmt(dtab *x,int n){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*e,*h,*t;						/* Pointer to Elmt										*/
int		cnt=0;							/* Elmt Counter ( 0,1,2, ... )							*/

/* Arry[] */
	if( (e=x->ptr )!=NULL ){ if( (t=_p_elmt(e,&cnt,n))!=NULL ) return(t); }
/* Hash[] */
	if( (h=x->ptr2)!=NULL ){
		for( int i=0 ; i<MAX_EHIDX ; i++ ){		// For All Dtab BAR
			if( (e=h[i].link) == NULL ) continue;
			for( int j=0 ; j<h[i].ival ; j++ ){		// For All Synon(s)
			/* >>Seek Elmt ( Skip Empty ) */
				if( e[j].type=='U' ) continue;
				if( cnt==n ){ return &e[j]; }
				cnt++;
			}
		}
	}
/* Return */
	return NULL;		/*** No Elmt left!! ***/
}

static void _n_elmt(dtab *e,int *p_cnt){
	for( int i=0 ; i<MAX_SAIDX ; i++ ){			// For All Dtab BAR
		if(e[i].type!='U' ) (*p_cnt)++;
		if(e[i].link!=NULL) _n_elmt(e[i].link,p_cnt);
	}
}

/************************************************************************************************/
// N_ELMT() retuns Number of Elmt in Arry&Hash (X).
/************************************************************************************************/
int n_elmt(dtab *x){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*e,*h;							/* Pointer to Elmt										*/
int		cnt=0;							/* Elmt Counter ( 0,1,2, ... )							*/

/* Arry[] */
	if( (e=x->ptr )!=NULL ){ _n_elmt(e,&cnt); }
/* Hash[] */
	if( (h=x->ptr2)!=NULL ){
		for( int i=0 ; i<MAX_EHIDX ; i++ ){		// For All Dtab BAR
			if( (e=h[i].link)==NULL ) continue;
			for( int j=0 ; j<h[i].ival ; j++ ){		// For All Synon(s)
			/* >>Seek Elmt ( Skip Empty ) */
				if( e[j].type=='U' ) continue;
				cnt++;
			}
		}
	}
/* Return */
	return cnt;
}
