/*** I_INTDBL.C ***/					#include	"main.h"

static tint str2int(char *str);	static char *int2str(tint ival);
static tdbl str2dbl(char *str);	static char *dbl2str(tdbl dval);
static void str2number(dtab *a,char *str);

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_int(ctree *ptr){				/*** TT-Lang: A = INT(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"SIDP",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );
/* Do INT()!! */
	a->type = 'I';
	switch( x->type ){
		case 'S': a->ival = str2int(x->str);	break;
		case 'I': a->ival = cint(x);			break;
		case 'D': a->ival = cint(x);			break;
		case 'P': a->ival = cint(x);			break;
	}
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_dbl(ctree *ptr){				/*** TT-Lang: A = DBL(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"SIDP",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );
/* Do DBL()!! */
	a->type = 'D';
	switch( x->type ){
		case 'S': a->dval = str2dbl(x->str);	break;
		case 'I': a->dval = cdbl(x);			break;
		case 'D': a->dval = cdbl(x);			break;
		case 'P': a->dval = cdbl(x);			break;
	}
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_atov(ctree *ptr){				/*** TT-Lang: A = ATOV(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"SIDP",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );
/* Do ATOV()!! */
	switch( x->type ){
		case 'S': str2number(a,x->str);			break;
		case 'I': a->type='I'; a->ival=cint(x);	break;
		case 'D': a->type='D'; a->ival=cdbl(x);	break;
		case 'P': a->type='I'; a->ival=cint(x);	break;
	}
	return ans;
}

/*------------------+-------------------+-------------------+-------------------+---------------*/
static tint str2int(char *str){			// Convert STR into TINT, support "0B|0D|0O|0X".
char	*ps,*pe;
/* Proc NULL & White Space */
	if( str==NULL ){ return(0); } ps=str+strspn(str," \f\n\r\t\v");
/* "0[bB]" */ if( *ps=='0' && (*(ps+1)=='b'||*(ps+1)=='B') ){ ps+=2; return(strtol(ps,&pe, 2)); }
/* "0[oO]" */ if( *ps=='0' && (*(ps+1)=='o'||*(ps+1)=='O') ){ ps+=2; return(strtol(ps,&pe, 8)); }
/* "0[dD]" */ if( *ps=='0' && (*(ps+1)=='d'||*(ps+1)=='D') ){ ps+=2; return(strtol(ps,&pe,10)); }
/* "0[xX]" */ if( *ps=='0' && (*(ps+1)=='x'||*(ps+1)=='X') ){ ps+=2; return(strtol(ps,&pe,16)); }
	return(atol(str));
}

/*------------------+-------------------+-------------------+-------------------+---------------*/
static tdbl str2dbl(char *str){			// Convert STR into TDBL, support Dec&Hex.
	if( str==NULL ){ return(0.0); } return(atof2(str));
}

/*------------------+-------------------+-------------------+-------------------+---------------*/
static void str2number(dtab *a,char *str){
char	*ps,*pe;		int		flag_real=FALS,i;
/* Proc NULL & White Space */
	if( str==NULL ){ a->type='I'; a->ival=0; return; } ps=str+strspn(str," \f\n\r\t\v");
/* "0[bB]" */ if( *ps=='0' && (*(ps+1)=='b'||*(ps+1)=='B') ){ ps+=2; a->type='I'; a->ival=strtol(ps,&pe, 2); return; }
/* "0[oO]" */ if( *ps=='0' && (*(ps+1)=='o'||*(ps+1)=='O') ){ ps+=2; a->type='I'; a->ival=strtol(ps,&pe, 8); return; }
/* "0[dD]" */ if( *ps=='0' && (*(ps+1)=='d'||*(ps+1)=='D') ){ ps+=2; a->type='I'; a->ival=strtol(ps,&pe,10); return; }
/* "0[xX]" */ if( *ps=='0' && (*(ps+1)=='x'||*(ps+1)=='X') ){ ps+=2; a->type='I'; a->ival=strtol(ps,&pe,16); return; }
/* TINT|TDBL */
	for( i=0 ; ps[i]!='\0' ; i++ ){
		if( (i==0&&(ps[i]=='+'||ps[i]=='-')) || isdigit(ps[i]) ) continue;
		if( ps[i]=='.' || ps[i]=='E' || ps[i]=='e' ){
			flag_real=TRUE; break;
		}
		else
			break;
	}
	if( flag_real==FALS ){ a->type='I'; a->ival=atol (str); }
	else{                  a->type='D'; a->dval=atof2(str); }
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_bin(ctree *ptr){				/*** TT-Lang: A = BIN(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
char	*ps,*pe;
/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"S",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );
/* Do BIN()!! */
	ps = (x->str)+strspn(x->str," \f\n\r\t\v");
	if( *ps=='0' && (*(ps+1)=='b'||*(ps+1)=='B') ){ ps+=2; /*** Skip "0[bB]" ***/ }
	a->type='I'; a->ival=strtol(ps,&pe, 2); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_oct(ctree *ptr){				/*** TT-Lang: A = OCT(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
char	*ps,*pe;
/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"S",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );
/* Do OCT()!! */
	ps = (x->str)+strspn(x->str," \f\n\r\t\v");
	if( *ps=='0' && (*(ps+1)=='o'||*(ps+1)=='O') ){ ps+=2; /*** Skip "0[oO]" ***/ }
	a->type='I'; a->ival=strtol(ps,&pe, 8); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_dec(ctree *ptr){				/*** TT-Lang: A = DEC(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
char	*ps,*pe;
/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"S",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );
/* Do DEC()!! */
	ps = (x->str)+strspn(x->str," \f\n\r\t\v");
	if( *ps=='0' && (*(ps+1)=='d'||*(ps+1)=='D') ){ ps+=2; /*** Skip "0[dD]" ***/ }
	a->type='I'; a->ival=strtol(ps,&pe,10); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_hex(ctree *ptr){				/*** TT-Lang: A = HEX(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
char	*ps,*pe;
/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"S",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );
/* Do HEX()!! */
	a->type='I'; a->ival=strtol(ps=x->str,&pe,16); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_str(ctree *ptr){				/*** TT-Lang: A = STR(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"SIDP",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );
/* Do STR()!! */
	a->type = 'S';
	switch( x->type ){
		case 'S': a->str = x->str;				break;
		case 'I': a->str = int2str(cint(x));	break;
		case 'D': a->str = dbl2str(cdbl(x));	break;
		case 'P': a->str = x->ptr;				break;
	}
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_ptr(ctree *ptr){				/*** TT-Lang: A = PTR(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"SIDP",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );
/* Do PTR()!! */
	a->type = 'P';
	switch( x->type ){
		case 'S': a->ptr = x->str;				break;
		case 'I': a->ptr = (void *)cint(x);		break;		// 値はそのままで、属性をptrとする。
		case 'D': a->ptr = (void *)cint(x);		break;		// 値をtint化して、属性をptrとする。
		case 'P': a->ptr = x->ptr;				break;
	}
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_reg(ctree *ptr){				/*** TT-Lang: A = REG(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"S",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );
/* Do REG()!! */
	cpy_dtab(a,x);
	if( a->ptr2==NULL ){ regcc(a); }	// Compile & Save /RE/ ( If NoExist )
	return ans;
}

/*------------------+-------------------+-------------------+-------------------+---------------*/
static char *int2str(tint ival){		// Convert TINT into STR.
char	buf[BUFSIZ];
	sprintf(buf,FMT_I2S(),ival); return X_SDUP(buf);
}

/*------------------+-------------------+-------------------+-------------------+---------------*/
static char *dbl2str(tdbl dval){		// Convert TDBL into STR.
char	buf[BUFSIZ];
	sprintf(buf,FMT_D2S(),dval); return X_SDUP(buf); 
}
