/*** I_DIMSHP.C ***/					#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_row(ctree *ptr){				/*** TT-Lang: A = ROW(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"*",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

/* Do RAW()!! */
	a->type='I';
	a->ival=matx_getrow(x);

/* Return */
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_col(ctree *ptr){				/*** TT-Lang: A = COL(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"*",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

/* Do COL()!! */
	a->type='I';
	a->ival=matx_getcol(x);

/* Return */
	return ans;
}

static int do_ndim(dtab *bar);

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_ndim(ctree *ptr){				/*** TT-Lang: A = NDIM(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"*",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

/* Do NDIM()!! */
	a->type='I';
/* Scalar */
	if( x->type!='A' ){ null_dtab(a); }
/* Arrays */
	else{
	/* >Std.Arry[] ( Or Empty ) */
		if( x->ptr2==NULL )
			a->ival=do_ndim(x->ptr);
	/* >Ext.Hash[] ( Or Mixed ) */
		else
			null_dtab(a);
	}
/* Return */
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
static int do_ndim(dtab *bar){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
int		self_dim,chld_dim,flag_elmtexist=FALS;
int		i;				dtab	*e;

	self_dim=0;
	for( i=0 ; i<MAX_SAIDX ; i++ ){		// For All Dtab Bar !!
		e = &bar[i];
		if(e->type!='U' ) flag_elmtexist=TRUE;
		if(e->link!=NULL){				// For Deep Elmt !!
			chld_dim = do_ndim(e->link);
			if(self_dim<chld_dim) self_dim=chld_dim;
		}
	}
// 自次元、又は、子次元で Elmt が存在する場合。（自次元分の加算をする。初期値は０。）
	if( flag_elmtexist || 0<self_dim )
		return(self_dim+1);
// 自次元、且つ、子次元で Elmt が存在しない場合。
	else
		return(0);
}

static int do_shape(dtab *bar,int shape[],int dep);

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_shape(ctree *ptr){				/*** TT-Lang: A = SHAPE(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*e;
int		shape[MAX_SAIDX],dep,i;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ptr,0) ); chk_vtype(x,"*",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

/* Do NDIM()!! */
	for( i=0 ; i<MAX_SAIDX ; i++) shape[i]=0;
	a->type='A';
/* Scalar */
	if( x->type!='A' ){ null_dtab(a); return ans; }
/* Arrays */
	else{
	/* >Std.Arry[] ( Or Empty ) */
		if( x->ptr2==NULL )
			do_shape(x->ptr,shape,dep=0);
	/* >Ext.Hash[] ( Or Mixed ) */
		else{
			null_dtab(a); return ans;
		}
	}
/* Return */
	if( shape[0]==0 ){ null_dtab(a); return ans; }
	for( i=0 ; i<MAX_SAIDX && shape[i]!=0 ; i++){
		e=di2p_dtab(a,i); e->type='I'; e->ival=shape[i];
	}
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
static int do_shape(dtab *bar,int shape[],int dep){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
int		self_cnt,chld_cnt;
int		i;				dtab	*e;

	self_cnt=0;
	for( i=0 ; i<MAX_SAIDX ; i++ ){		// For All Dtab Bar !!
		e = &bar[i];
		if(e->type!='U' ) self_cnt++;
		if(e->link!=NULL){				// For Deep Elmt !!
			chld_cnt = do_shape(e->link,shape,dep+1);
			if( e->type=='U' && 0<chld_cnt ) self_cnt++;
		}
	}
	if(shape[dep]<self_cnt) shape[dep]=self_cnt;
	return(self_cnt);
}
