/*** TOPLVL.C ***/						#include	"main.h"

#define	flagon_ret(PTR)	{ if(flag_exerr){return(NULL);}if(flag_retning||flag_next||flag_last){return(PTR);} }

/************************************************************************************************/
// EXE_TLVLSTMT() execute iCODE for "[tlvl_stmtWT]".
/************************************************************************************************/
ctree *exe_tlvlstmt(ctree *ptr){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		op = (ptr==NULL?0x00:ptr->op);			ctree	*ans;

/* PreCheck && DoIntr!! */ chk_light(ptr); if( sig_iall!=0 ){ cu_handler(); }

// EXE_TLVLSTMT() は、{tlvl_stmtWT|chld_stmtWO|chld_multWT} の iCODE を実行します。
// 又、{script|bkrw_stmt} の iCODE も実行します。（類似処理の共通化）
// 1) OP=LINK は STMTtoSTMT リンクです。左側->右側と順次実行します。
// 2) "${expr}" は EVA_EXPR() によって評価実行されます。

// LINK
	if( op==LINK ){
		ans = exe_tlvlstmt(ptr->l); flagon_ret(ans);		/*** Recur LHS ***/
		ans = exe_tlvlstmt(ptr->r); flagon_ret(ans);		/*** Recur RHS ***/
		return ans;
	}
	strace(ptr);						/*** TT-Script Trace for "-T" mode ***/

// nlt:
	if( iscgap(ptr) ) return ptr;

// vdef_stmtWO nlt:
	if( op==GLKW || op==STKW || op==LCKW ) return exe_vdefstmt(op,ptr->r);		// (R) = vt_list

// stmt_listWO nlt:
	if( op==',' || op=='=' || op==VPP || op==VMM || op==FCAL || op==BKQT || op==NEXT || op==LAST || op==RETN )
		return exe_stmtlist(ptr);

// expr_stmtWO nlt: -> Execute i_p() w/o trace !! ( PRIN = Implied FCAL )
	if( op==PRIN ){
		ptr->l=mk_cleaf(0x00,0,0,0,idx2cdx('G',rd_dtab(GL_DTAB,"p")));
		return exe_stmtlist(ptr);
	}

// flow_ctrlWW:
	if( op==IF || op==SWCH || op==FORS || op==WHIL || op==DOWH || op==EACH || op==LOOP )
		return exe_flowctrl(ptr);

/* Assert!! */ assert(FALS);
}

/************************************************************************************************/
// Note: fdef_stmtWW は定義文です。よって、実行すべき内容はありません。
/************************************************************************************************/

/************************************************************************************************/
// EXE_VDEFSTMT() execute iCODE for "[vdef_stmtWO]".  { ptr => vt_list }
/************************************************************************************************/
ctree *exe_vdefstmt(int scope,ctree *ptr){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		op = (ptr==NULL?0x00:ptr->op);			ctree	*ans;

/* PreCheck */ chk_point(ptr);

// EXE_VDEFSTMT() は、vdef_stmtWO と{sing_asgn|mult_asgn|opeq_asgn} の iCODE を実行します。
// 1) 変数は既に Parser によって、{GL_DTAB|ST_DTAB|LC_DTAB} にインストールされています。
// 2) また、opeq_asgn は sing_asgn に事前変換されています。（コードモーフィング）
// 3) よって、ここで処理すべきことは、再帰処理と{lval_sing|sing_asgn|mult_asgn} のみとなります。
//    ただし、例外として {global|static|local} ARRY[*] の様な処理も行います。

// vt_list:
	if( op==',' ){
		ans = exe_vdefstmt(scope,ptr->l);					/*** Recur LHS ***/
		ans = exe_vdefstmt(scope,ptr->r);					/*** Recur RHS ***/
		return ans;
	}

// vt_elmt: lval_sing
	if( op==0x00 || op==0xFF ) return ptr;					/*** DoNothing ***/
	if( op==ARRY             ) return ptr;					/*** DoNothing ***/

// vt_elmt: {sing_asgn|mult_asgn}
	if( op=='='  ){
		if( scope==GLKW || scope==LCKW ) return x_asgn(ptr);
		if( scope==STKW && ptr->init==TRUE ){                 return ptr->l;      }
		if( scope==STKW && ptr->init==FALS ){ ptr->init=TRUE; return x_asgn(ptr); }
	}

/* Assert!! */ assert(FALS);
}

/************************************************************************************************/
// EXE_STMTLIST() execute iCODE for "[stmt_listWO]".
/************************************************************************************************/
ctree *exe_stmtlist(ctree *ptr){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		op = (ptr==NULL?0x00:ptr->op);			ctree	*ans;

/* PreCheck */ chk_light(ptr);

// EXE_STMTLIST() は、{stmt_listWO|expr_stmtWO} の iCODE を実行します。
// 又、{ppmm_call|func_call|bkqt_call} {next_stmt|last_stmt|retn_stmt} の iCODE も実行します。
// 1) ただし、expr_stmtWO に対して実行すべき内容はありません。

// stmt_listWO:
	if( op==',' ){
		ans = exe_stmtlist(ptr->l);							/*** Recur LHS ***/
		ans = exe_stmtlist(ptr->r);							/*** Recur RHS ***/
		return ans;
	}
// stmtWO: {sing_asgn:|mult_asgn:|opeq_asgn:}
	if( op=='='  )				return x_asgn(ptr);
// stmtWO: {ppmm_call:|func_call:|bkqt_call:}
	if( op==VPP  || op==VMM  )	return x_ppmm(ptr);
	if( op==FCAL )				return x_call(ptr,FALS);
	if( op==PRIN )				return x_call(ptr,TRUE);	/* EXE_TLVLSTMT() need this code !!	*/
	if( op==BKQT )				return x_bkqt(ptr);
// stmtWO: {next_stmt:|last_stmt:|retn_stmt:}
	if( op==NEXT )				return x_next(ptr);
	if( op==LAST )				return x_last(ptr);
	if( op==RETN )				return x_retn(ptr);

/* Assert!! */ assert(FALS);
}

/************************************************************************************************/
// EXE_FLOWCTRL() execute iCODE for "flow_ctrlWW".
/************************************************************************************************/
ctree *exe_flowctrl(ctree *ptr){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		op = (ptr==NULL?0x00:ptr->op);			/*ctree	*ans;*/

/* PreCheck */ chk_point(ptr);

// EXE_FLOWCTRL() は、flow_ctrlWW と {if_stmt|sw_stmt|fors_stmtwhil_stmt|each_stmt|loop_stmt} の
// iCODE を実行します。
// 1) bkrw_stmt の iCODE は EXE_TLVLSTMT() が実行します。
// 2) x_if() は x_elif()&x_else() を EXE_FLOWCTRL() 経由で間接的に実行します。
// 3) x_swch() は op={SWCH|CASE|DEFT} の全てを内部で直接処理します。

/* DoExec!! */
// {if_stmt:  |swch_stmt:}
	if( op==IF   ) return x_if  (ptr); if( op==ELIF ) return x_elif(ptr); if( op==ELSE ) return x_else(ptr);
	if( op==SWCH ) return x_swch(ptr);
// {fors_stmt:|whil_stmt:}
	if( op==FORS ) return x_fors(ptr);
	if( op==WHIL ) return x_whil(ptr); if( op==DOWH ) return x_dowh(ptr);
// {each_stmt:|loop_stmt:}
	if( op==EACH ) return x_each(ptr);
	if( op==LOOP ) return x_loop(ptr);

/* Assert!! */ assert(FALS);
}

/************************************************************************************************/
// Note: {nls|nlt} は区切りです。よって、実行すべき内容はありません。
/************************************************************************************************/

/************************************************************************************************/
// EVA_EXPR() evaluate iCODE for "expr".  { eval_dollar => TRUE|FALS }
/************************************************************************************************/
ctree *eva_expr(ctree *ptr,int eval_dollar){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		op = (ptr==NULL?0x00:ptr->op);			ctree	*ans,*p_ctmp;
dtab	*a, *p_dtab;

/* PreCheck */ if( ptr==NULL||flag_exerr||flag_retning||(flag_next||flag_last) ){ return(NULL); } /*** LastParam(s) 保持 ***/

// EVA_EXPR() は、{exop_list|exwc_list|expr_list} の iCODE を評価します。
// 1) もし、表現式がリスト形式 (CSL) である場合は、そのリスト形式の構造 (CSL) を保持します。

// ( CSL - Preserve original CSL structure )
	if( op==',' ){
		ans = mk_cleaf(op,ptr->file,ptr->line,ptr->colm,0x00);
		ans->l = eva_expr(ptr->l,eval_dollar); flagon_ret(ans);		/*** Recur LHS ***/
		ans->r = eva_expr(ptr->r,eval_dollar); flagon_ret(ans);		/*** Recur RHS ***/
		return ans;
	}

// ( 1 Oper )							/* Conflict with X_BIT2()|X_ARTH() !!					*/
	if( (op=='&'||op=='+'||op=='-') && ptr->l==NULL )			return x_unop(ptr);
	if( (op=='~'                  ) && ptr->l==NULL )			return x_bit1(ptr);
	if( (op=='!'                  ) && ptr->l==NULL )			return x_lgc1(ptr);

// ( 2 Oper )
	if( op=='+' || op=='-' || op=='*' || op=='/' || op=='@' || op=='%' || op==POW || op==SOP || op==VOP )
																return x_arth(ptr);
	if( op=='>' || op=='<' || op==CGE || op==CLE            )	return x_cmpr(ptr);
	if( op==CEQ || op==CNE                                  )	return x_eqne(ptr);
	if( op==REQ || op==RNE                                  )	return x_rene(ptr);
	if( op=='&' || op=='|' || op=='^' || op==SLL || op==SRR )	return x_bit2(ptr);
	if( op==LAND|| op==LIOR|| op==LXOR                      )	return x_lgc2(ptr);

// Note: Next 2 rules will generate CLEAF for "${STR}" from IMED & INAM.  So they are evaluated here.
// (1) imed_data <= IMED.               *** For other route to imed_data, see below !! ***
// (2) rval_sing <= lval_sing <= INAM.	*** For other route to rval_sing, see below !! ***
	if( op==0x00 || op==0xFF ){
		p_dtab = eval_dollar ? ctr2p_dtab(ptr):NULL;		// Ena ? Dis ?
		if( p_dtab!=NULL && p_dtab->type=='S' && ((p_dtab->attr)&ATTR_EDOL) ){
			a = ctr2p_dtab( ans=ext_ctrdtab(ptr) ); cpy_dtab(a,p_dtab);
			a->str   = evaldol(p_dtab->str);						// >Try to Rewrite by Evaled String !!
			if( (a->str)!=(p_dtab->str) ) a->attr &= (~ATTR_EDOL);	// >Disable Propagation if Replaced !!
			return ans;
		}
		return ptr;
	}

// imed_data:
	if( op=='{' || op=='}'  )									return x_imed(ptr);
// rval_sing:														// <!> Array[Index] could cause error!! (U)
	if( op==ARRY|| op==STID ){
		if( ptr->l->op==0x00 || ptr->l->op==0xFF )		// Direct Arry&Hash
			p_ctmp=ptr;
		else{											// Nested Arry&Hash
			p_ctmp=mk_cleaf(0xFF   ,ptr->file,ptr->line,ptr->colm,(tint)ca2p_dtab(ptr->l));	flagon_ret(p_ctmp);	/*<!>*/
			p_ctmp=mk_ctree(ptr->op,ptr->file,ptr->line,ptr->colm,p_ctmp,ptr->r,00);		flagon_ret(p_ctmp);	/*<!>*/
		}
		ans = mk_cleaf(0xFF,ptr->file,ptr->line,ptr->colm,(tint)ca2p_dtab(p_ctmp));			flagon_ret(ans);	/*<!>*/
		ctr2p_dtab(p_ctmp->l)->attr |= (op==STID)?ATTR_STID:0x00;	return ans;
	}
// expr_asgn: {sing_asgn:|mult_asgn:|opeq_asgn:}
	if( op=='='  )												return x_asgn(ptr);
// expr_call: {ppmm_call:|func_call:|bkqt_call:|qcol_call:}
	if( op==VPP  || op==VMM  )									return x_ppmm(ptr);
	if( op==FCAL )												return x_call(ptr,FALS);
	if( op==BKQT )												return x_bkqt(ptr);
	if( op=='?'  )												return x_qcol(ptr);

/* Assert!! */ assert(FALS);
}

/************************************************************************************************/
// CHK_NULLFX() check GL_DTAB for "(UseDef)Func()" w/o DEFT_STMT.
/************************************************************************************************/
ctree *chk_nullfx(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*gl_dtab = mem[GL_DTAB];

/* DoCheck!! */
	for( int idx=1 ; idx<=gl_dtab[0].ival ; idx++ ){
		if( gl_dtab[idx].type=='X' && (fx=((gl_dtab[idx].attr)&ATTR_FXID))==0 ){
			if( gl_dtab[idx].ptr==NULL )
				msg_y("Undefined Function, Name = %s()\n",gl_dtab[idx].name);
		}
		if( gl_dtab[idx].type=='X' && (fx=((gl_dtab[idx].attr)&ATTR_FXID))!=0 ){
			if( mem[ GL_DTAB+fx*FX_UNIT+FX_TREE ]==NULL )
				msg_y("Undefined Function, Name = %s()\n",gl_dtab[idx].name);
		}
	}
	return((ctree *)gl_dtab);			// This is Dummy!!  It will skip diag(). //
}
