/*** X_BITS.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *x_bit1(ctree *ptr){				/*** TT-Lang: A = ~X [ビット反転|転置行列] ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/

int		op = (ptr==NULL?0x00:ptr->op);
ctree	*ans;	dtab	*a,*x;

dtab	*ma,*mx;		int		xi,xj,xv;		// Matrix Parameter

/* Debug & PreCheck */
	chk_point(ptr);

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( eva_expr(ptr->r,1) ); chk_error(ptr); chk_vtype(x,"IDPA",0);	/* R=>0 */
	if( x->type=='A' && !ismatx(x) ){ flag_exerr=MatxAttri; return NULL; }
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

/* Do NOT()!! [ビット反転] */
	if( op=='~' && !ismatx(x) ){ a->type='I'; a->ival=~cint(x); return ans; }

/* Do TRANSVERSE()!! [転置行列] */
	if( op=='~' &&  ismatx(x) ){
		xi=matx_getrow(x); xj=matx_getcol(x);
		xv = ( xi==0 && xj!=0 );				// Vector Flag for X (T/F)

// 行ベクトル（ 0xN 1次元配列）は、列ベクトル（ Nx1 2次元配列）に変換される。
// 列ベクトル（ Nx1 2次元配列）は、行ベクトル（ 0xN 1次元配列）に変換される。
// 行列（ MxN 2次元配列）は、行列（ NxM 2次元配列）に変換される。

		for( int i=0 ; i<xi || (i==0&&xv) ; i++ ){		/* Matrix|Vector */
			for( int j=0 ; j<xj ; j++ ){
				ma = (!xv&&xj==1 ? di2p_dtab(a,i) : dm2p_dtab(a,j,i) );		// 行ベクトルを除く列ベクトル
				mx = ( xv        ? di2p_dtab(x,j) : dm2p_dtab(x,i,j) );
				if( !isdef (mx) ){ flag_exerr=MatxUndef; epar[0]=(xv?INVA:i); epar[1]=j; return NULL; }
				if( !ismatv(mx) ){ flag_exerr=MatxValue; epar[0]=(xv?INVA:i); epar[1]=j; return NULL; }
				cpy_dtab(ma,mx);
			}
		}
		return ans;
	}

/* Assert!! */
	return NULL;

}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *x_bit2(ctree *ptr){				/*** TT-Lang: A = X&Y | X|Y | X^Y | X<<Y | X>>Y ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/

int		op = (ptr==NULL?0x00:ptr->op);
ctree	*ans;	dtab	*a,*x,*y;

/* Debug & PreCheck */
	chk_point(ptr);

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( eva_expr(ptr->l,1) ); chk_error(ptr); chk_vtype(x,"IDP",0);	/* L=>0 */
	y = ctr2p_dtab( eva_expr(ptr->r,1) ); chk_error(ptr); chk_vtype(y,"IDP",1);	/* R=>1 */
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

/* Do AND()!! */
	if( op=='&' ){ a->type = 'I'; a->ival = cint(x)& cint(y); return ans; }

/* Do IOR()!! */
	if( op=='|' ){ a->type = 'I'; a->ival = cint(x)| cint(y); return ans; }

/* Do XOR()!! */
	if( op=='^' ){ a->type = 'I'; a->ival = cint(x)^ cint(y); return ans; }

/* Do SLL()!! */
	if( op==SLL ){ a->type = 'I'; a->ival = cint(x)<<cint(y); return ans; }

/* Do SRR()!! */
	if( op==SRR ){ a->type = 'I'; a->ival = cint(x)>>cint(y); return ans; }

/* Assert!! */
	return NULL;

}
