/*** X_CALL.C ***/						#include	"main.h"

/*----------------------------------------------------------------------------------------------*/
// X_FUNC() - (BuiltIn)LangFlow&LangOper linked directly into EXE_STMT() & EVA_STMT().
// I_FUNC() - (SysDefined)Func called by X_CALL().
// DEFX()   - (UsrDefined)Func called by X_CALL().
/*----------------------------------------------------------------------------------------------*/

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *x_call(ctree *ptr,int flag_implied){		/*** TT-Lang: A = F(...) [ L=FNAM,R=PARAM ] ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/

ctree	*ret,*ans,*fxt,*par;	dtab	*a,*f,*p_src,*p_dst;
ctree	*(*fx_addr)(ctree *);			/* Pointer to (SysDefined|UsrDefined)Func				*/
int		idx;

/* Debug & PreCheck */
	chk_point(ptr);

/* Set Param(s) & Check Type(s) */
	f = ctr2p_dtab( fxt=eva_expr(ptr->l,1) ); chk_error(ptr); chk_ftype(f,"X");
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

	par = eva_expr(ptr->r,1); chk_error(ptr);	//【親環境】Evaluate Params ＋ "${...}" 展開
	if( flag_exerr ){ return(NULL); } if( flag_retning||flag_next||flag_last ){ return(par); }

/* Do TRACE()!! ( if required ) */
	if( !flag_implied && (flag_trace>=rp || flag_debug&DF_CTRDP) ) {	// RP = Func Nest Level (main=1)
		eprin("%sCall:%s %s(%s)\n",C_GRE(2),C_DEF(2),cn(ptr->l),cv(par));
	}
	if( !flag_implied && (flag_debug&DF_CTRDP) ){ dump_ct((tint)ptr,0); }

/* Do CALL()!! */
	last_fx = fxt;
//==============================================================================================//
// (SysDefined)Func Call【 環境移行不要 - 子専用ST_DTAB&LC_DTAB不要 / NEST実行の可能性無し 】
//==============================================================================================//
	if( ((f->attr)&ATTR_FXID)==0 ){		/* I_FUNC() - (SysDefined)Func							*/
		last_ct = par;
		if( (fx_addr=f->ptr)==NULL           )
			{ flag_exerr=UnDEFD_F; last_ct=fxt; epos=0;                               return(NULL); }
		if( 0<=f->ival && lcnt(par)!=f->ival )
			{ flag_exerr=NgARGCmm; epar[0]=lcnt(par),epar[1]=f->ival,epar[2]=f->ival; return(NULL); }
		if( 0<=lgap(par)                     )
			{ flag_exerr=NgARGGAP; epar[0]=lgap(par);                                 return(NULL); }

		ret       = fx_addr(par);				// Call I_FUNC() with Evaled Params !!

	}
//==============================================================================================//
// (UsrDefined)Func Call【 環境移行必要 - 子専用ST_DTAB&LC_DTAB必要 / NEST実行の可能性有り 】
//==============================================================================================//
	else{								/* DEFX() - (UsrDefined)Func							*/

	/* >Push Parent Frame */
		rs[rp].mp = mp; rs[rp].mp_base = mp_base;
		rs[rp].dp = dp; rs[rp].dp_base = dp_base;
		rs[rp].fx = fx;
		rp++; chk_overflow();					// Next UnUsed Index

	/* Init Child Frame */
		fx = ((f->attr)&ATTR_FXID);
		mp_base = GL_DTAB + fx*FX_UNIT;
		dp_base = dp;

	/* >Deploy Child LC_DTAB with Name - Name can share each other!! */
		p_src = mem[ mp_base + LC_DTAB ];
		p_dst = &ds[ dp_base ];
		if( p_src!=NULL ){
			dp+=p_src[0].ival; chk_overflow(); dp-=p_src[0].ival;
			for( idx=0 ; idx<p_src[0].ival ; idx++ ){
				cpy_dtab(&p_dst[ idx ],&p_src[ idx + 1 ]);
				p_dst[ idx ].name = p_src[ idx + 1 ].name;
				dp++;							// Next UnUsed Index
			}
		}

// *** MEMO ***  実引数(親フレーム)を仮引数(子フレーム)にコピーする場合、フレームを越えたアクセス
// が必要となる。この時点では、既に子フレームに移行済みであるため、実引数(親フレーム)の DTAB アド
// レスを取得する関数は、直前フレームを利用する変換関数 CTR2P_DTABPREV() を使用する。 

	/* >Assign Param(s) to Child */
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
		for( idx=0 ; idx<(f->ival) ; idx++ ){	// ユーザー関数の定義時に使用された仮引数の数
			p_src = ctr2p_prev( lptr(par,idx) );			/*** 親環境フレーム ***/
			p_dst = &ds[ dp_base + idx ];					/*** 子環境フレーム ***/

			if( p_src==NULL )					// 親環境の<GAP> => 子環境の'U'
				udef_dtab(p_dst);
			else{
				if( p_src->type=='U' ){			// 未定義の実引数（ユーザー定義関数実行時のみ要チェック!!）
					flag_exerr=UnDEFD_V; last_ct=par; epos=idx; goto E_BeforCall;
				}
				cpy_dtab(p_dst,p_src);
			}
		}

	/* >Call DEFX() with Evaled Params (L=FNAM,R=PARAM) */
		last_ct = par;
		fx_addr = mem[ mp_base + FX_TREE ];
		if( fx_addr==NULL ){ flag_exerr=UnDEFD_F; last_ct=fxt; epos=0; goto E_BeforCall; }

		ret     = exe_tlvlstmt( ((ctree *)fx_addr)->x );  if( flag_exerr ){ goto E_AfterCall; }

// ここで RET の値は、(UsrDefined)Func の最終評価結果の値、又は、<GAP> となる。(空文関数の場合)
// *** MEMO ***  X_RETN() からの戻り値の場合は、FLAG_RETNING=TRUE となり、X_RETN() 引き数の評価
// 結果が RET の値となる。ただし、RET の Line&Colm の値は、X_RETN() 実行位置を保持しているため、
// ここで (UsrDefined)Func 呼び出し位置に変更しておく。(エラーメッセージの品質向上のため。)

	/* >Proc Return Value(s) */
		if( !flag_retning ){ a->name = X_SDUP("(void)"); ret = ans; }	/*** 戻り値 VOID 化 ***/
		else{
			ret->line    = ptr->line;			// 関数呼び出し位置に変更!!
			ret->colm    = ptr->colm;			// 関数呼び出し位置に変更!!
			flag_retning = FALS;
		}

	/* >Set Last Params */
		if( !flag_exerr ){ last_fx = fxt; last_ct = par; }

	/* >Pop Parent Frame */
		if( !flag_exerr ){
			rp--;						/* Orig UnUsed Index									*/
			fx = rs[rp].fx;
			dp = rs[rp].dp; dp_base = rs[rp].dp_base;
			mp = rs[rp].mp; mp_base = rs[rp].mp_base;
		}
	}
//==============================================================================================//
	return ret;

E_BeforCall: /* 子環境へ移行後＋関数実行前の、エラー発生時のリターン処理（ユーザー定義関数のみ） */
// *** MEMO ***  エラーメッセージの表示は、呼び出し元（親環境）を基準に表示させる必要があるので、
// 既に移行済みとなっている実行環境（レジスタ）を、元に戻してからリターンします。
	rp--;								/* Orig UnUsed Index									*/
	fx = rs[rp].fx;
	dp = rs[rp].dp; dp_base = rs[rp].dp_base;
	mp = rs[rp].mp; mp_base = rs[rp].mp_base;
	return(NULL);

E_AfterCall: /* 子環境へ移行後＋関数実行後の、エラー発生時のリターン処理（ユーザー定義関数のみ） */
// *** MEMO ***  エラーメッセージの表示は、呼び出し先（子環境）を基準に表示させる必要があるので、
// 既に移行済みとなっている実行環境（レジスタ）を、元に戻さずにリターンします。
	return(NULL);

}
