/*** REINIT.C ***/						#include	"main.h"

/************************************************************************************************/
// INIT_ICPU() initializes iCPU ( Signal-Handler, Register & MEM[]/DS[]/RS[]/FS[] ).
/************************************************************************************************/
void init_icpu(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
/* Reset (UsrDefined) Signal-Handler */
	for( int i=0 ; i<NSIG ; i++ ){
		sig_vect[i]=NULL;
		sig_icnt[i]=sig_tcnt[i]=0;
	}
	sig_iall=sig_tall=0;
/* Initialize Register */
	mp=GL_DTAB+FX_UNIT; mp_base=GL_DTAB; dp=1; dp_base=1; rp=1; fx=0; sx=0;
/* Initialize MEM[]/DS[]/RS[]/FS[] */
	mem = X_MALL( IMEM_SIZE*sizeof(void *) );
	ds  = X_MALL( IDS_SIZE *sizeof(dtab  ) );
	rs  = X_MALL( IRS_SIZE *sizeof(rtab  ) );
	mem[0] = (void *)IMEM_SIZE;	for( int i=1 ; i<IMEM_SIZE ; i++ ){ mem[i] = NULL; }
	init_dtab(&ds[0]); ds[0].name="{ Admin } -> Alloc Size"; ds[0].type='I'; ds[0].ival=IDS_SIZE;
	rs[0].mp        = IRS_SIZE;
}

/************************************************************************************************/
// REINIT_ICPU() re-initializes iCPU for YYPARSE()|EXECTREE().
/************************************************************************************************/
void reinit_icpu(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	/*mp=GL_DTAB+FX_UNIT*/ mp_base=GL_DTAB; dp=1; dp_base=1; rp=1; fx=0; sx=0;
}

/************************************************************************************************/
// REINIT_ARGCMD() re-initializes ARGC/ARGR/ARGV/ARGS/CMD.
/************************************************************************************************/
void reinit_argcmd(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_argc, *p_argr, *p_argv, *p_args, *p_cmd, *p_elmt;
char	*s_cmd=NULL, *s_args=NULL;		int		idx;

/* Get Initial ARGC/ARGR/ARGV/ARGS/CMD from GL_DTAB */
	p_argc=mem[GL_DTAB]; idx=rd_dtab(GL_DTAB,"argc"); assert(idx>0); p_argc+=idx;
	p_argr=mem[GL_DTAB]; idx=rd_dtab(GL_DTAB,"argr"); assert(idx>0); p_argr+=idx;
	p_argv=mem[GL_DTAB]; idx=rd_dtab(GL_DTAB,"argv"); assert(idx>0); p_argv+=idx;
	p_args=mem[GL_DTAB]; idx=rd_dtab(GL_DTAB,"args"); assert(idx>0); p_args+=idx;
	p_cmd =mem[GL_DTAB]; idx=rd_dtab(GL_DTAB,"cmd" ); assert(idx>0); p_cmd +=idx;
	gl_argc = (p_argc->ival);			/* ARGC   for TT-Script     { *NOT* for TT-Engine     }	*/
	gl_argv = (p_argv->ptr );			/* ARGV[] for TT-Script     { *NOT* for TT-Engine     }	*/
/* Set ARGC & ARGR */
	(p_argc->ival) = gl_argc==0 ? 1 : gl_argc;	// Ex: cmd -e (nil) |  cmd (nil)
	(p_argr->ival) = (p_argc->ival)-1;
/* Set ARGV[0] & CMD */
	p_argv->type='A'; p_argv->ptr=NULL;			// This is required in order to keep attr (ATTR_IGNR).
	p_elmt = di2p_dtab(p_argv,0);				/*** argv[ 0 ] ***/
	if( flag_imode=='I' || flag_imode=='E' || gl_argc==0 )
		s_cmd = X_SDUP(TTdeAM_CMD);
	else{
		s_cmd = strrchr(gl_argv[0],'/');
		s_cmd = s_cmd==NULL ? gl_argv[0] : (s_cmd+1);
	}
	p_elmt->type = 'S';
	p_elmt->str  = evalesc(s_cmd);
/* ( CMD ) */
	p_cmd ->type = 'S';
	p_cmd ->str  = evalesc(s_cmd);
/* Set ARGV[IDX] & ARGS */
	for( idx=1 ; idx<gl_argc ; idx++ ){			// idx = 1,2,3, ... gl_argc-1
		p_elmt = di2p_dtab(p_argv,idx);			/*** argv[idx] ***/
		p_elmt->type = 'S';
		p_elmt->str  = evalesc(gl_argv[idx]);
		if( s_args!=NULL )
			s_args = X_SCAT(s_args," ");
		s_args = X_SCAT(s_args,p_elmt->str);
	}
/* ( ARGS ) */
	p_args->type = 'S';
	p_args->str  = (s_args==NULL) ? "":s_args;
}

/************************************************************************************************/
// REINIT_ENV() re-initializes ENV.
/************************************************************************************************/
void reinit_env(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab, *p_elmt;
char	*lval, *rval, *ptr;				int		idx;
/* Get Initial ENV from GL_DTAB */
	p_dtab=mem[GL_DTAB]; idx=rd_dtab(GL_DTAB,"env" ); assert(idx>0); p_dtab+=idx;
/* Set ENV[IDX] */
	for( idx=0 ; environ[idx]!=NULL ; idx++ ){	// For All ENVIRON[]
		ptr  = strchr(environ[idx],'='); assert(ptr!=NULL);
		lval = X_NDUP(environ[idx],ptr-environ[idx]);
		rval = X_SDUP(ptr+1);
		p_elmt = ds2p_dtab(p_dtab,lval);
		p_elmt->type = 'S';
		p_elmt->str  = rval;
	}
}

/************************************************************************************************/
// REINIT_LTZ() re-initializes LTZ & LTZ_OFFSET.
/************************************************************************************************/
void reinit_ltz(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;		int		idx;
/* Get Initial LTZ_OFFSET from GL_DTAB */
	p_dtab=mem[GL_DTAB]; idx=rd_dtab(GL_DTAB,"LTZ"       ); assert(idx>0); p_dtab+=idx;
/* Set LTZ String */
	p_dtab->type = 'S';
	p_dtab->str  = X_SDUP(gl_zone);
/* Get Initial LTZ_OFFSET from GL_DTAB */
	p_dtab=mem[GL_DTAB]; idx=rd_dtab(GL_DTAB,"LTZ_OFFSET"); assert(idx>0); p_dtab+=idx;
/* Set LTC-UTC Time [sec] */
	p_dtab->type = 'I';
	p_dtab->ival = (tint)gl_gmtoff;
}

/************************************************************************************************/
// REINIT_CODE() re-initializes ":CODE" && "__CODE__".
/************************************************************************************************/
void reinit_code(char *fname,int nline){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab1,*p_dtab2;		int		idx1,idx2;
FILE	*fp;
/* Get Initial ":CODE" && "__CODE__" from GL_DTAB */
	p_dtab1=mem[GL_DTAB]; idx1=rd_dtab(GL_DTAB,"__code__"); assert(idx1>0); p_dtab1+=idx1;
	p_dtab2=mem[GL_DTAB]; idx2=rd_dtab(GL_DTAB,":code"   ); assert(idx2>0); p_dtab2+=idx2;
/* Set ":CODE" && "__CODE__" Info */
	if(flag_vfile){ fp=NULL; }else{ fp=fopen(fname,"r+"); for( int lc=1 ; lc<=nline ; lc++ ){ X_GETS(fp); } }
	p_dtab1->type = p_dtab2->type = 'P';
	p_dtab1->ptr  = p_dtab2->ptr  = fp;			// File Pointer
	p_dtab1->ival = p_dtab2->ival = (fp==NULL ? 0:ftell(fp));	// File Position { for REWIND() }
}

/************************************************************************************************/
// REINIT_DATA() re-initializes ":DATA" && "__DATA__".
/************************************************************************************************/
void reinit_data(char *fname,int nline){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab1,*p_dtab2;		int		idx1,idx2;
FILE	*fp;
/* Get Initial ":DATA" && "__DATA__" from GL_DTAB */
	p_dtab1=mem[GL_DTAB]; idx1=rd_dtab(GL_DTAB,"__data__"); assert(idx1>0); p_dtab1+=idx1;
	p_dtab2=mem[GL_DTAB]; idx2=rd_dtab(GL_DTAB,":data"   ); assert(idx2>0); p_dtab2+=idx2;
/* Set ":DATA" && "__DATA__" Info */
	if(flag_vfile){ fp=NULL; }else{ fp=fopen(fname,"r+"); for( int lc=1 ; lc<=nline ; lc++ ){ X_GETS(fp); } }
	p_dtab1->type = p_dtab2->type = 'P';
	p_dtab1->ptr  = p_dtab2->ptr  = fp;							// File Pointer
	p_dtab1->ival = p_dtab2->ival = (fp==NULL ? 0:ftell(fp));	// File Position { for REWIND() }
}

/************************************************************************************************/
// MAIN_LC2DS() deploys TopLevel LC_DTAB from MEM[] to DS[] with iCPU Adjustment.
/************************************************************************************************/
void main_lc2ds(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*m=mem[GL_DTAB+LC_DTAB], *d=&ds[1];		// TopLevel LC_DTAB in { MEM[] & DS[] }
/* Deploy LC_DTAB ( MEM[] => DS[] )*/
	if( m==NULL ) return;
	for( int idx=0 ; idx<m[0].ival ; idx++ )
		d[idx] = m[idx+1];				/*** FwdCopy ***/
/* Adjust iCPU */
	dp_base=1; dp=1+m[0].ival; chk_overflow();
}

/************************************************************************************************/
// MAIN_DS2LC() backups TopLevel LC_DTAB from DS[] to MEM[] with iCPU Adjustment.
/************************************************************************************************/
void main_ds2lc(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*m=mem[GL_DTAB+LC_DTAB], *d=&ds[1];		// TopLevel LC_DTAB in { MEM[] & DS[] }
/* BackUp LC_DTAB ( DS[] => MEM[] )*/
	if( m!=NULL ){
		for( int idx=0 ; idx<m[0].ival ; idx++ )
			m[idx+1] = d[idx];			/*** RevCopy ***/
	}
	mem[GL_DTAB+FX_TREE] = NULL;				// Clear TREE for TopLevel !! //
	mem[GL_DTAB+FX_INFO] = NULL;				// Clear INFO for TopLevel !! //
/* Adjust iCPU */
	dp_base=1; dp=1+(m==NULL?0:m[0].ival); chk_overflow();
}

/************************************************************************************************/
// SET_SCRIPTbyFILE() reads & returns TT-Script from given File (Name  ) or NULL.
// SET_SCRIPTbyARGV() reads & returns TT-Script from given Argv (String) or NULL.
/************************************************************************************************/
void *set_scriptbyfile(char *fname){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
FILE	*fp;			char	**linv;
/* Open TT-Script File */
	if( (fp=fopen(fname,"r"))==NULL || fileno(fp)==0 ){ return(NULL); }	// STDIN(0) //
/* Read Line Loop */
	linv = X_MALL( sizeof(char *)*MAX_SAIDX );
	for( int i=0 ; i<MAX_SAIDX ; i++ ){
		if( (linv[i]=X_GETS(fp)) == NULL )		// Auto NULL Term !! //
			break;
	}
	return(linv);
}

void *set_scriptbyargv(char *sbody){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	**linv,*ps,*pe;
int		i,lcnt=0;						// Line Counter in TT-Script [ Start 0 ]
/* Asgn Line Info */
	if( sbody==NULL ){ return(NULL); }
	linv=X_MALL( sizeof(char *)*MAX_SAIDX );

	ps=&sbody[0]; pe=NULL;
	for( i=0 ; sbody[i]!='\0' ; i++ ){	// For All TT-Script Char
		if( sbody[i]=='\n' ){			// One-Liner TT-Script always end with '\n'.
			pe = &sbody[i+1];
			linv[lcnt++] = X_NDUP(ps,pe-ps);
			ps = pe;
		}
	}
	linv[lcnt++] = NULL;

	return(linv);
}
