/*** HELP.C ***/

#include	"main.h"					/* "TwinTail_de_AngelMode!!" System Header File			*/

char *cttl="Manual for :CMD < Runtime Command >";			// :Command   Manual <Tilte>
char *sttl="Manual for System関数＆System変数";				// System F&V Manual <Title>
char *sman[]={												// System F&V Manual
	"基本事項(データ型 と 変数の定義＆関数の定義)",
	"コマンドライン引数 と 環境変数(配列)",
	"ファイル入出力 と 書式付き出力＆簡易出力",
	"文字列の操作 と データの操作",
	"ネットワーク(TCP/IP,UDP/IP,RAW)",
	"日付(Date) と 時刻(Time)",
	"数学関数 と 数学定数",
	"プロセス と 割り込み＆ＧＣ",
	NULL
};

/************************************************************************************************/
// DISP_USAGE() - Display TT-Engine Usage.
/************************************************************************************************/
void disp_usage(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	eprin("\n");
	eprin("Usage: %s%s%s [%sOption%s] [%sFileName%s]\n",C_BLU(2),TTdeAM_CMD,C_DEF(2),cya,mag);
	eprin("\n");
	eprin("  %s-h | -?%s = Display Usage   Information ( This Page ) & Exit\n",C_CYA(2),C_DEF(2));
	eprin("  %s-v     %s = Display Version Information ( V%s%s ) & Exit\n"			,C_CYA(2),C_DEF(2),
		TTdeAM_VER, sizeof(tint)*8==64 && sizeof(void*)*8==64 ? "ILP64":"ILP**");
	eprin("  %s-i     %s = Execute in Interactive Mode\n"							,C_CYA(2),C_DEF(2));
	eprin("  %s-e     %s = Execute in OneLiner    Mode\n"							,C_CYA(2),C_DEF(2));
	eprin("  %s-t | -x%s = Enable Runtime Trace for Debug [ %s-t -tt -ttt ... | -x%s ]\n"
																					,C_CYA(2),C_DEF(2),C_CYA(2),C_DEF(2));
	eprin("  %s-c | -m%s = {Color|Mono} Text Mode (Default=Auto)\n"					,C_CYA(2),C_DEF(2));
	eprin("\n");
	eprin("  %s-:%s = Display %s\n"				,C_CYA(2),C_DEF(2),cttl);
	eprin("  %s-#%s = Display %s   #={#|0-9}\n"	,C_CYA(2),C_DEF(2),sttl);
	eprin("\n");
	eprin("!!! %sDebug Option%s !!!\n"											,yel);
	eprin("  %s\"--\"Dummy \"-C\"kOnly \"-F\"lex \"-B\"ison \"-M\"em \"-G\"c \"-N\"et \"-^\"Sig \"-!\"Ctr%s\n",yel);
	eprin("\n");
}

/************************************************************************************************/
// DISP_VERNO() - Display TT-Engine Version.
/************************************************************************************************/
void disp_verno(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	eprin("\n");
	eprin("TwinTail_de_AngelMode!! Ver.%s%s%s",C_BLU(2),TTdeAM_VER,C_DEF(2));
	eprin(" (Int=%s%zu%s[Bit]/Dbl=%s%zu%s[Bit]/Ptr=%s%zu%s[Bit])\n",
		C_GRE(2),sizeof(tint )*8,C_DEF(2),C_GRE(2),sizeof(tdbl )*8,C_DEF(2),C_GRE(2),sizeof(void*)*8,C_DEF(2));
	eprin("Copyright (C) 2011.08.15-2020 \"%sNekoMimi(F)%s\" <twintail@angelmode.net>\n",red);
	eprin("\n");
}

/************************************************************************************************/
// DISP_MANUAL() display ":CMD" Help & TT-Lang Manual.
/************************************************************************************************/
void disp_manual(int mode){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	eprin("\n");
	if( mode==':' ){					// ':' List :CMD
		eprin("*** %s *** [ \'%s:%s\' must be 1st column ]\n"		,cttl,red);
		eprin("  %s:h | :?     %s -> Display %s ( This Page )\n"	,red,cttl);
		eprin("  %s:r[ead] FILE%s -> Read  TT-Script       from FILE.\n"				,red);
		eprin("  %s:w[rit] FILE%s -> Write Command History into FILE.\n"				,red);
		eprin("  %s:c[ode]     %s -> Set Start of TT-Script *CODE*. { = __code__ }\n"	,red);
		eprin("  %s:d[ata]     %s -> Set Start of Embedded  *DATA*. { = __data__ }\n"	,red);
		eprin("  %s:q[uit]     %s -> Quit TT-Engine ASAP!!          { =  Ctrl+C  }\n"	,red);
		eprin("\n");
		eprin("!!! %sDebug Command%s !!!\n"												,yel);
		eprin("  %s:t[race] | :not[race]%s -> {Enable|Disable} TT-Script Trace\n"		,yel);
		eprin("  %s:cpu  :mem  :dt ##  :ct ## ( ## = {Dec|Hex} )%s\n"					,yel);
		eprin("%s", mode=='?' ? "\n" : "" );
	}
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( mode=='#' ){					// '#' List {#|0-9}
		char c = ( mode=='?' ? ':' : '-' );
		eprin("*** %s ***\n",sttl);
		for( int i=0 ; sman[i]!=NULL ; i++ )
			eprin("  %s%c%i%s = %s\n",C_CYA(2),c,i,C_DEF(2),sman[i]);
	}
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( mode=='0' ){					// DataType + Vari&Func
		eprin("%s[Manual表題]%s %s\n",r_blu,sman[mode-'0']);
		eprin("  基本データ型  : U=未定義  S=文字列  I=整数型  D=実数型  P=ポインタ  X=関数型\n"  );
		eprin("  派生データ型  : A=配列型と構造体  A[x]  B[x,y,z]  C.z  配列リテラル  E={x,y,z}\n");
		eprin("  変数の定義    : {global|static|*local*} V=初期値 (*default* ,型は代入値)\n");
		eprin("  関数の定義    : def F(x,y){ ... }                (常にglobal,型は戻り値)\n");
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("  NULL(P) / TRUE(I) / FALS(I) / VER(I) / {INT|DBL|PTR}_SIZE(I) / DBL_{MANT|EXPO}SIZE(I)\n");
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("  データ型の種別: I=type  (*)    ### 型文字 ###\n");
		eprin("  データ型の判定: I=isnull(*)    I=istrue(*)    I=isfals(*)    I=isstr (*)    i=isint (*)\n");
		eprin("                  I=isdbl (*)    I=isptr (*)    I=isfunc(*)    I=isarry(*)\n"               );
		eprin("  定義判定＆消去: I=isdef (*)    U=erase (*)\n"                                             );
	}
	if( mode=='1' ){					// CmdLine & Environ
		eprin("%s[Manual表題]%s %s\n",r_blu,sman[mode-'0']);
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("  コマンドライン引数 = argc(I) / argv(A) / argr(I) / args(S) / cmd(S)\n");
		eprin("  環境変数           = env(A)\n");
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("  コマンドライン引数の取得: S=shift([*])   S=opshift([*])\n");
		eprin("  コマンドライン引数の返却:                I=unshift(   )\n");
	}
	if( mode=='2' ){					// FileI/O & *Print*
		eprin("%s[Manual表題]%s %s\n",r_blu,sman[mode-'0']);
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("  ファイルポインタ   = stdin(P) / stdout(P) / stderr(P) / :code(P) / :data(P)\n");
		eprin("  色彩( ANSI Color ) = {C|B|U|R}_{BLA|RED|GRE|YEL|BLU|MAG|CYA|WHI|DEF}(S)\n");
		eprin("  Default書式[ p() ] = FMT_{S2S|I2S|D2S|P2S|N2S}(S)\n");
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("  １文字単位 I/O: I=getc([F])      I=putc([F,]I)    I=ungetc([F,]I)\n");
		eprin("  １行  単位 I/O: S=gets([F])      I=puts([F,]S)    I=ungets([F,]S)\n");
		eprin("  １行[Max=N]I/O: S=getn([F],N)    I=putn([F,]S,N)  I=ungetn([F,]S,N)\n");
		eprin("  Binary(RAW)I/O: (P,N)=read([F,]N) & N=write([F,]P,N)\n");
		eprin("  Fileポインタ  : P=open(F,S)      I=close(F)       I=flush(F)\n");
		eprin("  File位置管理  : I=getpos(F)      I=setpos(F,I)    I=movpos(F,I)    I=rewind(F)\n");
		eprin("  書式付き出力  : I= print(S...)   I=eprint(S...)   S=sprint(S...)   I=fprint(F,s...)\n");
		eprin("  書式付き終了  : U= dying(S...)\n");
		eprin("  簡易＆詳細出力: U= p    (*...)  又は、変数名      U= d    (*...)\n");
	}
	if( mode=='3' ){					// String & DataProc
		eprin("%s[Manual表題]%s %s\n",r_blu,sman[mode-'0']);
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("  文字列の比較  : I=strcmp[i](S1,S2)            I=strncmp[i](S1,S2,I)\n");
		eprin("  文字列内の検索: I=str[r]chr(S,chr)            I=str[r]str (S,str)           (Is,Ie)=strreg(S,/RE/)\n");
		eprin("  文字列内の置換: S={s|g}sub(S,@1,@2)           S={e|r}valesc(S)              {S|I}={uc|lc}(S|I)\n");
		eprin("  改行(等)の削除: S=strip (S)                   S={h|t}strip (S)\n");
		eprin("  部分文字(列)  : I=subchr(S,I)                 S=substr(S,Is,Ie)\n");
		eprin("  文字列の配列化: {A|S}=[p]split(S,@[,I])       {A|S}=[p]scan(S,@[,I])\n");
		eprin("  文字の種別    : I=is{alnum|alpha|ascii|blank|cntrl|digit|graph|lower|print|punct|space|upper|xdigit}(I)\n");
		eprin("  データの変換  : I=int(*)       D=dbl(*)       {I|D}=atov(*)  S=str(*)       P=ptr(*)       /RE/=reg(S)\n");
		eprin("                : I={bin|oct|dec|hex}(S)\n");
		eprin("  消去複製サイズ: U=erase(*)     *=dup  (*)     I=size (*)     I=strlen(S)\n");
		eprin("  配列の変換計測: A=vals (A)     A=keys (A)     I=ndim (A)     A=shape(A)\n");
//                             : |--------------|--------------|--------------|--------------|--------------|
//                             : |--------------|--------------|--------------|--------------|--------------|
	}
	if( mode=='4' ){					// Networking(TCP/IP)
		eprin("%s[Manual表題]%s %s\n",r_blu,sman[mode-'0']);
		eprin("> IPアドレス例: ip   = 127.0.0.1 or 0xFF000001 or \"localhost\"\n");
		eprin("> Port番号  例: port = 7                       or \"echo\"\n");
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("  {UDP|TCP|RAW}_SOCKET / {UDP|TCP|RAW}_TIMEOUT [Sec]\n");
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("UDPソケット作成: sock = udp_socket([ip,port])   ### Client=不要,Server=必要 ###\n");
		eprin("  UDPデータ送信:     len               = tx_udp([sock,]ip,port,buf[,len])      \n");
		eprin("  UDPデータ受信:     (ip,port,buf,len) = rx_udp([sock])                        \n");
		eprin("TCPソケット作成: sock = tcp_socket([ip,port])   ### Client=不要,Server=必要 ###\n");
		eprin("  *Server側準備: sock = listen ([sock]        )                                \n");
		eprin("  *Client側準備: sock = connect([sock,]ip,port)                                \n");
		eprin("  TCPデータ送信:     len               = tx_tcp([sock,]        buf[,len])      \n");
		eprin("  TCPデータ受信:     (buf,len)         = rx_tcp([sock])                        \n");
		eprin("RAWソケット作成: sock = raw_socket([ip])                                       \n");
		eprin("  Ping送信&受信:     sec = ping(ip)                                            \n");
		eprin("共通 Socket情報: (l_ip,s,l_port,s,l_type,r_ip,s,r_port,s,r_type)=sockinfo(sock)\n");
		eprin("共通 IpAddr変換: s =   ip2str({i|s})        i =   ip2int({i|s})                \n");
		eprin("共通 PortNo変換: s = port2str(Proto,{i|s})  i = port2int(Proto,{i|s})          \n");
	}
	if( mode=='5' ){					// Date & Time
		eprin("%s[Manual表題]%s %s\n",r_blu,sman[mode-'0']);
		eprin("> UNIX時刻とは 1970/01/01 00:00:00 からの経過秒(実数)\n");
		eprin("> 時刻構造体は {year|mon|day|hour|min|sec|wday|yday|isdst} をメンバーに持つ\n");
		eprin("  year~min=整数 sec=実数 wday=日曜日(0) yday=1月1日(0) isdst=夏時間(0:無効)\n");
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("  UTC(S) / LTZ(S) / LTZ_OFFSET(I) [sec] / FMT_{SDATE|STIME}(S)\n");
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("時刻情報の取得: d=time()        A=times() (A.ptime,A.utime,A.stime)\n");
		eprin("UNIX時刻の操作: (y,m,d[,h,m,s]=[l]t2ymd(t) || [l]t2ymd(s)\n");
		eprin("              : t=[l]ymd2t(y,m,d[,h,m,s])  || [l]ymd2t(s)\n");
		eprin("時刻の文字列化: s=[l]sdate(t)   s=[l]stime(t)   s=[l]sftime(FMT,t)\n");
		eprin("文字列の時刻化:                             t=[l]sptime(FMT,s)\n");
		eprin("時刻の構造体  : A=t2{utc|ltz}(t)    t={utc|ltz}2t(A)\n");
		eprin("              : A=utc2ltz(A)  A=ltz2utc(A)      A=tm_norm(A)\n");
	}
	if( mode=='6' ){					// Mathematics
		eprin("%s[Manual表題]%s %s\n",r_blu,sman[mode-'0']);
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("  INF / NAN / M_E / M_PI / {INT|DBL}_{MAX|MIN|QUANT|EPSILON}\n");
		eprin("  デフォルト角度単位 SYS_ANGLE = *RAD* or DEG ( *default* ) \n");
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("実数丸め込み: y=ceil (x)    y=floor(x)    y=trunc(x)    y=rint (x)    y=round(x)   \n");
		eprin("絶 対 値    : y=abs  (x)                                                           \n");
		eprin("実数分解合成: (y,z)=modf(x)               (y,i)=frexp(x) & x=ldexp(y,i)            \n");
		eprin("指数関数    : y=exp  (x)    y=exp2 (x)    y=exp10(x)    y=lin  (x)                 \n");
		eprin("対数関数    : y=log  (x)    y=log2 (x)    y=log10(x)    y=dbi  (x)                 \n");
		eprin("乗余＆ルート: z=pow(x,y)    z=mod(x,y)    y=sqrt (x)    y=cbrt (x)                 \n");
		eprin("角度変換    : y=deg(x)  y=rad(x)  (x,y,z)={rad|deg}2dms(a)  a=dms2{rad|deg}(x,y,z) \n");
		eprin("三角関数    : y=[a]sin (x)  y=[a]cos (x)  y=[a]tan (x)  z=atan2(x,y)               \n");
		eprin("双曲関数    : y=[a]sinh(x)  y=[a]cosh(x)  y=[a]tanh(x)                             \n");
		eprin("ベッセル関数: y={j0|y0}(x)  y={j1|y1}(x)  y={jn|yn}(x,y)                           \n");
		eprin("座標変換    : (x,y,z)={x|y|z}rot(x,y,z,a)                                          \n");
		eprin("最大最小中央: y={max|min|med}(@)  i=arg{max|min}(@)  (i,j)=argmed(@)               \n");
		eprin("合計＆平均  : y=sum  (@)    y=ave  (@)                                             \n");
		eprin("分散＆偏差  : y=svar (@)    y=uvar (@)    y=sdev (@)    y=udev (@)                 \n");
		eprin("ガンマ＆誤差: y=lgamma(x)   y=tgamma(x)   y=erf  (x)    y=erfc (x)                 \n");
		eprin("乱数発生    : u=seed (i)    i=rand (i)    y=urand(x)    z=nrand(x,y)               \n");
		eprin("数値判定    : i=isinf(x)    i=isnan(x)                                             \n");
	}
	if( mode=='7' ){					// Proc & Intr+GC
		eprin("%s[Manual表題]%s %s\n",r_blu,sman[mode-'0']);
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("  $(I) / $?(I) / PID(I) / PPID(I) / SIG_{DFL|IGN|ERR}(P)\n");
		eprin("  SIGHUP (I)/ SIGPIPE(I)/ SIGTSTP(I)/ SIGINT (I)/ SIGALRM(I)/ SIGTTIN(I)/SIGQUIT(I)/\n");
		eprin("  SIGILL (I)/ SIGABRT(I)/ SIGFPE (I)/ SIGKILL(I)/ SIGSEGV(I)/ SIGTERM(I)/SIGUSR1(I)/\n");
		eprin("  SIGUSR2(I)/ SIGCHLD(I)/ SIGCONT(I)/ SIGSTOP(I)/ SIGTTOU(I)/\n");
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("プロセス関数:   i=pid( )    i=ppid( )   d=sleep(d)  u=pause( )  u=exit(i)\n");
		eprin("外部コマンド:   i=system(s)             s = `s` [ < s ]\n");
		eprin("割り込み    :   i=tx_sig(Ipid,Isig)     i=rx_sig(Func,Isig)\n");
		eprin("GCの手動実行:   u=gc_collect()\n");
	}
	eprin("\n");
}
