/*** PSUP.C ***/						#include	"main.h"

/************************************************************************************************/
// SET_PRNFMT() copy XPRINTF(3) format string ( DST<-SRC ) for N'th '%' param, then return
// (( format character )<<8) & ( format param type {S/I/D/V/P/B} or '-' ).
/************************************************************************************************/
int set_prnfmt(char *dst,char *src,int n){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

char	*p_sfmt,*p_efmt;				/* Pointer to SRC[] ( Start & End of FMT )			*/
char	tmp[BUFSIZ],chr;

/* Clear DST[] */
	dst[0] = '\0';

/* Set P_SFMT to N'th '%' Char ( or SRC[0] ) */
	p_sfmt = src;
	for( int i=0 ; i<n ; i++ ){			/* I = '%' Counter										*/
		p_sfmt = strchr(p_sfmt+(i==0?0:1),'%'); if( p_sfmt==NULL ){ return('-'); }				// Not Found.
		while( *(p_sfmt+1)=='%' ){		// Skip "%%"
			p_sfmt = strchr(p_sfmt+2     ,'%'); if( p_sfmt==NULL ){ return('-'); }				// Not Found.
		}
	}

/* Set P_EFMT to (N+1)'th '%' Char ( or '\0' ) */
	p_efmt = strchr(p_sfmt+(n==0?0:1),'%');
	if( p_efmt==NULL ){ p_efmt=src+strlen2(src); goto DO_COPY; }		// Not Found, That's OK!!
	while( *(p_efmt+1)=='%' ){			// Skip "%%"
		p_efmt = strchr(p_efmt+2,'%');
		if( p_efmt==NULL ){ p_efmt=src+strlen2(src); goto DO_COPY; }	// Not Found, That's OK!!
	}

DO_COPY:
	assert( (p_efmt-p_sfmt)<BUFSIZ );
	strncpy2(dst,p_sfmt,p_efmt-p_sfmt);
	strncpy2(tmp,p_sfmt,p_efmt-p_sfmt);

/* Expand %[diouxXaAeEfFgGpbBvV] & Return Expected Type */
	if( n==0 ){ return('-'); }
	for( int i=1 ; dst[i]!='\0' ; i++ ){		/// dst[0] = '%' ///
		switch( chr=dst[i] ){
			case '+': case '-': case ' ': case '#': case '.':				break;					/* (Skip!!) */
			case 'h': case 'l': case 'L': case 'j': case 't': case 'z':		break;					/* (Skip!!) */
			case '0': case '1': case '2': case '3': case '4':				break;					/* (Skip!!) */
			case '5': case '6': case '7': case '8': case '9':				break;					/* (Skip!!) */

			case 's':														return((chr<<8)|'S');
			case 'c':														return((chr<<8)|'I');

			case 'd': strcpy2(&dst[i],PRIdTINT); strcat2(dst,&tmp[i+1]);	return((chr<<8)|'I');	/* Replace!! */
			case 'i': strcpy2(&dst[i],PRIiTINT); strcat2(dst,&tmp[i+1]);	return((chr<<8)|'I');	/* Replace!! */
			case 'o': strcpy2(&dst[i],PRIoTINT); strcat2(dst,&tmp[i+1]);	return((chr<<8)|'I');	/* Replace!! */
			case 'u': strcpy2(&dst[i],PRIuTINT); strcat2(dst,&tmp[i+1]);	return((chr<<8)|'I');	/* Replace!! */
			case 'x': strcpy2(&dst[i],PRIxTINT); strcat2(dst,&tmp[i+1]);	return((chr<<8)|'I');	/* Replace!! */
			case 'X': strcpy2(&dst[i],PRIXTINT); strcat2(dst,&tmp[i+1]);	return((chr<<8)|'I');	/* Replace!! */

			case 'a': case 'A': case 'e': case 'E': case 'f': case 'F': case 'g': case 'G':
					  strcpy2(&dst[i],PFX_TDBL); strcat2(dst,&tmp[ i ]);	return((chr<<8)|'D');	/* Insert !! */

			case 'p':														return((chr<<8)|'P');
			case 'b': case 'B':	/* TT-Lang Spec!! (0b|0B)			*/		return((chr<<8)|'B');	// Process Later!!
			case 'v': case 'V':	/* TT-Lang Spec!! (%d|%eE|%fF|%gG)	*/		return((chr<<8)|'V');	// Process Later!!
			default:			/* Illegal Type!!         */				return((chr<<8)|'?');
		}
	} return('-');
}

/************************************************************************************************/
// IVAL2BINSTR() translate TINT into %[bB] string by format, then return pointer to generated
// string or NULL.  [ FMT = '%' + {flag} + {width} + {.prec} + {type} + [bB] + ... + '\0' ]
/************************************************************************************************/
char *ival2binstr(char *fmt,tint ival){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

char	buf[sizeof(tint)*8];			/* Buffer for Binary String								*/
char	ret[BUFSIZ];					/* Buffer for Binary String for Return					*/
char	*p_cur,*p_end;

int		flag_left=FALS;					/* Flag for '-' Left-Justified							*/
int		flag_pref=FALS;					/* Flag for '#' Prefix (0b|0B)							*/
int		flag_zero=FALS;					/* Flag for '0' Zero-Padding							*/
int		width,prec,keta,i;				/* Width.Precision | Keta								*/

/*** Setup Param(s) ***/

/* '%' */
	p_cur=fmt; if( *p_cur!='%' ){ return(NULL); }
	p_cur++;							// Skip

/* {flag} */
	while( *p_cur=='+' || *p_cur=='-' || *p_cur==' ' || *p_cur=='#' || *p_cur=='0' ){
		if(*p_cur=='-'){ flag_left=TRUE; }
		if(*p_cur=='#'){ flag_pref=TRUE; }
		if(*p_cur=='0'){ flag_zero=TRUE; }
		p_cur++;						// Skip
	}

/* {width} */
	width=strtol(p_cur,&p_end,10);
	p_cur=p_end;						// Skip

/* {.prec} */
	prec=0;
	if( *p_cur=='.' ){
		prec=strtol(p_cur+1,&p_end,10);
		p_cur=p_end;					// Skip
	}

/* {type} */
	while( *p_cur=='h' || *p_cur=='l' || *p_cur=='L' || *p_cur=='j' || *p_cur=='z' || *p_cur=='t' )
		p_cur++;						// Skip

/* {format} */
	if( *p_cur!='b' ){ return(NULL); }
	p_cur++;							// Skip

/*** Exec Translate ***/

// idx   = (MSB) 63   ....                                                   ....    8    4    0 (LSB)
// buf[] = (MSB) 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 1010 (LSB)
// ret[] = "00:MSB - 63:LST"

/* Ival -> Str */
	keta=1;								/* At least one (1)										*/
	for( i=0 ; i<sizeof(tint)*8 ; i++ ){
		buf[i] = ((ival>>i)&0x01)==0 ? '0':'1';
		keta   = buf[i]=='1' ? i+1:keta;
	}

/* Copy (1/2) */
	if( keta<width && flag_left==TRUE ){		/*** Ignore  FLAG_ZERO!! ***/
		for( i=0    ; i<keta  ; i++ )
			ret[i] = buf[keta-i-1];					// ret[0] = MSB('1'or'0')
		for( i=keta ; i<width ; i++ )
			ret[i] = ' ';							// ret[ ] = "1010...   "
		ret[i] = '\0';
	}
	if( keta<width && flag_left==FALS ){		/*** Respect FLAG_ZERO!! ***/
		for( i=0 ; i<width-keta ; i++ )
			ret[i] = (flag_zero==TRUE)? '0':' ';	// ret[0] = MSB(' ')
		for( i=0 ; i<keta ; i++ )
			ret[width-keta+i] = buf[keta-i-1];		// ret[ ] = "   1010..."
		ret[width-keta+i] = '\0';
	}
	if( width<=keta ){
		for( i=0 ; i<keta ; i++ )
			ret[i] = buf[keta-i-1];
		ret[i] = '\0';
	}

/* Copy (2/2) */
	strcat2(ret,p_cur);

/* Return */
	return(X_SDUP(ret));
}

/************************************************************************************************/
// PROC_ANSICOLOR() return string with/without ANSI Color. [ by SBCOLOR(FILENO) ]
/************************************************************************************************/
char *proc_ansicolor(int fileno,char *src){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

char	*dst=NULL;
int		i,j,k;							/* dst[j] = src[i] or src[k]							*/

// ANSI Color = ESC + '[' + (##;)* + ##m

/* 着色表示すべき -> 未加工リターン */
	if( sbcolor(fileno) )				// TRUE( Should Be Color ) / FALS( Should *Not* Be Color )
		return(dst=src);

/* 白黒表示すべき -> シーケンス削除 */
	dst = X_MALL( strlen2(src)+1 );
	for( i=0,j=0 ; src[i]!='\0' ; i++,j++ ){

	/* Check ANSI Color */
		if( src[i]=='' && src[i+1]=='[' ){
		/* Skip (##;)* + ##m by K */
			k=i+2;
			while( isdigit(src[k]) && isdigit(src[k+1]) && src[k+2]==';' ) k+=3;
			if   ( isdigit(src[k]) && isdigit(src[k+1]) && src[k+2]=='m' ) k+=3;
		/* Judge             by K */
			if( src[k-1]=='m' ){		// Yes, I2K-1 is ANSI Color -> Skip All ( Adjust I & Goto Next )
				i=k-1; j--; continue;
			}
			else						// No , I2K-1 is Misc Data  -> Use Orig I
				;
		}

	/* Copy */
		dst[j]=src[i];
	}
	dst[j]='\0';
	return(dst);

}
