/*** MAIN.C - Global Variable and MAIN() Function ***/

// (1) TT-Engine - TwinTail_de_AngelMode!! Interpreter. (/usr/local/bin/tt)
// (2) TT-Script - Script Program written in TwinTail_de_AngelMode!!.

#include	"main.h"					/* "TwinTail_de_AngelMode!!" System Header File			*/

/* Define iCPU and iMEM					A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int 	mp=0,mp_base=0;					/* Main Memory Pointer (MP) & MP Base					*/
int 	dp=0,dp_base=0;					/* Data Stack  Pointer (DP) & DP Base					*/
int 	rp=0;							/* Regs Stack  Pointer (RP)								*/
int 	fx=0;							/* FuncXX Index [ Main()=0/(UsrDef)Func()=1,2,3, ... ]	*/
int 	sx=0;							/* Script Index [ Main  =0/(:Read )File  =1,2,3, ... ]	*/

void	**mem;							/* Main Memory ( SIZE = MEM[0], Can be X_RALL()ed !! )	*/
dtab	*ds;							/* Data Stack  ( SIZE = DS [0], Can be X_RALL()ed !! )	*/
rtab	*rs;							/* Regs Stack  ( SIZE = RS [0], Can be X_RALL()ed !! )	*/
ftab	FileTb[IFT_SIZE];

/* Define Global Flag (Init=0)			A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		flag_exerr  =FALS;				/* Flag for Exec Error      { Error Info Value / FALS }	*/
int		flag_imode  ='N';				/* Flag for Exec Mode       { Norm| Intr| Eval| ${}   }	*/
int		flag_vfile  =FALS;				/* Flag for Virtual File    { "/dev/stdin" | argv[]   }	*/
int		flag_eofin  =FALS;				/* Flag for End Of Script File Chain			(T/F)	*/
int		flag_trace  =FALS;				/* Flag for TT-Script Trace [-t] Mode           (T/F)	*/
int		flag_color  ='A';				/* Flag for Text Color      { 'A'uto/ 'C'olor/ 'M'ono }	*/
int		flag_debug  =FALS;				/* Flag for Debug Status    { Debug Info Value / FALS }	*/

int		flag_signing=FALS;				/* Flag for Interrupt Signal Processing Status	(T/F)	*/
int		flag_retning=FALS;				/* Flag for RETN()           Processing Status	(T/F)	*/
int		flag_next,flag_last;			/* Flag for NEXT()/LAST()                   #=NestLevel	*/
int		stmt_nestlv=0;					/* STMT Nest Level          { 0 = No Nest             }	*/
tkval	stmt_nesttk[MAX_STMTNL];		/* STMT Nest Token			{ flow_ctrl && fdef_stmt  }	*/

ctree	*result;						/* Exec Result for DIAG()   { OK=(CTREE*) / NG=NULL   }	*/
ctree	*last_fx,*last_ct,*last_ar;		/* Pointer to { Func | Data | Arry } Node on Error		*/
int		epos,epar[64];					/* Error Position (LAST_CT) & Error Parameter (MAIN.H)	*/

/* Define Global Variable (Init=0)		A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
tdbl	gl_uptime;						/* TT-Engine Process Start-Up Time [Sec]				*/
char	*gl_zone;						/* { TM_ZONE   in General - Name of Time Zone         }	*/
long	gl_gmtoff;						/* { TM_GMTOFF in General - Seconds East of UTC       }	*/

void	*sig_vect[NSIG];				/* Signal Handler Table     { Value = MEM[] Addr!!    }	*/
int		sig_iall=0    ,sig_tall=0    ;	/* Signal Instant All     / Signal Total All			*/
int		sig_icnt[NSIG],sig_tcnt[NSIG];	/* Signal Instant Counter / Signal Total Counter		*/

int		gl_argc=0;						/* ARGC   for TT-Script     { *NOT* for TT-Engine     }	*/
char	**gl_argv;						/* ARGV[] for TT-Script     { *NOT* for TT-Engine     }	*/
int		gl_spos=1;						/* Next Shift Position   in TT-Script ( GL_ARGV[] )		*/
int		gl_colm=1,gl_skip=0;			/* Column Index&SkipByte in TT-Script ( 1 = Head  )		*/
int		tr_file=0,tr_line=0;			/* Last TRACE()ed FileId & LineNo						*/

tint	ga_cntr=0,ga_size=0;			/* BoehmDW-GC Alloc Call Counter & Total Size			*/
tint	gf_cntr=0,gf_size=0;			/* BoehmDW-GC Free  Call Counter & Total Size			*/

/************************************************************************************************/
// MAIN() - "TwinTail_de_AngelMode!!" Main Function.
/************************************************************************************************/
int main(int argc,char *argv[]){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
struct	tms tms_dummy;					/* Dummy Data for TIMES(3)								*/
struct	sigaction s_action;				/* Struct for SIGACTION(2)								*/
int		idx;							/* Index for ARGV[]										*/

/* Check CPU Bit ( >= 32 [BIT] ) */
	if( sizeof(tint)*8<32 ){ dying("Master!! - CPU bit must be >= 32 [BIT]\n"); }

/* Initialize Garbage Collector & Disable Output Buffering */
	GC_INIT();							/* This is required, if BoehmDW-GC Version >= 7.0		*/
//	setbuf(stdout,NULL);				/* Disable STDOUT buffering to improve output quality!!	*/
//	setbuf(stderr,NULL);				/* Disable STDERR buffering to improve output quality!!	*/

/* Set Process Start-Up Time & Time Zone Info */
	gl_uptime  = times(&tms_dummy)/(tdbl)sysconf(_SC_CLK_TCK);
	tzset();							/* Init TZNAME / TIMEZONE / DAYLIGHT					*/
	gl_zone    = X_SDUP(tzname[0]);		/* Get  TM_ZONE            in General					*/
	gl_gmtoff  = -timezone;				/* Get           TM_GMTOFF in General					*/

/* Set Alarm Handler for Time Out */
	s_action.sa_handler = net_alarmhandler;
	if( sigfillset(&(s_action.sa_mask))   < 0 ){ dying("Master!! - Cannot init Signal for SIGALRM\n"); }
	s_action.sa_flags   = 0;
	if( sigaction(SIGALRM,&s_action,NULL) < 0 ){ dying("Master!! - Cannot init Signal for SIGALRM\n"); }

/* Process Option(s) for TT-Engine */
	for( idx=1 ; idx<argc ; idx++ ){	/* idx = 1,2,3, ... argc-1								*/

	/* >Option(s) for TT-Engine */
		if( *argv[idx]=='-' && strlen2(argv[idx])!=1 ){
			proc_option(argv[idx]);		/* Set FLAG_IMODE & FLAG_TRACE/FLAG_COLOR/FLAG_DEBUG	*/
			if( flag_imode=='I' ){        break; }	// "-i" //
			if( flag_imode=='E' ){ idx++; break; }	// "-e" //
			continue;
		}

	/* >TT-Script FileName */
		break;

	}
	if( flag_imode=='N' && argv[idx]==NULL ){ idx--; flag_imode='I'; }	// [FileName] //

// At this point, FLAG_IMODE & FLAG_TRACE/FLAG_COLOR/FLAG_DEBUG are set correctly.
// In "-i"    Mode, ARGV[IDX] points to "-i"               or LAST. ( IDX = (1st)PARAM - 1 )
// In "-e"    Mode, ARGV[IDX] points to TT-Script Body     or NULL. ( IDX = (1st)PARAM - 1 )
// In Default Mode, ARGV[IDX] points to TT-Script FileName or "-" . ( IDX = (1st)PARAM - 1 )

/* Install SysCnst & SysFunc */
	init_icpu();
	inst_syscnst(argc-idx,&argv[idx]);	// GL_ARGC & GL_ARGV
	inst_sysfunc(                   );

/* Prepare for MainScript ( Open File || Open Argv ) */
	switch( flag_imode ){
		case 'N': savchg_f4yy('N',argv[idx]             ); if(strcmp(argv[idx],"-")==0){ flag_vfile= -1/*TRUE*/; } break;
		case 'I': savchg_f4yy('I',"/dev/stdin"          ); flag_vfile= -1/*TRUE*/; break;
		case 'E': savchg_f4yy('E',X_SCAT(argv[idx],"\n")); flag_vfile=idx/*TRUE*/; break;	// Add "\n" to form Legal Script
		default:
				assert(FALS);
	}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

/* Interpret & Execute TT-Script */
LOOP_INTERACT:
	reinit_icpu();
	yyparse();							/* Scanner & Parser										*/
	reinit_icpu();
	main_lc2ds();						/* Deploy TopLevel LC_DTAB into DS[]					*/
	if( flag_debug&DF_MEMDP  ){ eprin("{ Before Execute!! }\n"); dump_mem(); }
	result = ( flag_debug&DF_CKSYN ) ? chk_nullfx():exe_tlvlstmt(mem[mp_base+FX_TREE]);
	if( flag_debug&DF_MEMDP  ){ eprin("{ After  Execute!! }\n"); dump_mem(); }

/* Check Result & Next/Last */
	diag(result);
	if( 0<flag_next )
		msg_r("Too many \"next\" (Remain=%d)\n",flag_next);
	if( 0<flag_last )
		msg_r("Too many \"last\" (Remain=%d)\n",flag_last);

/* Process "-i" Mode Iteration */
	if( flag_imode=='I' && flag_eofin==FALS ){
	/* >Clear Error */
		if( flag_exerr || 0<flag_next || 0<flag_last ){
			flag_exerr=FALS; flag_next=flag_last=0;
//			eprin("%s{ Try Again!! }%s\n",C_GRE(2),C_DEF(2));
		}
	/* >Exec Again */
		main_ds2lc();					/* Restore TopLevel LC_DTAB from DS[]					*/
		goto LOOP_INTERACT;
	}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

/* Process Remaining Signal(s) */
	while( sig_iall!=0 ){ cu_handler(); }

// We should not close any objects here, because YYIN might be changed by FLEX or I_EVAL() at
// runtime.  In that case, we will close wrong FILE *.  Leave it and let OS close it !!

/* Exit TT-Engine */
	if( flag_exerr || 0<flag_next || 0<flag_last )
		exit(1);
	exit(0);
}

/************************************************************************************************/
// PROC_OPTION() - Analyze TT-Engine Option. ( Display & SetFlag )
/************************************************************************************************/
void proc_option(char *opt){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		len = strlen2(opt);

/* Process for all option chars */
	for( int i=1 ; i<len ; i++ ){		/* i = 1,2,3, ... len-1 ( Skip '-' )					*/
		switch( opt[i] ){						/*** Curr 1 Char ***/
		/* >Display Info & Exit */
			case 'h': case '?':	disp_usage (      );	exit(0);
			case 'v':			disp_verno (      );	exit(0);
			case ':': case '#': case '0': case '1': case '2': case '3':
			case '4': case '5': case '6': case '7': case '8': case '9':
								disp_manual(opt[i]);	exit(0);
		/* >Set Flag & Break */
			case 'i':			flag_imode  = 'I';		break;
			case 'e':			flag_imode  = 'E';		break;
			case 't':			flag_trace +=  1 ;		break;
			case 'x':			flag_trace  = INT_MAX;	break;
			case 'c':			flag_color  = 'C';		break;
			case 'm':			flag_color  = 'M';		break;
		/* >( Debug Option ) */
			case '-':			/*** Dummy Option ***/	break;
			case 'C':			flag_debug |= DF_CKSYN;	break;
			case 'F':			flag_debug |= DF_FLEX ;	break;
			case 'B':			flag_debug |= DF_BISON;	break;
			case 'M':			flag_debug |= DF_MEMDP;	break;
			case 'G':			flag_debug |= DF_GCLIB;	break;
			case 'N':			flag_debug |= DF_NETWK;	break;
			case '^':			flag_debug |= DF_SIGNO;	break;
			case '!':			flag_debug |= DF_CTRDP;	break;
		/* >Illegal Option */
			default:
				dying("Master!! - Illegal Option!! [-%c] ( Use \"-h\" for Help )\n",opt[i]);
		}
	}
}
