/*** BISON.Y - Parser Definition [ => y.tab.h + y.tab.c + y.output ] ***/

%{/*1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
#include	"main.h"					// "Twintail_de_AngelMode!!" System Header File
#include	"bsup.c"					// Bison(1) Support Code in C-Lang
#include	"esup.c"					// Bison(1) Support Code in C-Lang !!! ERROR !!!
%}/*1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/

%union{	/* === Parser Stack Type === */
	struct {							/* Bison TOKEN Type [ = YYLVAL Type for Flex I/F ]		*/
		char	*name;					/*> Pointer to {INAM|File} Name							*/
		int		gl,st,lc;				/*> Flag for {GLOBAL|STATIC|LOCAL} Scope	{TRUE|FALS}	*/
		intptr_t		cdx;			/*> Composite DTAB Index (CDX) Value		->(Option)	*/
		struct dtab		*p_dtab;		/*> Pointer to DTAB							->(Option)	*/
		struct ctree	*p_elmt;		/*> Pointer to Arry[] Elmt or NULL			->(Option)	*/
		int		file,line,colm;			/*> TT-Script {File|Line|Colm} Number		->Required	*/
	} tk;
	struct ctree *p_ctr;				/* Pointer to Common Syntax Tree (CTREE)				*/
}

%start	script
%expect	18

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
/* +++ Define Terminal Symbols +++ */
%token	<tk>	SYNC LINK FCAL PRIN ARRY HASH STID				// Special Token & Alias Token ( PRIN = Implied FCAL   )
%token	<tk>	DUMP_CPU DUMP_MEM DUMP_DT DUMP_CT TRACE_CTRL	// Special Token for Debug
%token	<tk>	INAM IMED BKQT									// General Token

/* ( Reserved Keyword ) */
%token	<tk>	GLKW STKW LCKW DEFX
%token	<tk>	IF   ELIF ELSE SWCH CASE DEFT
%token	<tk>	FORS WHIL DOWH EACH LOOP
%token	<tk>	NEXT LAST RETN

/* ( 1-Char Operator  ) */
%token	<tk>	',' '=' '?' ':' '>' '<'
%token	<tk>	'+' '-' '*' '/' '@' '%'
%token	<tk>	'|' '^' '&' '!' '~'
%token	<tk>	'{' '}' '[' ']' '.'

/* ( N-Char Operator  ) */
%token	<tk>	POW SOP VOP VPP VMM SLL SRR PTR
%token	<tk>	CGE CLE CEQ CNE REQ RNE
%token	<tk>	ADDQ SUBQ MULQ DIVQ MODQ POWQ SOPQ VOPQ
%token	<tk>	ANDQ IORQ XORQ SLLQ SRRQ
%token	<tk>	LAND LIOR LXOR

/* +++ Define Priority & Associativity +++ */
%left		','
%right		'=' ADDQ SUBQ MULQ DIVQ MODQ POWQ SOPQ VOPQ ANDQ IORQ XORQ SLLQ SRRQ PTR 
%right		'?' ':'
%left		LIOR
%left		LXOR
%left		LAND
										// C-Lang Bit '|' .lt. '^' .lt. '&'
%nonassoc	CEQ CNE REQ RNE
%nonassoc	'>' '<' CGE CLE
%left		'|'
%left		'^'
%left		'&'
%left		SLL SRR
%left		'+' '-'
%left		'*' '/' '@' '%' SOP VOP
%nonassoc	'!' '~' VPP VMM UNARY
%right		POW
%left		'.'

/* +++ Define Non-Terminal Symbols +++ */
%type	<tk>	lval_sing arry_elmt
%type	<p_ctr>	script tlvl_stmtWT chld_stmtWO chld_multWT
%type	<p_ctr>	fdef_stmtWW defx_fnam fp_list vdef_stmtWO vt_list vt_elmt
%type	<p_ctr>	stmt_listWO stmtWO misc_stmtWO expr_stmtWO flow_ctrlWW bkrw_stmt
%type	<p_ctr>	if_stmt if_part ef_mult ef_part dg_else swch_stmt cs_mult cs_part df_part
%type	<p_ctr>	fors_stmt fors_part whil_stmt each_stmt each_asgn loop_stmt loop_asgn
%type	<p_ctr>	sing_asgn mult_asgn opeq_asgn ppmm_call func_call bkqt_call qcol_call
%type	<p_ctr>	next_stmt last_stmt retn_stmt opt_nls nls nlt
%type	<p_ctr>	exop exwc_list exwc expr_args expr_list expr expr_pure expr_asgn expr_call
%type	<p_ctr>	imed_data arry_init hash_init
%type	<p_ctr>	rval_sing stid lval_mgap lval_sgap

%%/*1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
script: /*Empty*/						{ b("script: /*Empty*/ => <GAP>"	); $$ = mk_cgap();	}	/* Do Nothing !!	*/

	| script error '\n'					{ b("script: error+\'\\n\'"			); $$ = $1;
		flag_exerr=E_PARSER; last_ct=$1; diag(NULL); ;;;YYERROR;;;								}	/* Cause Error !!	*/

// **NOTE** In "-i" mode, YYACCEPT for each statement is required.  It terminates parser and
// returns to MAIN().  But it should be done only when look ahead token ( i.e. yychar ) is empty,
// because YYACCEPT discards them.  FYI: It's *not* empty after IF and/or ELIF.

	| script tlvl_stmtWT				{ b("script: tlvl_stmtWT"			);
		if( iscgap($1)||iscgap($2) ) $$ = mem[mp_base+FX_TREE] = (iscgap($2) ? $1:$2);				/* Install CTREE !!	*/
		else						 $$ = mem[mp_base+FX_TREE] = mk_ctree(LINK,ctpos($2),$1,$2,00);	/* Install CTREE !!	*/
		if( flag_imode=='I' && yychar==YYEMPTY ){ b("*** YYACCEPT ***"); YYACCEPT; }			}

	| script fdef_stmtWW				{ b("script: fdef_stmtWW"			);
		$$ = $1;	/* $2 code is installed by fdef_stmtWW rule. */
		if( flag_imode=='I' && yychar==YYEMPTY ){ b("*** YYACCEPT ***"); YYACCEPT; }			}

// **NOTE** The next rule is required to implement "${...}" evaluation mechanism.  This is done
// with flag_imode=='$' during TT-Engine Runtime Phase.  ( i.e. after Scan & Parse Phase )

	| '$' '{' expr '}'					{ b("script: ${expr}"				);
		$$ = mem[mp_base+FX_TREE] = $3;																/* Install CTREE !!	*/
		if( flag_imode=='$' ){ b("*** YYACCEPT ***"); YYACCEPT; }else{ b("*** YYERROR ***"); YYERROR; } }

/* [tlvl_stmtWT] ********************** A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
tlvl_stmtWT:      nlt			{ b("tlvl_stmtWT: nlt"				); $$ = $1;											}
	| vdef_stmtWO nlt			{ b("tlvl_stmtWT: vdef_stmtWO nlt"	); $$ = $1;											}
	| stmt_listWO nlt			{ b("tlvl_stmtWT: stmt_listWO nlt"	); $$ = $1;											}
	| misc_stmtWO nlt			{ b("tlvl_stmtWT: misc_stmtWO nlt"	); $$ = $1;											}
	| expr_stmtWO nlt			{ b("tlvl_stmtWT: expr_stmtWO nlt"	); $$ = mk_ctree(PRIN,ctpos($1),00,$1,00);			}
	| flow_ctrlWW				{ b("tlvl_stmtWT: flow_ctrlWW"		); $$ = $1; stmt_nestlv--;							}

chld_stmtWO: vdef_stmtWO		{ b("chld_stmtWO: vdef_stmtWO"		); $$ = $1;											}
	| stmt_listWO				{ b("chld_stmtWO: stmt_listWO"		); $$ = $1;											}
	| misc_stmtWO				{ b("chld_stmtWO: misc_stmtWO"		); $$ = $1;											}

chld_multWT: tlvl_stmtWT		{ b("chld_multWT: (1)tlvl_stmtWT"	); $$ = $1;											}
	| chld_multWT tlvl_stmtWT	{ b("chld_multWT: (+)tlvl_stmtWT"	); $$ = mk_ctree(LINK,ctpos($1),$1,$2,00);			}

/* [fdef_stmtWW] ********************** A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
fdef_stmtWW:
	  defx_fnam '('       ')' opt_nls bkrw_stmt	{ b("fdef_stmtWW: defx_fnam ( )"      );
	ctr2p_dtab($1->l)->ival = 0;        $1->r = mk_cgap(); $1->x = $5;		// Set ARGC = 0 & Inst R=<GAP>  ,X=bkwr_stmt
	fx=0; mp_base=GL_DTAB; stmt_nestlv--;								}	// Current Context is TopLevel !!

	| defx_fnam '('fp_list')' opt_nls bkrw_stmt	{ b("fdef_stmtWW: defx_fnam (fp_list)");
	ctr2p_dtab($1->l)->ival = lcnt($3); $1->r = $3;        $1->x = $6;		// Set ARGC = N & Inst R=fp_list,X=bkwr_stmt
	fx=0; mp_base=GL_DTAB; stmt_nestlv--;								}	// Current Context is TopLevel !!

defx_fnam: DEFX INAM				{ b("defx_fnam: DEFX INAM => Install MEM[]");
	ctree *p_ctr = lkinst_fnam4defx(deptk($2));								// Make FNAM Node & Adjust iCPU
	$$ = mem[mp_base+FX_TREE] = mk_ctree(DEFX,tkpos($1),p_ctr,NULL,00);		// Inst DEFX Node ( L=FNAM,R=PARAM,X=STMT )
		 mem[mp_base+FX_INFO] = p_ctr->x;								}	// Inst CDX

fp_list: INAM opt_nls					{ b("fp_list: (1)INAM"); $$ = inst_fparam(deptk($1));								}
	| fp_list','opt_nls INAM opt_nls	{ b("fp_list: (+)INAM"); $$ = mk_ctree(',',tkpos($2),$1,inst_fparam(deptk($4)),00);	}

/* [vdef_stmtWO] ********************** A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
vdef_stmtWO: GLKW vt_list				{ b("vdef_stmtWO: GLKW vt_list"		); $$ = mk_ctree(GLKW,tkpos($1),00,$2,00);	}
	| STKW vt_list						{ b("vdef_stmtWO: STKW vt_list"		); $$ = mk_ctree(STKW,tkpos($1),00,$2,00);	}
	| LCKW vt_list						{ b("vdef_stmtWO: LCKW vt_list"		); $$ = mk_ctree(LCKW,tkpos($1),00,$2,00);	}

vt_list: vt_elmt						{ b("vt_list: (1)vt_elmt"			); $$ = $1;									}
	| vt_list ',' vt_elmt				{ b("vt_list: (+)vt_elmt"			); $$ = mk_ctree(',',tkpos($2),$1,$3,00);	}
vt_elmt: lval_sing						{ b("vt_elmt: lval_sing"			); $$ = lkinst_lparam(deptk($1));			}
	| '('lval_sing')'					{ b("vt_elmt: (lval_sing)"			); $$ = lkinst_lparam(deptk($2));			}
	| sing_asgn							{ b("vt_elmt: sing_asgn"			); $$ = $1;									}
	| '('sing_asgn')'					{ b("vt_elmt: (sing_asgn)"			); $$ = $2;									}
	| mult_asgn							{ b("vt_elmt: mult_asgn"			); $$ = $1;									}
	| '('mult_asgn')'					{ b("vt_elmt: (mult_asgn)"			); $$ = $2;									}

/* [stmt_listWO] ********************** A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
stmt_listWO: stmtWO						{ b("stmt_listWO: (1)stmtWO"		); $$ = $1;									}
	| stmt_listWO ',' stmtWO			{ b("stmt_listWO: (+)stmtWO"		); $$ = mk_ctree(',',tkpos($2),$1,$3,00);	}
stmtWO: sing_asgn						{ b("stmtWO: sing_asgn"				); $$ = $1;									}
	| mult_asgn							{ b("stmtWO: mult_asgn"				); $$ = $1;									}
	| opeq_asgn							{ b("stmtWO: opeq_asgn"				); $$ = $1;									}
	| ppmm_call							{ b("stmtWO: ppmm_call"				); $$ = $1;									}
	| func_call							{ b("stmtWO: func_call"				); $$ = $1;									}
	| bkqt_call							{ b("stmtWO: bkqt_call"				); $$ = $1;									}
misc_stmtWO: next_stmt					{ b("misc_stmtWO: next_stmt"		); $$ = $1;									}
	| last_stmt							{ b("misc_stmtWO: last_stmt"		); $$ = $1;									}
	| retn_stmt							{ b("misc_stmtWO: retn_stmt"		); $$ = $1;									}
	| DUMP_CPU							{ b("misc_stmtWO: DUMP_CPU"			); $$ = mk_debug(DUMP_CPU            );		}
	| DUMP_MEM							{ b("misc_stmtWO: DUMP_MEM"			); $$ = mk_debug(DUMP_MEM            );		}
	| DUMP_DT							{ b("misc_stmtWO: DUMP_DT"			); $$ = mk_debug(DUMP_DT   ,$1.p_elmt);		}
	| DUMP_CT							{ b("misc_stmtWO: DUMP_CT"			); $$ = mk_debug(DUMP_CT   ,$1.p_elmt);		}
	| TRACE_CTRL						{ b("misc_stmtWO: TRACE_CTRL"		); $$ = mk_debug(TRACE_CTRL,$1.p_elmt);		}

expr_stmtWO: expr_pure					{ b("expr_stmtWO: expr_pure"		); $$ = $1;									}

/* **NOTE** flow_ctrlWW can not become stmt_listWO, because flow_ctrlWW followed by bkrw_stmt w/o						*/
/* '{' & '}' will produce a lot of Reduce/Reduce conflicts !!															*/

/* [flow_ctrlWW] ********************** A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
flow_ctrlWW: if_stmt					{ b("flow_ctrlWW: if_stmt"			); $$ = $1;									}
	| swch_stmt							{ b("flow_ctrlWW: swch_stmt"		); $$ = $1;									}
	| fors_stmt							{ b("flow_ctrlWW: fors_stmt"		); $$ = $1;									}
	| whil_stmt							{ b("flow_ctrlWW: whil_stmt"		); $$ = $1;									}
	| each_stmt							{ b("flow_ctrlWW: each_stmt"		); $$ = $1;									}
	| loop_stmt							{ b("flow_ctrlWW: loop_stmt"		); $$ = $1;									}

/* [bkrw_stmt] ************************ A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
bkrw_stmt: '{'                  '}'		{ b("bkrw_stmt: {} => <GAP>"		); $$ = mk_cgap();							}
	| '{'            chld_stmtWO'}'		{ b("bkrw_stmt: {chld_stmtWO}"		); $$ = $2;									}
	| '{'chld_multWT            '}'		{ b("bkrw_stmt: {chld_multWT}"		); $$ = $2;									}
	| '{'chld_multWT chld_stmtWO'}'		{ b("bkrw_stmt: {chld_multWT + WO}"	); $$ = mk_ctree(LINK,tkpos($1),$2,$3,00);	}
	| ';'								{ b("bkrw_stmt: ;  => <GAP>"		); $$ = mk_cgap();							}
	| chld_stmtWO						{ b("bkrw_stmt: chld_stmtWO"		); $$ = $1;									}
	| chld_stmtWO ';'					{ b("bkrw_stmt: chld_stmtWO ;"		); $$ = $1;									}
	| flow_ctrlWW						{ b("bkrw_stmt: flow_ctrlWW"		); $$ = $1;									}

/* [if_stmt] ************************** A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
if_stmt: if_part opt_nls						{ b("if_stmt: IF.OK !!"	); $$ = $1;										}
	| if_part opt_nls                 dg_else	{ b("if_stmt: DG.OK !!"	); $$ = dg_ctree($1,$3);						}
	| if_part opt_nls ef_mult opt_nls			{ b("if_stmt: EF.OK !!"	); $$ = dg_ctree($1,$3);						}
	| if_part opt_nls ef_mult opt_nls dg_else	{ b("if_stmt: AL.OK !!"	); $$ = dg_ctree(dg_ctree($1,$3),$5);			}

ef_mult: ef_part								{ b("ef_mult: (1)EF"	); $$ = $1;										}
	| ef_mult opt_nls ef_part					{ b("ef_mult: (+)EF"	); $$ = dg_ctree($1,$3);						}
if_part: IF   '('expr_list')' opt_nls bkrw_stmt	{ b("if_part: OK !!"	); $$ = mk_ctree(IF  ,tkpos($1),$3,$6,00);		}
ef_part: ELIF '('expr_list')' opt_nls bkrw_stmt	{ b("ef_part: OK !!"	); $$ = mk_ctree(ELIF,tkpos($1),$3,$6,00);		}
dg_else: ELSE            opt_nls bkrw_stmt		{ b("dg_else: OK !!"	); $$ = mk_ctree(ELSE,tkpos($1),00,$3,00);		}

/* [swch_stmt] ************************ A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
swch_stmt:
  SWCH '('expr_list')' opt_nls '{'opt_nls                '}' { b("swch_stmt: {Empty}"); $$=mk_ctree(SWCH,tkpos($1),$3,00,00);}
| SWCH '('expr_list')' opt_nls '{'opt_nls cs_mult        '}' { b("swch_stmt: {CS   }"); $$=mk_ctree(SWCH,tkpos($1),$3,$8,00);}
| SWCH '('expr_list')' opt_nls '{'opt_nls cs_mult df_part'}' { b("swch_stmt: {CS+DF}");
	$$=mk_ctree(SWCH,tkpos($1),$3,dg_ctree($8,$9),00);}
| SWCH '('expr_list')' opt_nls '{'opt_nls         df_part'}' {b("swch_stmt: {   DF}"); $$=mk_ctree(SWCH,tkpos($1),$3,$8,00);}

cs_mult: cs_part							{b("cs_mult: (1)CS"    ); $$=$1;							}
| cs_mult cs_part							{b("cs_mult: (+)CS"    ); $$=dg_ctree($1,$2);				}
cs_part: CASE exwc_list':'					{b("cs_part: /*Empty*/"); $$=mk_ctree(CASE,tkpos($1),$2,00,00);}
| CASE exwc_list':'             chld_stmtWO	{b("cs_part:     tWO"  ); $$=mk_ctree(CASE,tkpos($1),$2,$4,00);}
| CASE exwc_list':' chld_multWT				{b("cs_part: xWT"      ); $$=mk_ctree(CASE,tkpos($1),$2,$4,00);}
| CASE exwc_list':' chld_multWT chld_stmtWO	{b("cs_part: xWT+tWO"  );
	$$=mk_ctree(CASE,tkpos($1),$2,mk_ctree(LINK,ctpos($4),$4,$5,00),00);}
df_part: DEFT          ':'					{b("df_part: /*Empty*/"); $$=mk_ctree(DEFT,tkpos($1),00,00,00);}
| DEFT          ':'             chld_stmtWO	{b("df_part:     tWO"  ); $$=mk_ctree(DEFT,tkpos($1),00,$3,00);}
| DEFT          ':' chld_multWT				{b("df_part: xWT"      ); $$=mk_ctree(DEFT,tkpos($1),00,$3,00);}
| DEFT          ':' chld_multWT chld_stmtWO	{b("df_part: xWT+tWO"  );
	$$=mk_ctree(DEFT,tkpos($1),00,mk_ctree(LINK,ctpos($3),$3,$4,00),00);}

/* [fors_stmt|whil_stmt] ************** A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
fors_stmt: FORS '(' fors_part ';' expr_list ';' fors_part ')' opt_nls bkrw_stmt		{ b("fors_stmt: OK !!"		);
		$$ = mk_ctree(FORS,tkpos($1),mk_ctree(';',ctpos($3),$3,$7,00),$10,00); $$->l->x=$5;									}
fors_part: /*Empty*/								{ b("fors_part: /*Empty*/ => <GAP>"	); $$ = mk_cgap();					}
	| chld_stmtWO									{ b("fors_part: tlWO"				); $$ = $1;							}

whil_stmt: WHIL '('expr_list')' opt_nls bkrw_stmt	{ b("whil_stmt: WH.OK !!"	); $$ = mk_ctree(WHIL,tkpos($1),$3,$6,00);	}
	| DOWH      '('expr_list')' opt_nls bkrw_stmt	{ b("whil_stmt: DO.OK !!"	); $$ = mk_ctree(DOWH,tkpos($1),$3,$6,00);	}

/* [each_stmt|loop_stmt] ************** A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
each_stmt: EACH '('each_asgn')' opt_nls bkrw_stmt	{ b("each_stmt: OK !!"); $$ = mk_ctree(EACH,tkpos($1),$3,$6,00);	}
each_asgn: lval_sing '=' expr	{ b("each_asgn: lval =  expr"); $$ = mk_ctree('=',tkpos($2),lkinst_lparam(deptk($1)),$3,00);}

loop_stmt: LOOP '('loop_asgn')' opt_nls bkrw_stmt	{ b("loop_stmt: OK !!"); $$ = mk_ctree(LOOP,tkpos($1),$3,$6,00);	}
loop_asgn: lval_sing '<' expr	{ b("loop_asgn: lval <  expr"); $$ = mk_ctree('<',tkpos($2),lkinst_lparam(deptk($1)),$3,00);}
	| lval_sing CLE expr		{ b("loop_asgn: lval <= expr"); $$ = mk_ctree(CLE,tkpos($2),lkinst_lparam(deptk($1)),$3,00);}

/* [sing_asgn|mult_asgn|opeq_asgn] **** A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
sing_asgn: lval_sing '=' expr		{ b("sing_asgn: OK!!"); $$ = mk_ctree('=',tkpos($2),lkinst_lparam(deptk($1)),$3,00);}
mult_asgn: '('lval_mgap')' '=' expr	{ b("mult_asgn: OK!!"); $$ = mk_ctree('=',tkpos($4),$2,$5,00);						}

opeq_asgn: lval_sing ADDQ expr	{ b("opeq_asgn: lval_sing +=  expr"	); $$ = opeq($2,'+',lkinst_lparam(deptk($1)),$3);	}
	| lval_sing SUBQ expr		{ b("opeq_asgn: lval_sing -=  expr"	); $$ = opeq($2,'-',lkinst_lparam(deptk($1)),$3);	}
	| lval_sing MULQ expr		{ b("opeq_asgn: lval_sing *=  expr"	); $$ = opeq($2,'*',lkinst_lparam(deptk($1)),$3);	}
	| lval_sing DIVQ expr		{ b("opeq_asgn: lval_sing /=  expr"	); $$ = opeq($2,'/',lkinst_lparam(deptk($1)),$3);	}
	| lval_sing MODQ expr		{ b("opeq_asgn: lval_sing %=  expr"	); $$ = opeq($2,'%',lkinst_lparam(deptk($1)),$3);	}
	| lval_sing POWQ expr		{ b("opeq_asgn: lval_sing **= expr"	); $$ = opeq($2,POW,lkinst_lparam(deptk($1)),$3);	}
	| lval_sing SOPQ expr		{ b("opeq_asgn: lval_sing <>= expr"	); $$ = opeq($2,SOP,lkinst_lparam(deptk($1)),$3);	}
	| lval_sing VOPQ expr		{ b("opeq_asgn: lval_sing ><= expr"	); $$ = opeq($2,VOP,lkinst_lparam(deptk($1)),$3);	}
	| lval_sing ANDQ expr		{ b("opeq_asgn: lval_sing &=  expr"	); $$ = opeq($2,'&',lkinst_lparam(deptk($1)),$3);	}
	| lval_sing IORQ expr		{ b("opeq_asgn: lval_sing |=  expr"	); $$ = opeq($2,'|',lkinst_lparam(deptk($1)),$3);	}
	| lval_sing XORQ expr		{ b("opeq_asgn: lval_sing ^=  expr"	); $$ = opeq($2,'^',lkinst_lparam(deptk($1)),$3);	}
	| lval_sing SLLQ expr		{ b("opeq_asgn: lval_sing <<= expr"	); $$ = opeq($2,SLL,lkinst_lparam(deptk($1)),$3);	}
	| lval_sing SRRQ expr		{ b("opeq_asgn: lval_sing >>= expr"	); $$ = opeq($2,SRR,lkinst_lparam(deptk($1)),$3);	}

/* [{ppmm,func,bkqt,qcol}_call] ******* A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
ppmm_call: VPP lval_sing	{ b("ppmm_call: ++lval_sing"); $$ = mk_ctree(VPP,tkpos($1),00,lkinst_lparam(deptk($2)),00);	}
	| VMM lval_sing			{ b("ppmm_call: --lval_sing"); $$ = mk_ctree(VMM,tkpos($1),00,lkinst_lparam(deptk($2)),00);	}
	| lval_sing VPP			{ b("ppmm_call: lval_sing++"); $$ = mk_ctree(VPP,tkpos($1),lkinst_lparam(deptk($1)),00,00);	}
	| lval_sing VMM			{ b("ppmm_call: lval_sing--"); $$ = mk_ctree(VMM,tkpos($1),lkinst_lparam(deptk($1)),00,00);	}

func_call: lval_sing '('expr_args')'	{ b("func_call: lval_sing(expr_args)");
	ctree *p_ctr = lkinst_fnam4call(deptk($1));    $$ = mk_ctree(FCAL,tkpos($1),p_ctr,iscgap($3)?00:$3,00);				}

bkqt_call: BKQT		{ b("bkqt_call: BKQT"		); $$ = mk_ctree(BKQT,tkpos($1),mk_cleaf(0x00,tkpos($1),$1.cdx),00,00);	}
	| BKQT '<' expr	{ b("bkqt_call: BKQT < expr"); $$ = mk_ctree(BKQT,tkpos($1),mk_cleaf(0x00,tkpos($1),$1.cdx),$3,00);	}

qcol_call: expr '?' expr ':' expr
	{ b("qcol_call: expr ? expr : expr"	);         $$ = mk_ctree('?',tkpos($2),$1,mk_ctree(':',tkpos($4),$3,$5,00),00);	}

/* [{next,last,retn}_stmt] ************ A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
next_stmt: NEXT							{ b("next_stmt: NEXT"				); $$ = mk_ctree(NEXT,tkpos($1),00,00,00);	}
	| NEXT '('exop     ')'				{ b("next_stmt: NEXT(exop    )"		); $$ = mk_ctree(NEXT,tkpos($1),$3,00,00);	}
last_stmt: LAST							{ b("last_stmt: LAST"				); $$ = mk_ctree(LAST,tkpos($1),00,00,00);	}
	| LAST '('exop     ')'				{ b("last_stmt: LAST(exop    )"		); $$ = mk_ctree(LAST,tkpos($1),$3,00,00);	}
retn_stmt: RETN							{ b("retn_stmt: RETN"				); $$ = mk_ctree(RETN,tkpos($1),00,00,00);	}
	| RETN '('expr_args')'				{ b("retn_stmt: RETN(expr_args)"	); $$ = mk_ctree(RETN,tkpos($1),$3,00,00);	}

/* [opt_nls|nlt] ********************** A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
opt_nls: /*Empty*/						{ b("opt_nls: /*Empty*/ => <GAP>"	); $$ = mk_cgap();							}
	| nls								{ b("opt_nls: nls       => <GAP>"	); $$ = mk_cgap();							}
nls: '\n'								{ b("nls: (1)\'\\n\'    => <GAP>"	); $$ = mk_cgap();							}
	| nls '\n'							{ b("nls: (+)\'\\n\'    => <GAP>"	); $$ = mk_cgap();							}
nlt: '\n'								{ b("nlt: \'\\n\'       => <GAP>"	); $$ = mk_cgap();							}
	| ';'								{ b("nlt: \';\'         => <GAP>"	); $$ = mk_cgap();							}
	| SYNC								{ b("nlt: SYNC          => <GAP>"	); $$ = mk_cgap();							}

/* [exop|exwc_list] ******************* A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
exop: /*Empty*/							{ b("exop: /*Empty*/ => <GAP>"	); $$ = mk_cgap();								}
	| expr								{ b("exop: expr"				); $$ = $1;										}

exwc_list: exwc opt_nls					{ b("exwc_list: (1)exwc"		); $$ = $1;										}
	| exwc_list','opt_nls exwc opt_nls	{ b("exwc_list: (+)exwc"		); $$ = mk_ctree(',',tkpos($2),$1,$4,00);		}
exwc: '*'								{ b("exwc: \'*\' => <GAP>"		); $$ = mk_cgap();								}
	| expr								{ b("exwc: expr"				); $$ = $1;										}

/* [expr_args|expr_list] ************** A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
expr_args: /*Empty*/					{ b("expr_args: /*Empty*/ => <GAP>"	); $$ = mk_cgap();							}
	| expr_list							{ b("expr_args: expr_list"			); $$ = $1;									}

expr_list: expr opt_nls					{ b("expr_list: (1)expr"			); $$ = $1;									}
	| expr_list','opt_nls expr opt_nls	{ b("expr_list: (+)expr"			); $$ = mk_ctree(',',tkpos($2),$1,$4,00);	}

expr: expr_pure							{ b("expr: expr_pure"				); $$ = $1;									}
	| expr_asgn							{ b("expr: expr_asgn"				); $$ = $1;									}
	| expr_call							{ b("expr: expr_call"				); $$ = $1;									}

expr_pure: '('expr')'					{ b("expr_pure: (expr)"				); $$ = $2;									}
	| '+' expr %prec UNARY				{ b("expr_pure: +expr %prec UNARY"	); $$ = mk_ctree('+' ,tkpos($1),00,$2,00);	}
	| '-' expr %prec UNARY				{ b("expr_pure: -expr %prec UNARY"	); $$ = mk_ctree('-' ,tkpos($1),00,$2,00);	}
	| '~' expr %prec UNARY				{ b("expr_pure: ~expr %prec UNARY"	); $$ = mk_ctree('~' ,tkpos($1),00,$2,00);	}
	| '!' expr %prec UNARY				{ b("expr_pure: !expr %prec UNARY"	); $$ = mk_ctree('!' ,tkpos($1),00,$2,00);	}

	| expr '+' expr						{ b("expr_pure: expr + expr"		); $$ = mk_ctree('+' ,tkpos($2),$1,$3,00);	}
	| expr '-' expr						{ b("expr_pure: expr - expr"		); $$ = mk_ctree('-' ,tkpos($2),$1,$3,00);	}
	| expr '*' expr						{ b("expr_pure: expr * expr"		); $$ = mk_ctree('*' ,tkpos($2),$1,$3,00);	}
	| expr '/' expr						{ b("expr_pure: expr / expr"		); $$ = mk_ctree('/' ,tkpos($2),$1,$3,00);	}
	| expr '@' expr						{ b("expr_pure: expr @ expr"		); $$ = mk_ctree('@' ,tkpos($2),$1,$3,00);	}
	| expr '%' expr						{ b("expr_pure: expr % expr"		); $$ = mk_ctree('%' ,tkpos($2),$1,$3,00);	}
	| expr POW expr						{ b("expr_pure: expr ** expr"		); $$ = mk_ctree(POW ,tkpos($2),$1,$3,00);	}
	| expr SOP expr						{ b("expr_pure: expr ** expr"		); $$ = mk_ctree(SOP ,tkpos($2),$1,$3,00);	}
	| expr VOP expr						{ b("expr_pure: expr ** expr"		); $$ = mk_ctree(VOP ,tkpos($2),$1,$3,00);	}
	| expr '>' expr						{ b("expr_pure: expr > expr"		); $$ = mk_ctree('>' ,tkpos($2),$1,$3,00);	}
	| expr '<' expr						{ b("expr_pure: expr < expr"		); $$ = mk_ctree('<' ,tkpos($2),$1,$3,00);	}
	| expr CGE expr						{ b("expr_pure: expr >= expr"		); $$ = mk_ctree(CGE ,tkpos($2),$1,$3,00);	}
	| expr CLE expr						{ b("expr_pure: expr <= expr"		); $$ = mk_ctree(CLE ,tkpos($2),$1,$3,00);	}
	| expr CEQ expr						{ b("expr_pure: expr == expr"		); $$ = mk_ctree(CEQ ,tkpos($2),$1,$3,00);	}
	| expr CNE expr						{ b("expr_pure: expr != expr"		); $$ = mk_ctree(CNE ,tkpos($2),$1,$3,00);	}
	| expr REQ expr						{ b("expr_pure: expr ~~ expr"		); $$ = mk_ctree(REQ ,tkpos($2),$1,$3,00);	}
	| expr RNE expr						{ b("expr_pure: expr !~ expr"		); $$ = mk_ctree(RNE ,tkpos($2),$1,$3,00);	}
	| expr '&' expr						{ b("expr_pure: expr & expr" 		); $$ = mk_ctree('&' ,tkpos($2),$1,$3,00);	}
	| expr '|' expr						{ b("expr_pure: expr | expr" 		); $$ = mk_ctree('|' ,tkpos($2),$1,$3,00);	}
	| expr '^' expr						{ b("expr_pure: expr ^ expr" 		); $$ = mk_ctree('^' ,tkpos($2),$1,$3,00);	}
	| expr SLL expr						{ b("expr_pure: expr << expr"		); $$ = mk_ctree(SLL ,tkpos($2),$1,$3,00);	}
	| expr SRR expr						{ b("expr_pure: expr >> expr"		); $$ = mk_ctree(SRR ,tkpos($2),$1,$3,00);	}
	| expr LAND expr					{ b("expr_pure: expr && expr"		); $$ = mk_ctree(LAND,tkpos($2),$1,$3,00);	}
	| expr LIOR expr					{ b("expr_pure: expr || expr"		); $$ = mk_ctree(LIOR,tkpos($2),$1,$3,00);	}
	| expr LXOR expr					{ b("expr_pure: expr ^^ expr"		); $$ = mk_ctree(LXOR,tkpos($2),$1,$3,00);	}

	| imed_data							{ b("expr_pure: imed_data"			); $$ = $1;									}
	| rval_sing							{ b("expr_pure: rval_sing"			); $$ = $1;									}

	| '&'lval_sing       %prec UNARY	{ b("expr_pure: &lval_sing"			); $$ = mk_ctree('&',tkpos($1),00, lkinst_lparam(deptk($2)         ) ,00);}
	| '&'lval_sing'('')' %prec UNARY	{ b("expr_pure: &lval_sing()"		);
		ctree *p_ctr = lkinst_fnam4call(deptk($2)); /* Make FNAM Node */       $$ = mk_ctree('&',tkpos($1),00,p_ctr,00);}

expr_asgn: sing_asgn					{ b("expr_asgn: sing_asgn"			); $$ = $1;									}
	| mult_asgn							{ b("expr_asgn: mult_asgn"			); $$ = $1;									}
	| opeq_asgn							{ b("expr_asgn: opeq_asgn"			); $$ = $1;									}

expr_call: ppmm_call					{ b("expr_call: ppmm_call"			); $$ = $1;									}
	| func_call							{ b("expr_call: func_call"			); $$ = $1;									}
	| bkqt_call							{ b("expr_call: bkqt_call"			); $$ = $1;									}
	| qcol_call							{ b("expr_call: qcol_call"			); $$ = $1;									}

/* [imed_data] ************************ A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
imed_data: IMED							{ b("imed_data: IMED"		); $$ = mk_cleaf(00 ,tkpos($1),$1.cdx);	/* TK=>CT */}
	| '{' opt_nls arry_init '}'			{ b("imed_data: {arry_init}"); $$ = mk_ctree('{',tkpos($1),$3,00,00 );			}
	| '{' opt_nls hash_init '}'			{ b("imed_data: {hash_init}"); $$ = mk_ctree('}',tkpos($1),$3,00,00 );			}

arry_init: exop                         opt_nls	{ b("arry_init: (1)"); $$ = $1;											}
	| arry_init','opt_nls exop          opt_nls	{ b("arry_init: (+)"); $$ = mk_ctree(',',tkpos($2),$1,$4,00);			}
hash_init: expr PTR expr                opt_nls	{ b("hash_init: (1)"); $$ = mk_ctree(PTR,tkpos($2),$1,$3,00);			}
	| hash_init','                      opt_nls	{ b("hash_init: (+)"); $$ = $1;											}
	| hash_init','opt_nls expr PTR expr opt_nls	{ b("hash_init: (+)"); $$ = mk_ctree(',',tkpos($2),$1, mk_ctree(PTR,ctpos($4),$4,$6,00) ,00);}

/* [rval_sing|lval_sing|lval_mgap] **** A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
rval_sing: lval_sing					{ b("rval_sing: lval_sing"		); $$ = lkinst_rparam(deptk($1));	/* TK=>CT */}
lval_sing: INAM							{ b("lval_sing: INAM"			); $$ = $1;										}
	| INAM '['opt_nls ']'				{ b("lval_sing: INAM[]"			); $$ = $1;										}
	| INAM '.' stid						{ b("lval_sing: INAM.stid"		); $$ = $1; $$.p_elmt =                     mk_ctree(STID,tkpos($2),NULL,$3,00)  ;}
	| arry_elmt							{ b("lval_sing: arry_elmt"		); $$ = $1;										}
	| arry_elmt '.' stid				{ b("lval_sing: arry_elmt.stid"	); $$ = $1; $$.p_elmt = dg_ctree($$.p_elmt, mk_ctree(STID,tkpos($2),NULL,$3,00) );}

arry_elmt: INAM '['opt_nls expr_list']'	{ b("arry_elmt: INAM[expr_list]"); $$ = $1; $$.p_elmt =                     mk_ctree(ARRY,tkpos($2),NULL,$4,00)  ;}
	| arry_elmt '['opt_nls expr_list']'	{ b("arry_elmt: SELF[expr_list]"); $$ = $1; $$.p_elmt = dg_ctree($$.p_elmt, mk_ctree(ARRY,tkpos($2),NULL,$4,00) );}
stid: INAM								{ b("stid: (1)"); $$ =                            inst_struid(deptk($1))     ;	}
	| stid '.' INAM						{ b("stid: (+)"); $$ = mk_ctree('.',tkpos($2),$1, inst_struid(deptk($3)) ,00);	}

lval_mgap: lval_sgap ',' lval_sgap		{ b("lval_mgap: (2)"	); $$ = mk_ctree(',',tkpos($2),$1,$3,00);				}
	| lval_mgap ',' lval_sgap			{ b("lval_mgap: (+)"	); $$ = mk_ctree(',',tkpos($2),$1,$3,00);				}
lval_sgap: '*'							{ b("lval_sgap: \'*\' => <GAP>"	); $$ = mk_cgap();					/* **=>CT */}
	| lval_sing							{ b("lval_sgap: (1)"			); $$ = lkinst_lparam(deptk($1));	/* TK=>CT */}

%%/*1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---O---P---Q---R---S---T---*/
