/*** X_BKQT.C ***/                      #include    "main.h"

#define		P_RD		0				/* for pipe(2)											*/
#define		P_WR		1				/* for pipe(2)											*/

// ★文字列を外部コマンドとして実行し… ( ×標準入力無し | ○画面出力有り )
// > RET = SYSTEM(STR)  -> コマンド終了値($?)を戻り値とする。{ ***** | ○out | ○err | 戻り値 $? }
// > RET = `STR` < EXPR -> コマンド標準出力  を戻り値とする。{ <EXPR | (RET) | ○err | 戻り値 $? }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *x_bkqt(ctree *ptr){				/*** TT-Lang: A = `X` | `X` < Y ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/

ctree	*ans;			dtab	*a,*x,*y,*dq;				/*** DQ => $? ***/

FILE	*fp_i,*fp_o;					/* File Pointer for CHILD's STDIN&STDOUT				*/
char	buf[BUFSIZ];					/* I/O Buffer for STDOUT								*/
int		fd_p2c[2],fd_c2p[2],pid,status;	/* File Descriptor / Process ID / Status				*/
int		alen;

/* Debug & PreCheck */
	chk_point(ptr);

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( eva_expr(ptr->l,1) ); chk_error(ptr);                chk_vtype(x,"S",0);	/* L=>0 */
	y = ctr2p_dtab( eva_expr(ptr->r,1) ); chk_error(ptr); if( y!=NULL ){ chk_vtype(y,"S",1); }	/* R=>1 */
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

/* Do BKQT()!! */

// We will fork the command process here, in order to take control of both STDIN and STDOUT.
/*----------------------------------------------------------------------------------------------*/
//              P_WR              P_RD             P_WR              P_RD
//                    +--------+                         +--------+
//  [ PARENT ]  ===>  | fd_p2c |  ===>  [ CHILD ]  ===>  | fd_c2p |  ===>  [ PARENT ]
//                    +--------+        ^       ^        +--------+
//                               STDIN_(0)     STDOUT(1)
/*----------------------------------------------------------------------------------------------*/

/* Create Pipes & Fork Process */
	if( pipe(fd_p2c)<0 || pipe(fd_c2p)<0 ){ flag_exerr=NullSYS; return(NULL); }
	if( (pid=fork())<0                   ){ flag_exerr=NullSYS; return(NULL); }

/*** CHILD ***/
	if( pid==0 ){

	/* Set STDIN/STDOUT */
		if( dup2(fd_p2c[P_RD],0)<0 ){ flag_exerr=NullSYS; return(NULL); }	/* STDIN_(0) */
		if( dup2(fd_c2p[P_WR],1)<0 ){ flag_exerr=NullSYS; return(NULL); }	/* STDOUT(1) */

	/* Close Pipes */
		if( close(fd_p2c[P_WR])<0 || close(fd_p2c[P_RD])<0 ){ flag_exerr=NullSYS; return(NULL); }
		if( close(fd_c2p[P_WR])<0 || close(fd_c2p[P_RD])<0 ){ flag_exerr=NullSYS; return(NULL); }

	/* Exec Command */
		execlp("sh","sh","-c",x->str,NULL);

	}

/*** PARENT ***/
/* Translate <FD> into <FP> */
	if( (fp_i=fdopen(fd_p2c[P_WR],"w"))==NULL ){ flag_exerr=NullSYS; return(NULL); }
	if( (fp_o=fdopen(fd_c2p[P_RD],"r"))==NULL ){ flag_exerr=NullSYS; return(NULL); }

/* Close Pipes */
	if( close(fd_p2c[P_RD])<0 || close(fd_c2p[P_WR])<0 ){ flag_exerr=NullSYS; return(NULL); }

/* Write Data into CHILD & Close <FP_I> */
	if( y==NULL )						/* A = `X`												*/
		;
	else{								/* A = `X` < Y											*/
		if(fputs(y->str,fp_i)==EOF){ flag_exerr=NullSYS; return(NULL); }
	}

	if( fclose(fp_i)==EOF ){ flag_exerr=NullSYS; return(NULL); }

/* Read Data from CHILD & Close <FP_O> */
	a->type = 'S';
	a->str  = NULL;
	alen = 0;
	while( TRUE ){
		if( fgets(buf,BUFSIZ,fp_o)==NULL )
			break;
		alen += strlen2(buf);
		a->str = X_RALL(a->str,alen+1);
		strcat2(a->str,buf);
	}

	if( fclose(fp_o)==EOF ){ flag_exerr=NullSYS; return(NULL); }

/* Wait CHILD & Return */
	wait(&status);
	if( a->str==NULL ){ a->str=X_SDUP(""); }
	dq=PTR2DOLQ(); dq->type='I'; dq->ival=WEXITSTATUS(status);		/*** Exit Status => $? ***/
	return ans;

}
