/*** I_PARTS.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_subchr(ctree *ctr){			/*** TT-Lang: A = SUBCHR(X,Y) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;
int		xlen,ic;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SP",0);
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

	if( isnull(x) ){ null_dtab(a); return ans; }

/* Do SUBCHR()!! */
	xlen = strlen2(cstr(x));
	ic   = cint(y); if( ic<0 ){ ic+=xlen; } if( ic<0 || xlen<=ic ){ null_dtab(a); return ans; }
	a->type='I'; a->ival=((cstr(x)[ic])&0xFF); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_substr(ctree *ctr){			/*** TT-Lang: A = SUBSTR(X,Y,Z) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y,*z;
int		alen,xlen,is,ie;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SP",0);
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);
	z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(z,"ID",2);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

	if( isnull(x) ){ null_dtab(a); return ans; }

/* Do SUBSTR()!! */
	xlen = strlen2(cstr(x));
	is   = cint(y); if( is<0 ){ is+=xlen; } if( is<0 || xlen<=is ){ null_dtab(a); return ans; }
	ie   = cint(z); if( ie<0 ){ ie+=xlen; } if( ie<0 || xlen<=ie ){ null_dtab(a); return ans; }
	alen = ie-is+1;                         if( ie<is            ){ null_dtab(a); return ans; }
	a->type='S'; a->str=X_NDUP(cstr(x)+is,alen); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_chop(ctree *ctr){				/*** TT-Lang: A = CHOP(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
int		alen,xlen;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SP",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

	if( isnull(x) ){ null_dtab(a); return ans; }

/* Do CHOP()!! */
	xlen = strlen2(cstr(x));
	if( 2<=xlen && cstr(x)[xlen-2]=='\r' && cstr(x)[xlen-1]=='\n' )		// CR+LF
		alen = xlen-2;
	else if( 1<=xlen && cstr(x)[xlen-1]=='\r' )							// CR
		alen = xlen-1;
	else if( 1<=xlen && cstr(x)[xlen-1]=='\n' )							// LF
		alen = xlen-1;
	else
		alen = xlen  ;
	a->type='S'; a->str=X_NDUP(cstr(x),alen); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_strip(ctree *ctr,int mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
char	*ps,*pe;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SP",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do STRIP()!! */
	ps = cstr(x);								// STR = "... CCC ... CCCMMMMMCCC ... CCC\0"
	pe = ps+strlen2(ps);						//        ^PS                            ^PE
	if( mode=='*' || mode=='H' ){ while( (ps<pe) && isspace(*(ps  )) ){ ps++; } }
	if( mode=='*' || mode=='T' ){ while( (ps<pe) && isspace(*(pe-1)) ){ pe--; } }
	a->type='S'; a->str=X_NDUP(ps,pe-ps); return ans;
}
ctree *i_strip (ctree *ctr){ /*** TT-Lang: A = STRIP (X) ***/ return do_strip(ctr,'*'); }
ctree *i_hstrip(ctree *ctr){ /*** TT-Lang: A = HSTRIP(X) ***/ return do_strip(ctr,'H'); }
ctree *i_tstrip(ctree *ctr){ /*** TT-Lang: A = TSTRIP(X) ***/ return do_strip(ctr,'T'); }
