/*** I_SPLIT.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_split(ctree *ctr,int flag_compact){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y,*z,*e;	int		cnt;
char	*ps,*pe,*ms,*me,*p_str;
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
regmatch_t	pmatch;						/* /RE/ Substr Address Info Buffer						*/
int			errcode;					/* /RE/ Error Code										*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/* Set Param(s) & Check Type(s) */
	cnt = lcnt(ctr);					/* CNT = ARGC of this Func()							*/
	if( cnt!=2 && cnt!=3 ){ flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=2,epar[2]=3; return NULL; }

	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SP"  ,0);
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"SPID",1);
	switch( cnt ){
		case 2: z = NULL;												break;
		case 3: z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(z,"ID",2);	break;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

	if( isnull(x)||isnull(y) ){ null_dtab(a); return ans; }

/* Do SPLIT()!! */
	ps = cstr(x);			ms = NULL;			// STR = "... CCC ... CCCMMMMMCCC ... CCC\0"
	pe = ps+strlen2(ps);	me = NULL;			//            ^PS        ^MS  ^ME        ^PE

// Note: Y specifies delimiter.  (1)BOL-Delim (2)Delim-Delim (3)Delim-EOL and (4)BOL-(Empty)-EOL
// will yield GAP.  FLAG_COMPACT disables GAP generation in result Array[].

// *** Main Loop Start *** //
	for( int idx=0 ; TRUE ; idx++ ){	/* IDX = 0,1,2, ... ( Arry Index || Word Index )		*/

	//+++ Call Regexp +++//
		if( (y->type=='S'||y->type=='P') &&  isreg(y) ){	// SPLIT(STR,/RE/[,IDX])
			if( y->ptr2==NULL ){ regcc(y); }				// Compile & Save /RE/
			errcode = regexec(y->ptr2,ps,1,&pmatch,0);		// Try Match
			if( errcode==0 ){								//*** Matched !! ***
				ms = ps+pmatch.rm_so;
				me = ps+pmatch.rm_eo;
				if( pmatch.rm_eo==0 ){ flag_exerr=E_REGINF; last_ct=lptr(ctr,1); return NULL; }	//*** Infinit !! ***
			}
			else{											//*** NoMatch !! ***
				ms = NULL;
				me = NULL;
			}
		}
	//+++ Call Strstr +++//
		if( (y->type=='S'||y->type=='P') && !isreg(y) ){	// SPLIT(STR,STR[,IDX])
			ms = strstr(ps,cstr(y));
			me = (ms==NULL) ? NULL:(ms+strlen2(cstr(y)));
		}
	//+++ Call Strchr +++//
		if( y->type=='I' || y->type=='D' ){ 				// SPLIT(STR,CHR[,IDX])
			ms = strchr(ps,cint(y));
			me = (ms==NULL) ? NULL:(ms+1             );
		}

	//+++ Skip Empty Elmt +++//
		if( flag_compact ){
			if( ps==pe ){ break; }		/* ( GAP Target ) */		/* PSPLIT() - Skip Empty	*/
			if( ms!=NULL ){				/* ( Matched !! ) */
				if( ps==ms && pe!=me ){ ps=me; idx--; continue; }	/* PSPLIT() - Skip BOL Gap	*/
				if( ps==ms && pe==me ){ break; }					/* PSPLIT() - Skip EOL Gap	*/
			}
			else						/* ( NoMatch !! ) */
				;;;
		}
	//+++ Proc Array Elmt +++//
		if( z==NULL || (z!=NULL && idx==cint(z)) ){
			if( ms!=NULL )				/* ( Matched !! ) */
				p_str = X_NDUP(ps,ms-ps);
			else						/* ( NoMatch !! ) */
				p_str = X_NDUP(ps,pe-ps);
			if( z==NULL ){ e=di2p_dtab(a,idx); e->type='S'; e->str=p_str; } /*** Make Arry[] ***/
			if( z!=NULL ){                     a->type='S'; a->str=p_str; } /*** Make SubStr ***/
		}

	//+++ Asgn Next +++/
		if( (ps=me)==NULL || (z!=NULL && idx==cint(z)) ){ break; }

	}
// *** Main Loop End *** //

// Return 
	if( a->type=='U' ){ null_dtab(a); } return ans;
}
ctree *i_split (ctree *ctr){ /*** TT-Lang: A = SPLIT (X,Y[,Z]) ***/ return do_split(ctr,FALS); }
ctree *i_psplit(ctree *ctr){ /*** TT-Lang: A = PSPLIT(X,Y[,Z]) ***/ return do_split(ctr,TRUE); }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_scan(ctree *ctr,int flag_compact){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y,*z,*e;	int		cnt;
char	*ps,*pe,*ms,*me,*p_str;
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
regmatch_t	pmatch;						/* /RE/ Substr Address Info Buffer						*/
int			errcode;					/* /RE/ Error Code										*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/* Set Param(s) & Check Type(s) */
	cnt = lcnt(ctr);					/* CNT = ARGC of this Func()							*/
	if( cnt!=2 && cnt!=3 ){ flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=2,epar[2]=3; return NULL; }

	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SP"  ,0);
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"SPID",1);
	switch( cnt ){
		case 2: z = NULL;												break;
		case 3: z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(z,"ID",2);	break;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

	if( isnull(x)||isnull(y) ){ null_dtab(a); return ans; }

/* Do SCAN()!! */
	ps = cstr(x);			ms = NULL;			// STR = "... CCC ... CCCMMMMMCCC ... CCC\0"
	pe = ps+strlen2(ps);	me = NULL;			//            ^PS        ^MS  ^ME        ^PE

// Note: Y specifies element.  But essentially we can always consider FLAG_COMPACT==1.
// Because we can't match GAP element except infinit match, which will cause an error.

// *** Main Loop Start *** //
	for( int idx=0 ; TRUE ; idx++ ){	/* IDX = 0,1,2, ... ( Arry Index || Word Index )		*/

	//+++ Call Regexp +++//
		if( (y->type=='S'||y->type=='P') &&  isreg(y) ){	// SCAN(STR,/RE/[,IDX])
			if( y->ptr2==NULL ){ regcc(y); }				// Compile & Save /RE/
			errcode = regexec(y->ptr2,ps,1,&pmatch,0);		// Try Match
			if( errcode==0 ){								//*** Matched !! ***
				ms = ps+pmatch.rm_so;
				me = ps+pmatch.rm_eo;
				if( pmatch.rm_eo==0 ){ flag_exerr=E_REGINF; last_ct=lptr(ctr,1); return NULL; }	//*** Infinit !! ***
			}
			else{											//*** NoMatch !! ***
				ms = NULL;
				me = NULL;
			}
		}
	//+++ Call Strstr +++//
		if( (y->type=='S'||y->type=='P') && !isreg(y) ){	// SCAN(STR,STR[,IDX])
			ms = strstr(ps,y->str);
			me = (ms==NULL) ? NULL:(ms+strlen2(cstr(y)));
		}
	//+++ Call Strchr +++//
		if( y->type=='I' || y->type=='D' ){ 				// SCAN(STR,CHR[,IDX])
			ms = strchr(ps,cint(y));
			me = (ms==NULL) ? NULL:(ms+1             );
		}

	//+++ Skip Empty Elmt +++//
		if( flag_compact ){ ;;; }
	//+++ Proc Array Elmt +++//
		if( z==NULL || (z!=NULL && idx==cint(z)) ){
			if( ms!=NULL )				/* ( Matched !! ) */
				p_str = X_NDUP(ms,me-ms);
			else						/* ( NoMatch !! ) */
				break;
			if( z==NULL ){ e=di2p_dtab(a,idx); e->type='S'; e->str=p_str; } /*** Make Arry[] ***/
			if( z!=NULL ){                     a->type='S'; a->str=p_str; } /*** Make SubStr ***/
		}

	//+++ Asgn Next +++/
		if( (ps=me)==NULL || (z!=NULL && idx==cint(z)) ){ break; }

	}
// *** Main Loop End *** //

// Return 
	if( a->type=='U' ){ null_dtab(a); } return ans;
}
ctree *i_scan (ctree *ctr){ /*** TT-Lang: A = SCAN (X,Y[,Z]) ***/ return do_scan(ctr,FALS); }
ctree *i_pscan(ctree *ctr){ /*** TT-Lang: A = PSCAN(X,Y[,Z]) ***/ return do_scan(ctr,TRUE); }
