/*** RWLKUP.C ***/						#include	"main.h"

/************************************************************************************************/
// RD_DTAB() searches DTAB record by "NAME" from XX_DTAB Array (ADDR),
// then returns index number or INVA.
/************************************************************************************************/
int rd_dtab(int addr,char *name){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;		int		idx;

/* Set Pointer to XX_DTAB Array */
	if( (p_dtab=mem[addr]) == NULL )
		return(INVA);
/* Search & Return 1/2 - Full Name */
	for( idx=1 ; idx<=p_dtab[0].ival ; idx++ ){				// idx = 1,2,3, ... ,p_dtab[0].ival
		if(( ((p_dtab[idx].attr)&ATTR_IGNR) && strcasecmp(p_dtab[idx].name,name)==0 )
		|| (!((p_dtab[idx].attr)&ATTR_IGNR) && strcmp    (p_dtab[idx].name,name)==0 ))
			return(idx);									/*** Found!! ***/
	}
/* Not Found!! */
	return(INVA);
}

/************************************************************************************************/
// WR_DTAB() installs new DTAB record with "NAME","TYPE","ATTR" and misc "VALUE" into XX_DTAB
// Array (ADDR), then returns index number.  It will alloc & init new XX_DTAB array if not exist.
/************************************************************************************************/
int wr_dtab(int addr,char *name,int type,int attr,...){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;		int		idx;			char	*str;
va_list	ap;										/* Object for VA_START/VA_ARG/VA_END			*/

/* Set Pointer to XX_DTAB Array */
	if( (p_dtab=mem[addr]) == NULL ){			// 1st Call => Alloc & Init
		p_dtab = mem[addr] = X_MALL(sizeof(dtab)*IDS_SIZE);
		p_dtab[0].type = 'I';
		p_dtab[0].name = "(ADMIN) - ## of Valid Items";
		p_dtab[0].ival = 0;
	}
/* Set UnUsed Index & Init DTAB */
	idx = ++(p_dtab[0].ival);					// +++ Count Up +++
	if( IDS_SIZE<=idx ){ dying("Panic!! - {GL|ST|LC}_DTAB is Full!! (Addr=%d/Size=%d)\n",addr,idx); }
	init_dtab(&p_dtab[idx]);
/* Asgn: Name & Type */
	p_dtab[idx].name = X_SDUP(name);
	p_dtab[idx].type = type;
	p_dtab[idx].attr = attr;
/* Asgn: Attr & Data */
	va_start(ap,attr);		/*** [ Start ] ***/
	switch( type ){
		case 'U':										break;
		case 'S':						/* >通常文字列 {X_CSTR|X_HERE}							*/
		case '~':						/* >/RE/文字列 ( '~' は、Flex I/F 時のみ有効 )			*/
			p_dtab[idx].type  = 'S'; str = va_arg(ap,char *);
			p_dtab[idx].attr |= ( type=='S' && chk_evaldol(str,NULL,NULL) ? ATTR_EDOL : 0x00 );
			p_dtab[idx].str	  = X_SDUP(str);
			if( type=='~' ){ regcc(&p_dtab[idx]); }		break;	// Compile /RE/ & Save into PTR2
		case 'I': p_dtab[idx].ival = va_arg(ap,tint  );	break;
		case 'D': p_dtab[idx].dval = va_arg(ap,tdbl  );	break;
		case 'P': p_dtab[idx].ptr  = va_arg(ap,void *);	break;
		case 'X':						/* >システム定義関数									*/
			p_dtab[idx].ptr   = va_arg(ap,void *);				// Pointer to I_FUNC()
			p_dtab[idx].ival  = va_arg(ap,int   );				// ARGC    of I_FUNC()
														break;
		default:
			dying("Panic!! - Illegal DTAB Type [File=%s,Line=%d,Type=\'%c\'(%d)]\n", __FILE__, __LINE__, type, type);
	}
	va_end(ap);				/*** [ End ] ***/

// These DTABs are installed into  GL_DTAB|ST_DTAB|LC_DTAB only.  It's OK for nominal Parse & Exec
// operation. [ -n -i -e ]  But in EvalDol()&Eval(), we also need to install them into DS[] here.

/* ( Also Installs to DS[] - EvalDol()&Eval() Only !! - ) */
	if( flag_imode=='$'||flag_imode=='E' ){ dp++; chk_overflow(); dp--; cpy_dtab(&ds[dp++],&p_dtab[idx]); }
/* Return */
	return(idx);
}

/************************************************************************************************/
// SEEK_ORIGFUNC() reversely seeks FUNC() by Attr and Ptr from GL_DTAB.
// then returns pointer to DTAB or NULL.
/************************************************************************************************/
dtab *seek_origfunc(int attr,void *ptr){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;		int		idx;

/* Skip UnInit FUNC() */
	if( (attr&ATTR_FXID)==0 && ptr==NULL )
		return(NULL);
/* Seek FUNC() */
	p_dtab=mem[GL_DTAB];
	for( idx=1 ; idx<=p_dtab[0].ival ; idx++ ){
		if( (p_dtab[idx].attr)&ATTR_FXCP )		/* Skip Copied Function!! ( Not Original!! )	*/
			continue;
		if( p_dtab[idx].type=='X' && ((p_dtab[idx].attr)&ATTR_FXID)==((attr)&ATTR_FXID) && p_dtab[idx].ptr==ptr )
			return(&p_dtab[idx]);
	}
/* Not Found!! */
	return(NULL);
}

/************************************************************************************************/
// They search & return System Variable(s) by their name from GL_DTAB.	*** SYSTEM USE ONLY!! ***
/************************************************************************************************/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
tdbl SYS_ANGLE(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"SYS_ANGLE" ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx;
	return cdbl(p_dtab);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
tint LTZ_OFFSET(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"LTZ_OFFSET"); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx;
	return cint(p_dtab);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *LTZ(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"LTZ"       ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx;
	return cstr(p_dtab);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *FMT_S2S(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"FMT_S2S"   ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx;
	return X_SDUP(p_dtab->str);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *FMT_I2S(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
char	buf0[BUFSIZ],buf1[BUFSIZ];		/* Buffer for Format String ( Before '%' & After '%' )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"FMT_I2S"   ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx;
//	return X_SDUP(p_dtab->str);
	set_prnfmt(buf0,p_dtab->str, 0 );
	set_prnfmt(buf1,p_dtab->str, 1 );
	return X_SCAT(buf0,buf1);

}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *FMT_D2S(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
char	buf0[BUFSIZ],buf1[BUFSIZ];		/* Buffer for Format String ( Before '%' & After '%' )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"FMT_D2S"   ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx;
//	return X_SDUP(p_dtab->str);
	set_prnfmt(buf0,p_dtab->str, 0 );
	set_prnfmt(buf1,p_dtab->str, 1 );
	return X_SCAT(buf0,buf1);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *FMT_P2S(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"FMT_P2S"   ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx;
	return X_SDUP(p_dtab->str);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *FMT_N2S(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"FMT_N2S"   ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx;
	return X_SDUP(p_dtab->str);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *FMT_SDATE(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"FMT_SDATE" ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx;
	return X_SDUP(p_dtab->str);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *FMT_STIME(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"FMT_STIME" ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx;
	return X_SDUP(p_dtab->str);
}

dtab *PTR2DOLQ(void){					// $?
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"$?"         ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx; return(p_dtab);
}

dtab *PTR2ARGR(void){					// argr
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"argr"       ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx; return(p_dtab);
}

dtab *RAW_SOCKET(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"RAW_SOCKET" ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx; return(p_dtab);
}

dtab *UDP_SOCKET(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"UDP_SOCKET" ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx; return(p_dtab);
}

dtab *TCP_SOCKET(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"TCP_SOCKET" ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx; return(p_dtab);
}

dtab *LaA_SOCKET(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"L&A_SOCKET" ); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx; return(p_dtab);
}

dtab *RAW_TIMEOUT(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"RAW_TIMEOUT"); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx; return(p_dtab);
}

dtab *UDP_TIMEOUT(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"UDP_TIMEOUT"); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx; return(p_dtab);
}

dtab *TCP_TIMEOUT(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*p_dtab;	static int idx=0;	/* !STATIC! DTAB Index Value ( Never Change @ RunTime )	*/
	if( idx==0 ){ idx=rd_dtab(GL_DTAB,"TCP_TIMEOUT"); assert(idx!=INVA); }
	p_dtab=mem[GL_DTAB]; p_dtab+=idx; return(p_dtab);
}
