/*** MAIN.H - "TwinTail_de_AngelMode!!" System Header File ***/

#define	_GNU_SOURCE						// Enable GNU C-Lang Extention

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// Include Standard C-Header File(s) [ALL]
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
#include	<assert.h>					// ANSI-C(=C89)|ISO-C90
#include	<complex.h>					//                      + ISO-C99 (New!!)
#include	<ctype.h>					// ANSI-C(=C89)|ISO-C90
#include	<errno.h>					// ANSI-C(=C89)|ISO-C90
#include	<fenv.h>					//                      + ISO-C99 (New!!)
#include	<float.h>					// ANSI-C(=C89)|ISO-C90
#include	<inttypes.h>				//                      + ISO-C99 (New!!)
#include	<iso646.h>					//                      + ISO-C95
#include	<limits.h>					// ANSI-C(=C89)|ISO-C90
#include	<locale.h>					// ANSI-C(=C89)|ISO-C90
#include	<math.h>					// ANSI-C(=C89)|ISO-C90
#include	<setjmp.h>					// ANSI-C(=C89)|ISO-C90
#include	<signal.h>					// ANSI-C(=C89)|ISO-C90
#include	<stdarg.h>					// ANSI-C(=C89)|ISO-C90
#include	<stdbool.h>					//                      + ISO-C99 (New!!)
#include	<stddef.h>					// ANSI-C(=C89)|ISO-C90
#include	<stdint.h>					//                      + ISO-C99 (New!!)
#include	<stdio.h>					// ANSI-C(=C89)|ISO-C90
#include	<stdlib.h>					// ANSI-C(=C89)|ISO-C90
#include	<string.h>					// ANSI-C(=C89)|ISO-C90
#include	<tgmath.h>					//                      + ISO-C99 (New!!)
#include	<time.h>					// ANSI-C(=C89)|ISO-C90
#include	<wchar.h>					//                      + ISO-C95 [WCHAR]
#include	<wctype.h>					//                      + ISO-C95 [WCHAR]

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// Include Misc C-Header File(s)
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
#include	<fcntl.h>					// POSIX Spec ( Defacto Standard )
#include	<glob.h>					// POSIX Spec ( Defacto Standard )
#include	<libgen.h>					// POSIX Spec ( Defacto Standard )
#include	<regex.h>					// POSIX Spec ( Defacto Standard )
#include	<unistd.h>					// POSIX Spec ( Defacto Standard )
#include	<sys/select.h>				// POSIX Spec ( Defacto Standard )
#include	<sys/socket.h>				// POSIX Spec ( Defacto Standard )
#include	<sys/stat.h>				// POSIX Spec ( Defacto Standard )
#include	<sys/time.h>				// POSIX Spec ( Defacto Standard )
#include	<sys/times.h>				// POSIX Spec ( Defacto Standard )
#include	<sys/types.h>				// POSIX Spec ( Defacto Standard )
#include	<sys/wait.h>				// POSIX Spec ( Defacto Standard )

#include	<netdb.h>					// TCP/IP Networking
#include	<netinet/ip.h>				// TCP/IP Networking
#include	<netinet/ip_icmp.h>			// TCP/IP Networking
#include	<netinet/tcp.h>				// TCP/IP Networking
#include	<netinet/udp.h>				// TCP/IP Networking
#include	<arpa/inet.h>				// TCP/IP Networking

#include	"gc.h"						// BoehmDW-GC
#include	<readline/readline.h>		// GNU ReadLine()
#include	<readline/history.h>		// GNU ReadLine()

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// Define Fundamental Parameter(s)
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
/* TT-Engine ( = Interpreter ) & Logical */
#define	TTdeAM_CMD	"tt"				// TT-Engine Command String ("%s")
#define	TTdeAM_VER	"292"				// TT-Engine Version Number ("%s")
#define	FALS		0
#define	TRUE		1

/* iCPU ( = Vertural CPU ) & iMEM ( = Vertual MEM ) */
#define	IMEM_SIZE	(1024*1)			// Init Size ( RALL()ed )
#define	IDS_SIZE	(1024*4)			// Init Size ( RALL()ed )
#define	IRS_SIZE	(1024*1)			// Init Size ( RALL()ed )
#define	IFT_SIZE	(1024*1)			// Init Size ( RALL()ed )
#define	INVA		(    -1)			// Invalid {Addr|State} [Negative]

#define	GL_DTAB		1					// Abs Addr [ ********* ]
#define	ST_DTAB		0					// Rel Addr [ 0=MP_BASE ]
#define	LC_DTAB		1					// Rel Addr [ 0=MP_BASE ]
#define	FX_UNIT		4					// iMEM/(UsrDef)Func()
#define	FX_TREE		2					// Rel Addr [ 0=MP_BASE ]
#define	FX_INFO		3					// Rel Addr [ 0=MP_BASE ]

/* Variable & Function ( Note: MAX_SAIDX must be <= 0xFFFF because of matrix!! ) */
#define	MAX_SAIDX	(1024*4)			// Max Std.Arry[] Index     ( Valid = 0 - MAX_SAIDX-1 )
#define	MAX_EHIDX	(1024*4)			// Max Ext.Hash[] Index     ( Valid = 0 - MAX_EHIDX-1 )
#define	MAX_SADIM	(   3  )			// Max Sdt.Arry[] Dimension ( Valid = 1 - MAX_SADIM   )

#define	MAX_STMTNL	(1024*1)			// Max STMT Nest Level      ( Valid = 0 - MAX_STMTNL-1 )

#define	ATTR_EDOL	0x010000			// S - Eval "${}"       T/F
#define	ATTR_FPCD	0x020000			// P - FP {:CODE|:DATA} T/F
#define	ATTR_STID	0x040000			// A - Struct.ID        T/F
#define	ATTR_MAID	0x080000			// A - Matrix.ID        T/F
#define	ATTR_IGNR	0x100000			// * - Ignore Case      T/F
#define	ATTR_FXID	0x00FFFF			// Function.Ident Bit Mask ( 16[BIT] )
#define	ATTR_FXCP	0xFF0000			// Function.Copy  Bit Mask ( 08[BIT] )

#define	MAX_PACKET	65535				// Max Frame Size for {TCP|UDP|ICMP}/IP Packet [Byte]
#define	MAX_LISTEN	64					// Max Queue Size for LISTEN(2)

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// Define Diagnostic Parameter(s)
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
/* Debug Control ( Bit OR ) */
#define	DF_CKSYN	0x100				// Check Only!! ( Not Executed!! )
#define	DF_FLEX		0x001				// Dump Flex (1) Information
#define	DF_BISON	0x002				// Dump Bison(1) Information
#define	DF_MEMDP	0x004				// Dump Mem[]    Information
#define	DF_GCLIB	0x008				// Dump GcLib    Information
#define	DF_NETWK	0x010				// Dump Network  Information
#define	DF_SIGNO	0x020				// Dump Signal   Information
#define	DF_CTRDP	0x040				// Dump Ctree    Information

/* Run Time Error */
#define	NullPTR		101					// Detect NULL Pointer			    !! TT-Engine Internal Error !!
#define	NullSYS		102					// Detect System (OS) Error		    !! ???????????????????????? !!

#define	UnDEFD_V	201					// Undefined Variable               # EPAR[] -> N/A
#define	UnDEFD_F	202					// Undefined Function               # EPAR[] -> N/A
#define	NgTYPE_V	203					// Illegal Type for Variable        # EPAR[] -> N/A
#define	NgTYPE_F	204					// Illegal Type for Function        # EPAR[] -> N/A
#define	NgARGCmm	205					// Illegal Argument Count (Min-Max) # EPAR[] -> 0=Pass,1=Min,2=Max       [INVA]
#define	NgARGCnn	206					// Illegal Argument Count (Num&Num) # EPAR[] -> 0=Pass,1=OK1,2=OK2,3=Aux [INVA]
#define	NgARGVAL	207					// Illegal Argument Value           # EPAR[] -> N/A
#define	NgARGCMB	208					// Illegal Argument Combination		# EPAR[] -> N/A

#define	E_SCANER	301					// General Syntax Error @ Scanner Phase
#define	E_PARSER	302					// General Syntax Error @ Parser  Phase
#define	E_REGEXP	303					// /RE/ Syntax Error
#define	E_REGINF	304					// /RE/ Infinit Match
#define	E_ARYIDX	305					// Arry[] & Hash[] Index Error      # EPAR[] -> 0=Type
#define	E_REFIDX	306					// Str [] & Ptr [] Index Error
#define	E_FSCOPE	307					// Func() Scope Error

#define	PRiNARGC	401					// PRINT(): ArgCntr MisMatch        # EPAR[] -> 0=Node,1={'-'|'+'}
#define	PRiNTYPE	402					// PRINT(): ArgType MisMatch        # EPAR[] -> 0=Node,1=Frmt,1=Pass

#define	FileOpen	501					// FileI/O: Open   Error
#define	FileClose	502					// FileI/O: Close  Error
#define	FileRead	503					// FileI/O: Read   Error
#define	FileWrite	504					// FileI/O: Write  Error
#define	FileFlush	505					// FileI/O: Flush  Error
#define	FileGetPos	506					// FileI/O: GetPos Error
#define	FileSetPos	507					// FileI/O: SetPos Error

#define	PipeOpen	551					// PipeI/O: Open   Error

#define	IpAddr		601					// Network: Illegal IP Address
#define	PortNo		602					// Network: Illegal Port Number
#define	ProtoID		603					// Network: Illegal Protocol ID
#define	RawRecv		610					// Network: RAW(ICMP) Recv Error
#define	RawSend		611					// Network: RAW(ICMP) Send Error
#define	UdpRecv		620					// Network: UDP Recv Error
#define	UdpSend		621					// Network: UDP Send Error
#define	LisnAcc		630					// Network: TCP Listen&Accept Error
#define	Connect		631					// Network: TCP Connect       Error
#define	TcpRecv		640					// Network: TCP Recv Error
#define	TcpSend		641					// Network: TCP Send Error

#define	MatxUndef	701					// Illegal Matrix Element - Undef - # EPAR[] -> 0=Row ,1=Col                [INVA]
#define	MatxValue	702					// Illegal Matrix Element - Value - # EPAR[] -> 0=Row ,1=Col                [INVA]
#define	MatxCombi	703					// Illegal Matrix Combination       # EPAR[] -> 0=Row1,1=Col1,2=Row2,3=Col2 [INVA]
#define	MatxAttri	704					// Illegal Matrix Attribution ( is Array )

#define	SortFxRetn	801					// Sort Func() Retn Value Error
#define	SortFxExec	802					// Sort Func() Exec       Error
#define	SortInSort	803					// Sort() In Sort()       Error
#define	SortNoData	803					// Sort() No Data         Error

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// Include User C-Header Files
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
#include	"syntax/bison.tab.h"		/*** Define: Token Symbol & Parser Stack ( by Bison ) ***/
#include	"admin/mdtype.h"			/*** Define: Macro(s)     & DataType(s)               ***/
#include	"admin/extern.h"			/*** Extern: Variable(s)  & Function(s)               ***/
