// -*- C++ -*-
#ifndef _storage_h_included_
#define _storage_h_included_

#include <stdio.h>
#include <vector>
#include "word.h"

#define NR_PAGES 256

class Ident;

class WordSet {
public:
  void add_word(const char *name, Stamp stamp, bool approve,
		const char *idx, const char *word);
  void write_words(FILE *fp);
protected:
  Word *find_word(const char *idx, const char *word);
public:
  std::list <Word *> m_word_array;
  std::list <Sign *> m_sign_array;
};

class Page : public WordSet {
public:
  Page(const char *name, int idx);
  void read();
  void write();
  void dump();

  void print_index(FILE *fp);
private:
  //
  char *m_file_name;
  int m_idx;

  //
};

class Storage {
public:
  Storage(const char *name);
  ~Storage();

  void check();
  void update();
  void dump();
  void update_index();

  void add_word(const char *name, Stamp stamp, bool approve,
		const char *index, const char *word);
private:
  Page *get_page(int idx);

  char *m_dir_name;
  Page *m_pages[NR_PAGES];
};

#endif
