/*
 * Anthyμ饤֥濴
 *
 * Copyright (C) 2000-2002 TABATA Yusuke
 *
 * $Id: dic_main.c,v 1.21 2002/11/09 05:20:04 yusuke Exp $
 */
#include <stdlib.h>

#include <dic.h>
#include <conf.h>
#include <record.h>
#include <alloc.h>
#include <logger.h>

#include "dic_main.h"
#include "dic_personality.h"
#include "dic_ent.h"

/**/
static int dic_is_init;

/*  */
/* personalityǶͭ뼭 */
static struct file_dic *master_dic_file;
static struct mem_dic *anonymous_dic_cache;
/*ƥѡʥƥȤμ*/
struct mem_dic *anthy_current_personal_dic_cache;/*å*/
struct record_stat *anthy_current_record;
static struct mem_dic *private_dic;

/* ƱɤߤФ롢ñ줫ե饰׻ */
static void
calc_seq_flags(struct seq_ent *se)
{
  int i;

  /* Ƥμ񥨥ȥФ */
  for (i = 0; i < se->nr_dic_ents; i++) {
    int p;
    p = anthy_wtype_get_pos(se->dic_ents[i]->type);
    switch (p) {
    case POS_NOUN:
      {
	int c;
	c = anthy_wtype_get_cos(se->dic_ents[i]->type);
	if (c == COS_NN) {
	  se->flags |= NF_NUM;
	}else if (c == COS_JN) {
	  int s;
	  s = anthy_wtype_get_scos(se->dic_ents[i]->type);
	  if (s == SCOS_FSTNAME) {
	    se->flags |= NF_FSTNAME;
	  } else if (s == SCOS_FAMNAME) {
	    se->flags |= NF_FAMNAME;
	  } else {
	    se->flags |= NF_UNSPECNAME;
	  }
	}
      }
      break;
    case POS_PRE:
    case POS_SUC:
      {
	int c;
	c = anthy_wtype_get_cos(se->dic_ents[i]->type);
	if (c == COS_JN) {
	  se->flags |= SF_JN;
	}else if (c == COS_NN) {
	  se->flags |= SF_NUM;
	}
      }
      break;
    }
  }
}

/*
 * Ŀͼñɤ߹
 */
static void
add_word_to_private_dic(struct mem_dic * dd)
{
  int nr, i;
  xstr *word,*yomi,*tmp;
  wtype_t wt;
  char *cstr;
  int freq;
  struct seq_ent *se;

  nr = anthy_get_nr_values();
  if (nr < 3) {
    return ;
  }
  yomi = anthy_get_index_xstr();
  for (i = 0; i + 2 < nr; i += 3) {
    const char *wt_name;
    word = anthy_get_nth_xstr(i);/* ñ */
    tmp = anthy_get_nth_xstr(i+1);/* ʻ̾ */
    cstr = anthy_xstr_to_cstr(tmp);
    wt_name = anthy_type_to_wtype(cstr, &wt);
    free(cstr);
    freq = anthy_get_nth_value(i+2);/*  */

    se = anthy_mem_dic_alloc_seq_ent_by_xstr(dd, yomi);
    /* Ŀͼʻ줬anthyˤȤä̤Τʤwt_nameNULL*/
    if (wt_name) {
      anthy_mem_dic_push_back_dic_ent(se, word, wt, wt_name, freq, 0);
    }
  }
}

/** Ŀͼɤ */
static void
init_private_dic()
{
  if (private_dic) {
    anthy_release_mem_dic(private_dic);
  }
  private_dic = anthy_create_mem_dic();
  if (anthy_select_section("PRIVATEDIC", 0) == -1) {
    return ;
  }
  if (anthy_select_first_column() == -1) {
    return ;
  }
  do {
    add_word_to_private_dic(private_dic);
  } while (anthy_select_next_column() != -1);
}

int
anthy_init_dic_cache(void)
{
  const char *fn;
  fn = anthy_conf_get_str("DIC_FILE");
  if (!fn) {
    anthy_log(0, "dic file not specified.\n");
    return -1;
  }
  master_dic_file = anthy_create_file_dic(fn);
  if (!master_dic_file) {
    anthy_log(0, "Failed to create file dic.\n");
    return -1;
  }
  anonymous_dic_cache = anthy_create_mem_dic();
  return 0;
}

static struct seq_ent *
cache_get_seq_ent_to_mem_dic(struct mem_dic *dd, xstr *xs)
{
  struct seq_ent *se = anthy_mem_dic_find_seq_ent_by_xstr(dd, xs);
  if (se) {
    return se;
  }
  se = anthy_mem_dic_alloc_seq_ent_by_xstr(dd, xs);

  /* file_dicΥեå */
  anthy_file_dic_fill_seq_ent_by_xstr(master_dic_file, xs, se);

  /*٤Ƥdic_entФflag׻*/
  calc_seq_flags(se);

  return se;
}

struct seq_ent *
anthy_cache_get_seq_ent(xstr *xs)
{
  struct seq_ent *s, *t;

  if (!anthy_get_current_session_mask()) {
    /*
     * ѡʥƥꤵƤʤΤǡ
     * Х륭å˼Ф
     */
    return cache_get_seq_ent_to_mem_dic(anonymous_dic_cache, xs);
  }

  /* åˤФ֤ */
  s = anthy_mem_dic_find_seq_ent_by_xstr(anthy_current_personal_dic_cache, xs);
  if (s) {
    return s;
  }

  /*
   * ʬ(ȥѡʥƥ)Υå̵Τ
   * Х륭å򸫤
   */
  t = anthy_mem_dic_find_seq_ent_by_xstr(anonymous_dic_cache, xs);
  if (t) {
    /* äΤƤ򥳥ԡƤ */
    int i;
    s = anthy_mem_dic_alloc_seq_ent_by_xstr(anthy_current_personal_dic_cache, xs);
    s->node_type = t->node_type;
    /* tƤs˥ԡ */
    for (i = 0; i < t->nr_dic_ents; i++) {
      anthy_mem_dic_push_back_dic_ent(s,
				      &t->dic_ents[i]->str,
				      t->dic_ents[i]->type,
				      t->dic_ents[i]->wt_name,
				      t->dic_ents[i]->freq, 0);
    }
    calc_seq_flags(s);
  }else{
    /* ʤäΤǼʬѤ˥쥯Ȥ˼Ф */
    s = cache_get_seq_ent_to_mem_dic(anthy_current_personal_dic_cache, xs);
  }

  /* Ŀͼ񤫤Υեå */
  t = anthy_mem_dic_find_seq_ent_by_xstr(private_dic, xs);
  if (t) {
    int i;
    /* Ŀͼˤ⤢ä */
    for (i = 0; i < t->nr_dic_ents; i++) {
      anthy_mem_dic_push_back_dic_ent(s,
				      &t->dic_ents[i]->str,
				      t->dic_ents[i]->type,
				      t->dic_ents[i]->wt_name,
				      t->dic_ents[i]->freq, 0);
    }
  }

  if (s->nr_dic_ents == 0) {
    /* ̵ʥȥΤcache */
    anthy_mem_dic_release_seq_ent(anthy_current_personal_dic_cache, xs);
    return 0;
  }
  
  return s;
}

int anthy_dic_get_related_words(int id, struct related_words *words)
{
  return anthy_file_dic_get_related_words(master_dic_file, id,
					  words);
}

seq_ent_t
anthy_get_seq_ent_from_xstr(xstr *x)
{
  struct seq_ent *s;
  s = anthy_cache_get_seq_ent(x);
  if (!s || s->nr_dic_ents==0) {
    return anthy_get_ext_seq_ent_from_xstr(x);
  }
  return s;
}

/*
 * seq_entμ
 ************************
 * seq_entγƼμ
 */
int
anthy_get_seq_flag(seq_ent_t se)
{
  if (!se) {
    return 0;
  }

  return se->flags;
}

int
anthy_get_nr_dic_ents(seq_ent_t se, xstr *xs)
{
  struct seq_ent *s = se;
  if (!s) {
    return 0;
  }
  return s->nr_dic_ents + anthy_get_nr_dic_ents_of_ext_ent(se, xs);
}

int
anthy_get_nth_dic_ent_str(seq_ent_t se, xstr *o,
			  int n, xstr *x)
{
  struct seq_ent *s = se;
  if (!s) {
    return -1;
  }
  if (n >= s->nr_dic_ents) {
    return anthy_get_nth_dic_ent_str_of_ext_ent(se, o, n - s->nr_dic_ents, x);
  }
  x->len = s->dic_ents[n]->str.len;
  x->str = anthy_xstr_dup_str(&s->dic_ents[n]->str);
  return 0;
}

int
anthy_get_nth_dic_ent_freq(seq_ent_t se, int n)
{
  struct seq_ent *s = se;
  if (!s || s->nr_dic_ents <= n) {
    return 0;
  }
  return s->dic_ents[n]->freq;
}

int
anthy_get_nth_dic_ent_wtype(seq_ent_t se, xstr *xs,
			    int n, wtype_t *w)
{
  struct seq_ent *s = se;
  if (!s) {
    *w = anthy_wt_none;
    return -1;
  }
  if (s->nr_dic_ents <= n) {
    int r;
    r = anthy_get_nth_dic_ent_wtype_of_ext_ent(xs, n - s->nr_dic_ents, w);
    if ( r == -1) {
      *w = anthy_wt_none;
    }
    return r;
  }
  *w =  s->dic_ents[n]->type;
  return 0;
}

int
anthy_get_nth_dic_ent_id(seq_ent_t se, int nth)
{
  if (!se) {
    return 0;
  }
  if (nth < se->nr_dic_ents) {
    return se->dic_ents[nth]->id;
  }
  return 0;
}

int
anthy_get_seq_ent_pos(seq_ent_t se, int pos)
{
  int i, v=0;
  struct seq_ent *s = se;
  if (!s) {
    return 0;
  }
  if (s->nr_dic_ents == 0) {
    return anthy_get_ext_seq_ent_pos(se, pos);
  }
  for (i = 0; i < s->nr_dic_ents; i++) {
    if (anthy_wtype_get_pos(s->dic_ents[i]->type) == pos) {
      v += s->dic_ents[i]->freq;
      if (v == 0) {
	v = 1;
      }
    }
  }
  return v;
}

int
anthy_get_seq_ent_ct(seq_ent_t se, int pos, int ct)
{
  int i, v=0;
  struct seq_ent *s = se;
  if (!s) {
    return 0;
  }
  if (s->nr_dic_ents == 0) {
    return anthy_get_ext_seq_ent_ct(s, pos, ct);
  }
  for (i = 0; i < s->nr_dic_ents; i++) {
    if (anthy_wtype_get_pos(s->dic_ents[i]->type)== pos &&
	anthy_wtype_get_ct(s->dic_ents[i]->type)==ct) {
      v += s->dic_ents[i]->freq;
      if (v == 0) {
	v = 1;
      }
    }
  }
  return v;
}

int
anthy_get_seq_ent_wtype_freq(seq_ent_t se, wtype_t wt)
{
  int i,f;
  struct seq_ent *s = se;
  if (!s) {
    return 0;
  }
  if (s->nr_dic_ents == 0) {
    return anthy_get_ext_seq_ent_wtype(se, wt);
  }
  f = 0;
  for (i = 0; i < s->nr_dic_ents; i++) {
    if (anthy_wtypecmp(wt, s->dic_ents[i]->type)) {
      if (f < s->dic_ents[i]->freq) {
	f = s->dic_ents[i]->freq;
      }
    }
  }
  return f;
}

int
anthy_get_seq_ent_indep(seq_ent_t se)
{
  int i;
  struct seq_ent *s = se;
  if (!s) {
    return 0;
  }
  if (s->nr_dic_ents == 0) {
    return anthy_get_ext_seq_ent_indep(s);
  }
  for (i = 0; i < s->nr_dic_ents; i++) {
    if (anthy_wtype_get_indep(s->dic_ents[i]->type)) {
      return 1;
    }
  }
  return 0;
}
/*
 * 񥵥֥ƥ
 */
int
anthy_init_dic(void)
{
  if (dic_is_init) {
    return 0;
  }
  anthy_do_conf_init();

  anthy_init_wtypes();
  anthy_init_ext_ent();
  anthy_init_mem_dic();
  anthy_init_file_dic();
  anthy_init_use_dic();
  anthy_init_record();
  anthy_init_xchar_tab();
  anthy_init_xstr();

  if (anthy_init_dic_cache() == -1) {
    anthy_log(0, "Failed to init dic cache.\n");
    return -1;
  }
  dic_is_init = 1;
  return 0;
}

void
anthy_quit_dic(void)
{
  if (anthy_current_record) {
    anthy_release_record(anthy_current_record);
  }
  if (anthy_current_personal_dic_cache) {
    anthy_release_mem_dic(anthy_current_personal_dic_cache);
  }
  if (private_dic) {
    anthy_release_mem_dic(private_dic);
    private_dic = 0;
  }
  anthy_current_record = 0;
  anthy_quit_use_dic();
  anthy_quit_mem_dic();
  anthy_quit_allocator();
  anthy_conf_free();
  anthy_quit_xstr();
  dic_is_init = 0;
}

dic_session_t
anthy_dic_create_session(void)
{
  return anthy_create_session();
}

void
anthy_dic_activate_session(dic_session_t d)
{
  anthy_activate_session(d);
}

void
anthy_dic_release_session(dic_session_t d)
{
  anthy_release_session(d);
  anthy_shrink_mem_dic(anthy_current_personal_dic_cache);
}

void
anthy_dic_set_personality(const char *id)
{
  /*
   * 
   * 񥭥åιۤˤե뤬ɬ
   */
  anthy_current_record = anthy_create_record(id);
  anthy_current_personal_dic_cache = anthy_create_mem_dic();
  init_private_dic();
}
