/*
 * "123" "ABC" Τ褦ʼˤΤäƤʤ
 * ȥФ礻ξƤθ򤳤
 *
 * $Id: ext_ent.c,v 1.11 2002/05/13 10:53:57 yusuke Exp $
 *
 */

#include "dic_main.h"
#include "dic_ent.h"
#include "xchar.h"

/* ext node */
static struct seq_ent unkseq_ent_node;/*̤ʸ󤿤ȤбʸȤ*/
static struct seq_ent num_ent_node;/*ʤ*/
static struct seq_ent sep_ent_node;/*ѥ졼ʤɡ*/
/* extΡɤwtype*/
static wtype_t wt_num;

static xchar narrow_wide_tab[]= {WIDE_0, WIDE_1, WIDE_2, WIDE_3, WIDE_4,
				 WIDE_5, WIDE_6, WIDE_7, WIDE_8, WIDE_9};
static int kj_num_tab[]={KJ_0, KJ_1, KJ_2, KJ_3, KJ_4,
			 KJ_5, KJ_6, KJ_7, KJ_8, KJ_9};

static void
init_ext_nodes(void)
{
  unkseq_ent_node.node_type = ST_UNKSEQ|ST_WORD;
  unkseq_ent_node.nr_dic_ents = 0;
  unkseq_ent_node.flags = F_NONE;
  num_ent_node.node_type = ST_WORD;
  num_ent_node.nr_dic_ents = 0;
  num_ent_node.flags = NF_NUM;
  sep_ent_node.node_type = ST_WORD|ST_SEP;
  sep_ent_node.nr_dic_ents = 0;
  sep_ent_node.flags = F_NONE;
}

/* ȾѤοѤο */
static xchar
narrow_num_to_wide_num(xchar xc)
{
  if (xc > '9' || xc < '0') {
    return WIDE_0;
  }
  return narrow_wide_tab[(int)(xc - '0')];
}

/* ѤοȾѤο */
static xchar
wide_num_to_narrow_num(xchar xc)
{
  int i;
  for (i = 0; i < 10; i++) {
    if (xc == narrow_wide_tab[i]) {
      return i+'0';
    }
  }
  return '0';
}
/*
 * Ѵ
 */
static xchar
get_kj_num(int n)
{
  if (n > 9 || n < 1) {
    return KJ_10;
  }
  return kj_num_tab[n];
}

/*
 * 4ʬʸȤƤ
 */
static void
compose_num_component(xstr *xs, int num)
{
  int n[4],i;
  int a[4] = { 0 , KJ_10, KJ_100, KJ_1000};
  for (i = 0; i < 4; i++) {
    n[i] = num-(num/10)*10;
    num /= 10;
  }
  /* 10,100,1000ΰ */
  for (i = 3; i > 0; i--) {
    if ( n[i] > 0) {
      if (n[i] > 1) {
	anthy_xstrappend(xs, get_kj_num(n[i]));
      }
      anthy_xstrappend(xs, a[i]);
    }
  }
  /* 1ΰ */
  if (n[0]) {
    anthy_xstrappend(xs, get_kj_num(n[0]));
  }
}

/* ʸ */
static void
gen_kanji_num(int num, xstr *dest)
{
  int i;
  int n[10];
  for (i = 0; i < 10; i ++) {
    n[i] = num-(num/10000)*10000;
    num = num/10000;
  }
  dest->len = 0;
  dest->str = 0;
  if (n[1]) {
    compose_num_component(dest, n[1]);
    anthy_xstrappend(dest, KJ_10000);
  }
  compose_num_component(dest, n[0]);
}

/*
 * ĤιΥȥ꡼뤫
 */
int
anthy_get_nr_dic_ents_of_ext_ent(seq_ent_t se, xstr *xs)
{
  if (se == &unkseq_ent_node) {
    return 1;
  }
  if (anthy_get_xstr_type(xs) & (XCT_NUM|XCT_WIDENUM)) {
    int num = anthy_xstrtoi(xs);
    if (num > 0 && num < 100000000) {
      /* ӥ(Τޤ)Ⱦؤ */
      return 3;
    }
    /* ӥ(Τޤ)Ⱦؤ */
    return 2;
  }
  return 0;
}

/* ʸȾѤ򴹤 */
static void
toggle_wide_narrow(xstr *dest, xstr *src)
{
  int f, i;
  dest->len = src->len;
  dest->str = anthy_xstr_dup_str(src);
  f = anthy_get_xstr_type(src) & XCT_WIDENUM;
  for (i = 0; i < dest->len; i++) {
    if (f) {
      dest->str[i] = wide_num_to_narrow_num(src->str[i]);
    } else {
      dest->str[i] = narrow_num_to_wide_num(src->str[i]);
    }
  }
}

/*
 * nthĤθФ
 */
int
anthy_get_nth_dic_ent_str_of_ext_ent(seq_ent_t se, xstr *xs,
				     int nth, xstr *dest)
{
  if (nth == 0) {
    /* Τޤ */
    dest->len = xs->len;
    dest->str = anthy_xstr_dup_str(xs);
    return 0;
  }
  if (anthy_get_xstr_type(xs) & (XCT_NUM|XCT_WIDENUM)) {
    int num = anthy_xstrtoi(xs);
    /* ӥȾؤ */
    switch(nth) {
    case 1:
      /* ȾѤΥȥ */
      toggle_wide_narrow(dest, xs);
      return 0;
    case 2:
      gen_kanji_num(num, dest);
      return 0;
    default:
      break;
    }
    if (se == &unkseq_ent_node) {
      switch(nth) {
      case 1:
	/* ѡȾѤΥȥ */
	return 0;
      }
    }
    return -1;
  }
  return 0;
}

int
anthy_get_ext_seq_ent_indep(struct seq_ent *se)
{
  if (se == &num_ent_node || se == &unkseq_ent_node) {
    return 1;
  }
  return 0;
}

int
anthy_get_ext_seq_ent_ct(struct seq_ent *se, int pos, int ct)
{
  if (anthy_get_ext_seq_ent_pos(se, pos) && ct == CT_NONE) {
    return 10;
  }
  return 0;
}

int
anthy_get_ext_seq_ent_pos(struct seq_ent *se, int pos)
{
  if (se == &num_ent_node && pos == POS_NOUN) {
    return 10;
  }
  if ((se->node_type & ST_UNKSEQ) && pos == POS_NOUN) {
    return 10;
  }
  return 0;
}

/*
 * ˤΤäƤʤ󥹤
 */
seq_ent_t
anthy_get_ext_seq_ent_from_xstr(xstr *x)
{
  int t = anthy_get_xstr_type(x);
  if (t & (XCT_NUM | XCT_WIDENUM)) {
    return &num_ent_node;
  }
  /* ѿʤunkseq */
  if (t & XCT_ASCII) {
    return &unkseq_ent_node;
  }
  if (x->len == 1) {
    /* ˤΤäƤʤ1ʸʤ饻ѥ졼 */
    return &sep_ent_node;
  }
  return 0;
}

int
anthy_get_nth_dic_ent_wtype_of_ext_ent(xstr *xs, int nth,
				       wtype_t *wt)
{
  (void)nth;
  if (anthy_get_xstr_type(xs) & XCT_NUM) {
    *wt = wt_num;
    return 0;
  }
  return -1;
}

int
anthy_get_ext_seq_ent_wtype(struct seq_ent *se, wtype_t w)
{
  (void)se;
  if (anthy_wtype_get_pos(w) == POS_NOUN) {
    return 10;
  }
  return 0;
}

void
anthy_init_ext_ent(void)
{
  init_ext_nodes();
  anthy_name_to_wtype("", &wt_num);
}
