/*
 * ʸ(xchar)Υפʤɤ򰷤
 *
 * Copyright (C) 2001-2002 TABATA Yusuke
 */
#include <xstr.h>

#include "dic_main.h"
#include "xchar.h"

static struct xchar_ent{
  xchar xc;
  int type;
  struct xchar_ent *next;/* hash chain */
} xchar_tab[] =
{
  {28, XCT_OPEN, 0}, /* ( */
  {133, XCT_OPEN, 0}, /* [ */
  {0xa1ca, XCT_OPEN, 0}, /* ʡ*/
  {29, XCT_CLOSE, 0}, /* ) */
  {135, XCT_CLOSE, 0}, /* ] */
  {0xa1c9, XCT_CLOSE, 0}, /*  */
  {0xa1cb, XCT_CLOSE, 0}, /*  */
  {0xa4c8, XCT_DEP, 0},/*  */
  {0xa4cf, XCT_DEP, 0},/*  */
  {0xa4ce, XCT_DEP, 0},/*  */
  {0xa4cb, XCT_DEP, 0},/*  */
  {0xa4ac, XCT_DEP, 0},/*  */
  {0xa4f2, XCT_DEP, 0},/*  */
  {WIDE_0, XCT_WIDENUM, 0},
  {WIDE_1, XCT_WIDENUM, 0},
  {WIDE_2, XCT_WIDENUM, 0},
  {WIDE_3, XCT_WIDENUM, 0},
  {WIDE_4, XCT_WIDENUM, 0},
  {WIDE_5, XCT_WIDENUM, 0},
  {WIDE_6, XCT_WIDENUM, 0},
  {WIDE_7, XCT_WIDENUM, 0},
  {WIDE_8, XCT_WIDENUM, 0},
  {WIDE_9, XCT_WIDENUM, 0},
  {HK_DDOT, XCT_PART, 0},
  {HK_XYA, XCT_PART, 0},
  {HK_XYU, XCT_PART, 0},
  {HK_XYO, XCT_PART, 0},
  {HK_TT, XCT_PART, 0},
  {0, 0, 0},
};

static int
find_xchar_type(xchar xc)
{
  struct xchar_ent *xe = xchar_tab;
  for (; xe->xc; xe++) {
    if (xe->xc == xc) {
      return xe->type;
    }
  }
  return XCT_NONE;
}

static int
is_hira(xchar xc)
{
  if ((xc & 0xff00) == 0xa400) {
    return 1;
  }
  if (xc == HK_DDOT) {
    return 1;
  }
  if (xc == HK_BAR) {
    return 1;
  }
  return 0;
}

int
anthy_get_xchar_type(xchar xc)
{
  int t = find_xchar_type(xc);
  if (xc > 47 && xc < 58) {
    t |= XCT_NUM;
  }
  if (xc < 128) {
    t |= XCT_ASCII;
  }
  if (is_hira(xc)) {
    t |= XCT_HIRA;
  }
  return t;
}

int
anthy_get_xstr_type(xstr *xs)
{
  int i, t = XCT_ALL;
  for (i = 0; i < xs->len; i++) {
    t &= anthy_get_xchar_type(xs->str[i]);
  }
  return t;
}

int
anthy_xchar_to_num(xchar xc)
{
  switch (xc) {
  case WIDE_0:return 0;
  case WIDE_1:return 1;
  case WIDE_2:return 2;
  case WIDE_3:return 3;
  case WIDE_4:return 4;
  case WIDE_5:return 5;
  case WIDE_6:return 6;
  case WIDE_7:return 7;
  case WIDE_8:return 8;
  case WIDE_9:return 9;
  }
  if (xc >= '0' && xc <= '9') {
    return xc - (int)'0';
  }
  return -1;
}

void
anthy_init_xchar_tab(void)
{
}
