/*
 * (ߥå)ν򤹤롣
 * ƼγؽƤӽФ
 *
 * anthy_proc_commit() ƤФ
 */
#include <stdlib.h>

#include <ordering.h>
#include <record.h>
#include "splitter.h"
#include "segment.h"
#include "sorter.h"

#define MAX_OCHAIRE_ENTRY_COUNT 100

/* 򴹤줿õ */
static void
learn_swapped_candidates(struct segment_list *sl)
{
  int i;
  struct seg_ent *seg;
  for (i = 0; i < sl->nr_segments; i++) {
    seg = anthy_get_nth_segment(sl, i);
    if (seg->commit > 0) {
      anthy_swap_cand_ent(seg->cands[0],
			  seg->cands[seg->commit]);
    }
  }
  anthy_cand_swap_ageup();
}

/* ĹѤäʸФ */
static void
learn_resized_segment(struct segment_list *sl,
		      struct splitter_context *sc)
{
  int i;
  struct seg_info **info
    = alloca(sizeof(struct seg_info*) * sl->nr_segments);
  int *l 
    = alloca(sizeof(int) * sl->nr_segments);

  for (i = 0; i < sl->nr_segments; i++) {
    struct seg_ent *s = anthy_get_nth_segment(sl, i);
    info[i] = s->cands[s->commit]->si;
    l[i] = s->cands[s->commit]->str.len;
  }

  anthy_commit_border(sc, sl->nr_segments, info, l);
}

/* recordˤؽη̤񤭹 */
static void
commit_ochaire(struct seg_ent *seg, int count, xstr* xs)
{
  int i;
  if (anthy_select_column(xs, 1)) {
    return ;
  }
  anthy_set_nth_value(0, count);
  for (i = 0; i < count; i++, seg = seg->next) {
    anthy_set_nth_value(i * 2 + 1, seg->len);
    anthy_set_nth_xstr(i * 2 + 2, &seg->cands[seg->commit]->str);
  }
}

/* ؽԤ */
static void
learn_ochaire(struct segment_list *sl)
{
  int i;
  int count;

  if (anthy_select_section("OCHAIRE", 1)) {
    return ;
  }

  /* ؽΥͥƥ֤ʥȥä */
  for (i = 0; i < sl->nr_segments; i++) {
    /* ʬФ */
    struct seg_ent *cover = anthy_get_nth_segment(sl, i);
    xstr xs;
    /* 2ʸʾʬʸФ */
    for (xs = cover->str; xs.len >= 2; xs.len--, xs.str++) {
      xstr xs1;
      for (xs1 = xs; xs1.len >= 2; xs1.len--) {
	/*  */
	if (anthy_select_column(&xs1, 0) == 0) {
	  anthy_release_column();
	}
      }
    }
  }

  /* ؽ򤹤 */
  for (count = 3; count <= sl->nr_segments; count++) {
    /* 3ʸʾĹʸФ */

    for (i = 0; i <= sl->nr_segments - count; i++) {
      struct seg_ent *head = anthy_get_nth_segment(sl, i);
      struct seg_ent *s;
      xstr xs;
      int j;
      xs = head->str;
      for (j = 1, s = head->next; j < count; j++, s = s->next)
	xs.len += s->str.len;
      commit_ochaire(head, count, &xs);
    }
  }
  if (anthy_select_section("OCHAIRE", 1)) {
    return ;
  }
  anthy_truncate_section(MAX_OCHAIRE_ENTRY_COUNT);
}

static int
check_segment_relation(struct seg_ent *cur, struct seg_ent *target)
{
  /* Ƭθǳꤵ줿Τǡؽʤ */
  if (cur->commit == 0) {
    return 0;
  }
  /* ñʷʸᤷؽʤ */
  if (cur->cands[0]->nr_words != 1 ||
      cur->cands[cur->commit]->nr_words != 1 ||
      target->cands[target->commit]->nr_words != 1) {
    return 0;
  }
  /* ꤵ줿ʸʻȡǽ˽Фʻ줬ƱǤ뤳Ȥǧ */
  if (anthy_wtype_get_pos(cur->cands[0]->elm[0].wt) !=
      anthy_wtype_get_pos(cur->cands[cur->commit]->elm[0].wt)) {
    return 0;
  }
  if (cur->cands[cur->commit]->elm[0].id == -1 ||
      target->cands[target->commit]->elm[0].id == -1) {
    return 0;
  }
  /* ФϿ򤹤 */
  anthy_dic_register_relation(target->cands[target->commit]->elm[0].id,
			      cur->cands[cur->commit]->elm[0].id);
  return 1;
			      
}

static void
learn_word_relation(struct segment_list *sl)
{
  int i, j;
  int nr_learned = 0;
  for (i = 0; i < sl->nr_segments; i++) {
    struct seg_ent *cur = anthy_get_nth_segment(sl, i);
    for (j = i - 2; j < i + 2 && j < sl->nr_segments; j++) {
      struct seg_ent *target;
      if (i == j || j < 0) {
	continue;
      }
      target = anthy_get_nth_segment(sl, j);
      /* iܤjܤʸθδطؽǤ뤫å */
      nr_learned += check_segment_relation(cur, target);
    }
  }
  if (nr_learned) {
    anthy_dic_commit_relation();
  }
}

void
anthy_proc_commit(struct segment_list *sl,
		  struct splitter_context *info)
{
  /* ƼγؽԤ */
  learn_swapped_candidates(sl);
  learn_resized_segment(sl, info);
  learn_ochaire(sl);
  learn_word_relation(sl);
}
