/*
 * ʸδط
 * Copyright (C) 2002-2003 TABATA Yusuke
 */

#include <stdlib.h>

#include <segclass.h>
#include <segment.h>
#include <ordering.h>
#include <dic.h>
#include "sorter.h"

static void
reorder_candidate(struct related_words *words, struct seg_ent *seg)
{
  int i, pos;
  if (seg->cands[0]->nr_words != 1) {
    return ;
  }
  pos = anthy_wtype_get_pos(seg->cands[0]->elm[0].wt);

  for (i = 0; i < seg->nr_cands; i++) {
    int word_id, j;
    if (seg->cands[i]->nr_words != 1) {
      continue;
    }
    word_id = seg->cands[i]->elm[0].id;
    for (j = 0; j < words->nr_id; j++) {
      if (words->id[j] == word_id &&
	  seg->cands[j]->nr_words == 1 &&
	  anthy_wtype_get_pos(seg->cands[i]->elm[0].wt) == pos) {
	seg->cands[i]->flag |= CEF_USEDICT;
	seg->cands[i]->score *= 10;
      }
    }
  }
}

void
anthy_reorder_candidates_by_relation(struct segment_list *sl, int nth)
{
  int i;
  for (i = nth; i < sl->nr_segments; i++) {
    int j;
    struct seg_ent *cur_seg;
    struct related_words words;
    int word_id;
    cur_seg = anthy_get_nth_segment(sl, i);
    if (cur_seg->cands[0]->nr_words != 1) {
      continue;
    }
    word_id = cur_seg->cands[0]->elm[0].id;
    if (word_id == -1) {
      continue;
    }
    anthy_dic_get_related_words(word_id, &words);
    for (j = i - 2; j < i + 2 && j < sl->nr_segments; j++) {
      struct seg_ent *target_seg;
      if (j < 0 || j == i) {
	continue;
      }
      /* iܤʸjܤʸФ */
      target_seg = anthy_get_nth_segment(sl, j);
      reorder_candidate(&words, target_seg);
    }
  }
}

void
anthy_init_ordering_context(struct segment_list *sl,
			    struct ordering_context_wrapper *cw)
{
  (void)sl;
  (void)cw;
}

void
anthy_release_ordering_context(struct segment_list *sl,
			       struct ordering_context_wrapper *cw)
{
  (void)sl;
  (void)cw;
}
