/* ʸᶭθФ˻Ȥǡ */
#ifndef _wordborder_h_included_
#define _wordborder_h_included_


#include <dic.h>
#include <alloc.h>


struct splitter_context;
struct seg_info;

/* Υåξ */
enum constraint_stat {
  unchecked, ok, ng
};


/*
 * word_list: ʸ
 * Ƭ졢Ω졢졢°ޤ
 */
struct word_list {
  /**/
  int from, len; /* ʸ */
  int score;/*  */
  enum constraint_stat can_use; /* ȶ˸٤äƤʤ */
  struct word_list *next;
  /**/
  int tail_len; /* ѸĹ */
  int dep_len; /* °Ĺ */
  int core_from, core_len; /* Ω */
  int prefix_len, postfix_len; /* ƬĹ */
  wtype_t core_wt, prefix_wt, postfix_wt;
  /* ɾΤι¤ */
  int freq; /* Ω */
  int indep_ratio; /* ΩˤΥΨ */
  int node_id; /* °쥰դθϤnodeid*/
  int conn_ratio; /* °³Υ (ʬ256) */
  int suffix_affinity;/* ƬΥ */
  seq_ent_t core_seq; /* Ωʬ */
  /**/
  char *core_wt_name; /* word_listѤ롼̾ */
};


/* ȤꤢŬ䤷Ƥߤ꤬Фʬह */
enum metaword_type{
  /* ߡ : seginfoʤ */
  MW_DUMMY,
  /* wordlist0 or Ĵޤ */
  MW_SINGLE,
  /* ̤metawordĤޤ: metaword +  ʤ :seginfomw1 */
  MW_WRAP,
  /* Ļ̾Υڥ */
  MW_NAMEPAIR,
  /* ưϢѷ + ƻ */
  MW_V_RENYOU_A,
  /* ưϢѷ + ̾ */
  MW_V_RENYOU_T,
  /*  */
  MW_NUM_XX,
  MW_OCHAIRE,
  MW_OCHAIRE_LEAF
};


/*
 * meta_word: θоݤȤʤ
 * ñword_listޤΤ¾ˤĤμब롥
 * 
 */
struct meta_word {
  int from, len;
  int score;
  enum constraint_stat can_use; /* ȶ˸٤äƤʤ */
  enum metaword_type type;
  struct word_list *wl;
  struct meta_word *mw1, *mw2;
  struct meta_word *parent;
  struct seg_info *si;
  xstr* cand_hint;

  /* listΥ */
  struct meta_word *next;
  struct meta_word *same_extent;
};

/*
 * ʸΤϰϤؤ
 */
struct extent {
  /* ʸο̤ΤӤ˺ɾơ */
  int score;
  /* ϰ */
  int from, len;
  /**/
  int is_dummy_char;
  /* üãƤ뤫 */
  int is_right_end;
  /* meta_wordΥꥹ */
  struct meta_word *mw;
  /**/
  struct meta_word *best;
};

/*
 * ʸΤɽ
 * Ϥޤextent, meta_word, word_listΥåȤ
 */
struct char_node {
  int max_len;
  struct extent **ex;
  struct meta_word *mw;
  struct word_list *wl;
};

/*
 * ƥμΩʤɤξ󡢺ǽѴܥ򲡤Ȥ
 * ۤ
 */
struct word_split_info_cache {
  struct char_node *cnode;

  /* å幽˻Ȥ */
  /* õΤ˻Ȥ */
  int *seq_len;/* ϤޤĹñĹ */
  /* ƬõΤ˻Ȥ */
  int *rev_seq_len;/* ǽĹñĹ */
  /* ʸᶭcontextΥԡ */
  int *seg_border;
  /*  */
  allocator MwAllocator, WlAllocator, ExAllocator;
};


/* defined in wordseq.c */
/* Ωʹߤ³ν */
void anthy_scan_node(struct splitter_context *sc,
		     struct word_list *wl,
		     xstr *follow, int node);
int anthy_get_node_id_by_name(const char *name);
int anthy_init_depword_tab(void);
void anthy_release_depword_tab(void);


/* defined in wordlist.c */
void anthy_commit_word_list(struct splitter_context *, struct word_list *wl);
struct word_list *anthy_alloc_word_list(struct splitter_context *);
void anthy_print_word_list(struct splitter_context *, struct word_list *);
void anthy_make_word_list_all(struct splitter_context *);
int anthy_init_wordlist(void);
/* extent */
struct extent *anthy_find_extent(struct splitter_context *,
				 int from, int len, int force);

/* defined in metaword.c */
void anthy_make_metaword_all(struct splitter_context *);
void anthy_print_metaword(struct splitter_context *, struct meta_word *);


/* defined in evalborder.c */
void anthy_eval_border(struct splitter_context *, int, int);


/* ʻ */
extern wtype_t anthy_wtype_noun;
extern wtype_t anthy_wtype_prefix, anthy_wtype_postfix;
extern wtype_t anthy_wtype_a_tail_of_v_renyou;
extern wtype_t anthy_wtype_v_renyou;
extern wtype_t anthy_wtype_noun_tail;/* ֤ơפȤ */
extern wtype_t anthy_wtype_n1;
extern wtype_t anthy_wtype_n10;


#endif
