;
(define shift-key-mask
  (lambda (state)
    (= (bit-and state 1) 1)))
(define control-key-mask
  (lambda (state)
    (= (bit-and state 2) 2)))
(define alt-key-mask
  (lambda (state)
    (= (bit-and state 4) 4)))
(define meta-key-mask
  (lambda (state)
    (= (bit-and state 8) 8)))

(define modifier-key-mask
  (lambda (state)
    (> state 0)))
;;
(define backspace-key
  (lambda (key key-state)
    (= key 'backspace)))
(define left-key
  (lambda (key key-state)
    (= key 'left)))
(define right-key
  (lambda (key key-state)
    (= key 'right)))

(define modifier-key
  (lambda (key key-state)
    (or
     (= key 'Shift_key)
     (= key 'Alt_key)
     (= key 'Control_key)
     (= key 'Meta_key))))

(define switch-im-key
  (lambda (key state)
    (or
     (and (control-key-mask state)
	  (= key 'Shift_key))
     (and (shift-key-mask state)
	  (= key 'Control_key)))))

;;
(define set-key-binding
  (lambda (im state flavor)
    nil
    ))

(define regist-key-binding 
  (lambda (bind-name bind-table)
    nil
))
