/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.plugin2.applet.Applet2ClassLoader;
import sun.plugin2.applet.Applet2Manager;
import sun.plugin2.applet.StopListener;
import sun.plugin2.util.SystemUtil;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class Applet2ClassLoaderCache {
    private static final boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    private EntryCreator entryCreator;
    private static final boolean IS_IN_USE;
    private Map cache = new HashMap();
    private List zombieList = new ArrayList();
    private static final int MAX_ZOMBIES;

    public Applet2ClassLoaderCache(EntryCreator entryCreator) {
        this.entryCreator = entryCreator;
    }

    public boolean isInUse() {
        return IS_IN_USE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry get(String string, Applet2Manager applet2Manager) {
        assert (Thread.holdsLock(applet2Manager));
        Entry entry = null;
        Applet2ClassLoaderCache applet2ClassLoaderCache = this;
        synchronized (applet2ClassLoaderCache) {
            boolean bl = false;
            entry = (Entry)this.cache.get(string);
            if (entry == null) {
                bl = true;
                entry = this.lookupInZombieList(string);
                if (entry == null) {
                    entry = new Entry(string);
                    if (DEBUG) {
                        System.out.println("Applet2ClassLoaderCache created new entry for " + string);
                    }
                } else if (DEBUG) {
                    System.out.println("Applet2ClassLoaderCache using zombie list entry for " + string);
                }
            } else if (DEBUG) {
                System.out.println("Applet2ClassLoaderCache reusing entry for " + string);
            }
            if (bl) {
                this.cache.put(string, entry);
            }
        }
        entry.ref(applet2Manager);
        return entry;
    }

    public void release(Entry entry, Applet2Manager applet2Manager, StopListener stopListener, long l) {
        assert (Thread.holdsLock(applet2Manager));
        entry.unref(applet2Manager, stopListener, l);
    }

    public synchronized void markNotCacheable(String string) {
        this.cache.remove(string);
        Iterator iterator = this.zombieList.iterator();
        while (iterator.hasNext()) {
            SoftReference softReference = (SoftReference)iterator.next();
            Entry entry = (Entry)softReference.get();
            if (entry == null || !entry.getClassLoaderCacheKey().equals(string)) continue;
            iterator.remove();
        }
    }

    public synchronized void markNotCacheable(Entry entry) {
        this.conditionallyRemoveFromCache(entry);
    }

    public synchronized void clear() {
        this.cache.clear();
        this.zombieList.clear();
    }

    public synchronized void dump(PrintWriter printWriter) {
        printWriter.println(ResourceManager.getMessage((String)"console.dump.classloader.cache"));
        for (Object object : this.cache.values()) {
            printWriter.print(ResourceManager.getMessage((String)"console.dump.classloader.live"));
            ((Entry)object).dump(printWriter);
        }
        for (Object object : this.zombieList) {
            Entry entry = (Entry)((SoftReference)object).get();
            if (entry == null) continue;
            printWriter.print(ResourceManager.getMessage((String)"console.dump.classloader.zombie"));
            entry.dump(printWriter);
        }
        printWriter.println(ResourceManager.getMessage((String)"console.dump.classloader.done"));
    }

    private Entry conditionallyRemoveFromCache(Entry entry) {
        Entry entry2 = (Entry)this.cache.remove(entry.getClassLoaderCacheKey());
        if (entry2 == entry) {
            return entry2;
        }
        return null;
    }

    private void cleanupZombieList() {
        Iterator iterator = this.zombieList.iterator();
        while (iterator.hasNext()) {
            SoftReference softReference = (SoftReference)iterator.next();
            if (softReference.get() != null) continue;
            iterator.remove();
        }
    }

    private synchronized void moveToZombieList(Entry entry) {
        if ((entry = this.conditionallyRemoveFromCache(entry)) != null) {
            this.cleanupZombieList();
            this.zombieList.add(0, new SoftReference<Entry>(entry));
            if (this.zombieList.size() > MAX_ZOMBIES) {
                this.zombieList.remove(this.zombieList.size() - 1);
            }
        }
    }

    private Entry lookupInZombieList(String string) {
        Iterator iterator = this.zombieList.iterator();
        while (iterator.hasNext()) {
            SoftReference softReference = (SoftReference)iterator.next();
            Entry entry = (Entry)softReference.get();
            if (entry == null || !entry.getClassLoaderCacheKey().equals(string)) continue;
            iterator.remove();
            return entry;
        }
        return null;
    }

    public void shutdown() {
        Entry entry;
        Object object;
        int n;
        if (DEBUG) {
            System.out.println("Classloader Cache shuting down...");
        }
        ArrayList arrayList = new ArrayList(this.cache.values());
        for (n = 0; n < arrayList.size(); ++n) {
            object = arrayList.get(n);
            if (!(object instanceof Entry) || (entry = (Entry)object) == null || entry.getClassLoader() == null) continue;
            try {
                entry.getClassLoader().close();
                continue;
            }
            catch (IOException iOException) {
                Trace.ignored((Throwable)iOException);
            }
        }
        for (n = 0; n < this.zombieList.size(); ++n) {
            object = (SoftReference)this.zombieList.get(n);
            if (object == null || (entry = (Entry)((SoftReference)object).get()) == null || entry.getClassLoader() == null) continue;
            try {
                entry.getClassLoader().close();
                continue;
            }
            catch (IOException iOException) {
                Trace.ignored((Throwable)iOException);
            }
        }
        this.clear();
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.classloader.cache.enabled"));
        IS_IN_USE = string == null || string.equals("true");
        int n = AccessController.doPrivileged(new GetIntegerAction("javaplugin.classloader.cache.sizes", 4));
        if (n > 4) {
            n = 4;
        }
        MAX_ZOMBIES = n;
    }

    public class Entry {
        private String classLoaderCacheKey;
        private int refCount;
        private Applet2ClassLoader classLoader;
        private AppContext appContext;
        private ThreadGroup threadGroup;

        private Entry(String string) {
            this.classLoaderCacheKey = string;
        }

        public String getClassLoaderCacheKey() {
            return this.classLoaderCacheKey;
        }

        public void setClassLoader(Applet2ClassLoader applet2ClassLoader) {
            this.classLoader = applet2ClassLoader;
        }

        public Applet2ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setAppContext(AppContext appContext) {
            this.appContext = appContext;
        }

        public AppContext getAppContext() {
            return this.appContext;
        }

        public void setThreadGroup(ThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
        }

        public ThreadGroup getThreadGroup() {
            return this.threadGroup;
        }

        private synchronized void ref(Applet2Manager applet2Manager) {
            assert (!Thread.holdsLock(Applet2ClassLoaderCache.this));
            if (++this.refCount == 1) {
                if (this.classLoader == null) {
                    Applet2ClassLoaderCache.this.entryCreator.createAll(applet2Manager, this);
                } else {
                    Applet2ClassLoaderCache.this.entryCreator.createThreadGroupAndAppContext(applet2Manager, this);
                }
            }
        }

        private synchronized void unref(Applet2Manager applet2Manager, StopListener stopListener, long l) {
            assert (!Thread.holdsLock(Applet2ClassLoaderCache.this));
            if (--this.refCount == 0) {
                Applet2ClassLoaderCache.this.entryCreator.destroyThreadGroupAndAppContext(applet2Manager, stopListener, l, this);
                Applet2ClassLoaderCache.this.moveToZombieList(this);
            }
        }

        private synchronized void dump(PrintWriter printWriter) {
            printWriter.println("key=" + this.classLoaderCacheKey + ", refCount=" + this.refCount + ", threadGroup=" + this.threadGroup);
        }
    }

    public static interface EntryCreator {
        public void createAll(Applet2Manager var1, Entry var2);

        public void createThreadGroupAndAppContext(Applet2Manager var1, Entry var2);

        public void destroyThreadGroupAndAppContext(Applet2Manager var1, StopListener var2, long var3, Entry var5);
    }
}

