/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer.ui;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class PagerButton
extends Button {
    public static final Color COLOR_ACCENT = Color.rgb((int)0, (int)150, (int)201);
    private ImageView imgView1;
    private ImageView imgView2;

    public PagerButton(Image image1, Image image2) {
        if (image1 != null) {
            this.imgView1 = new ImageView(image1);
        }
        if (image2 != null) {
            this.imgView2 = new ImageView(image2);
        }
        this.setGraphic((Node)this.imgView1);
        this.setFocusTraversable(false);
        this.setOpacity(1.0);
        this.setPrefSize(25.0, 25.0);
        this.setBackgroundColor(Color.TRANSPARENT);
        this.hoverProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    PagerButton.this.setBackgroundColor(COLOR_ACCENT);
                } else {
                    PagerButton.this.setBackgroundColor(Color.TRANSPARENT);
                }
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                PagerButton.this.setGraphic((Node)PagerButton.this.imgView2);
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                PagerButton.this.setGraphic((Node)PagerButton.this.imgView1);
            }
        });
    }

    public void setBackgroundColor(Color color) {
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, CornerRadii.EMPTY, Insets.EMPTY)}));
    }
}

