// 7zTestDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "7zTest.h"
#include "7zTestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static const char* lpDllName[] = { "7-zip32.dll", "Unlha32.dll", "Unarj32j.dll", "Unzip32.dll", "Zip32j.dll", "Tar32.dll", "Cab32.dll", "Unrar32.dll", "Bga32.dll", "Ungca32.dll", "yz1.dll" };
static const char* lpPrefix[] = {"SevenZip", "Unlha", "Unarj", "UnZip", "UnZip", "Tar", "Cab", "Unrar", "Bga", "UnGCA", "Yz1" };
static const UINT wm_arcextract = ::RegisterWindowMessage(WM_ARCEXTRACT);

#define IF_PROCEDURE_NOT_FOUND(x)	if (!x) { SetDlgItemText(IDS_RESULT, "T|[g̊֐łB"); return; }

/////////////////////////////////////////////////////////////////////////////
// CMy7zTestDlg _CAO

CMy7zTestDlg::CMy7zTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMy7zTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMy7zTestDlg)
	m_strInput = _T("");
	m_strOutput = _T("");
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_hArcDll= NULL;
	m_hArc = NULL;
}

void CMy7zTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMy7zTestDlg)
	DDX_Control(pDX, IDC_DLL_LIST, m_cmbDllList);
	DDX_Control(pDX, IDL_LIST, m_lcList);
	DDX_CBString(pDX, IDC_INPUT, m_strInput);
	DDX_Text(pDX, IDE_OUTPUT, m_strOutput);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMy7zTestDlg, CDialog)
	//{{AFX_MSG_MAP(CMy7zTestDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_CBN_SELCHANGE(IDC_DLL_LIST, OnSelchangeDllList)
	ON_BN_CLICKED(IDB_SEVEN_ZIP, OnSevenZip)
	ON_BN_CLICKED(IDC_OPEN_ARCHIVE, OnOpenArchive)
	ON_BN_CLICKED(IDC_FIND_FIRST, OnFindFirst)
	ON_BN_CLICKED(IDC_FIND_NEXT, OnFindNext)
	ON_BN_CLICKED(IDC_CLOSE_ARCHIVE, OnCloseArchive)
	ON_BN_CLICKED(IDC_GET_FILE_COUNT, OnGetFileCount)
	ON_BN_CLICKED(IDC_QUERY_FUNCTION_LIST, OnQueryFunctionList)
	ON_BN_CLICKED(IDC_GET_VERSION, OnGetVersion)
	ON_BN_CLICKED(IDC_GET_RUNNING, OnGetRunning)
	ON_BN_CLICKED(IDC_CONFIG_DIALOG, OnConfigDialog)
	ON_BN_CLICKED(IDC_CHECK_ARCHIVE, OnCheckArchive)
	ON_BN_CLICKED(IDC_GET_ARC_FILE_NAME, OnGetArcFileName)
	ON_BN_CLICKED(IDC_GET_ARC_FILE_SIZE, OnGetArcFileSize)
	ON_BN_CLICKED(IDC_GET_ARC_ORIGINAL_SIZE, OnGetArcOriginalSize)
	ON_BN_CLICKED(IDC_GET_ARC_COMPRESSED_SIZE, OnGetArcCompressedSize)
	ON_BN_CLICKED(IDC_GET_ARC_RATIO, OnGetArcRatio)
	ON_BN_CLICKED(IDC_GET_ARC_DATE, OnGetArcDate)
	ON_BN_CLICKED(IDC_GET_ARC_TIME, OnGetArcTime)
	ON_BN_CLICKED(IDC_GET_ARC_OS_TYPE, OnGetArcOSType)
	ON_BN_CLICKED(IDC_IS_SFX_FILE, OnIsSFXFile)
	ON_BN_CLICKED(IDC_GET_FILE_NAME, OnGetFileName)
	ON_BN_CLICKED(IDC_GET_ORIGINAL_SIZE, OnGetOriginalSize)
	ON_BN_CLICKED(IDC_GET_COMPRESSED_SIZE, OnGetCompressedSize)
	ON_BN_CLICKED(IDC_GET_RATIO, OnGetRatio)
	ON_BN_CLICKED(IDC_GET_DATE, OnGetDate)
	ON_BN_CLICKED(IDC_GET_TIME, OnGetTime)
	ON_BN_CLICKED(IDC_GET_CRC, OnGetCRC)
	ON_BN_CLICKED(IDC_GET_ATTRIBUTE, OnGetAttribute)
	ON_BN_CLICKED(IDC_GET_OS_TYPE, OnGetOSType)
	ON_BN_CLICKED(IDC_GET_METHOD, OnGetMethod)
	ON_BN_CLICKED(IDC_GET_WRITE_TIME, OnGetWriteTime)
	ON_BN_CLICKED(IDC_GET_WRITE_TIME_EX, OnGetWriteTimeEx)
	ON_BN_CLICKED(IDC_GET_ARC_WRITE_TIME_EX, OnGetArcWriteTimeEx)
	ON_BN_CLICKED(IDC_GET_ARC_CREATE_TIME_EX, OnGetArcCreateTimeEx)
	ON_BN_CLICKED(IDC_GET_ARC_ACCESS_TIME_EX, OnGetArcAccessTimeEx)
	ON_BN_CLICKED(IDC_SET_OWNER_WINDOW, OnSetOwnerWindow)
	ON_BN_CLICKED(IDC_CLEAR_OWNER_WINDOW, OnClearOwnerWindow)
	ON_BN_CLICKED(IDC_SET_OWNER_WINDOW_EX, OnSetOwnerWindowEx)
	ON_BN_CLICKED(IDC_KILL_OWNER_WINDOW_EX, OnKillOwnerWindowEx)
	ON_BN_CLICKED(IDC_SET_OWNER_WINDOW_EX64, OnSetOwnerWindowEx64)
	ON_BN_CLICKED(IDC_KILL_OWNER_WINDOW_EX64, OnKillOwnerWindowEx64)
	ON_BN_CLICKED(IDC_GET_SUB_VERSION, OnGetSubVersion)
	ON_BN_CLICKED(IDC_GET_ARC_FILE_SIZE_EX, OnGetArcFileSizeEx)
	ON_BN_CLICKED(IDC_GET_ARC_ORIGINAL_SIZE_EX, OnGetArcOriginalSizeEx)
	ON_BN_CLICKED(IDC_GET_ARC_COMPRESSED_SIZE_EX, OnGetArcCompressedSizeEx)
	ON_BN_CLICKED(IDC_GET_ORIGINAL_SIZE_EX, OnGetOriginalSizeEx)
	ON_BN_CLICKED(IDC_GET_COMPRESSED_SIZE_EX, OnGetCompressedSizeEx)
	ON_BN_CLICKED(IDC_GET_CREATE_TIME, OnGetCreateTime)
	ON_BN_CLICKED(IDC_GET_ACCESS_TIME, OnGetAccessTime)
	ON_BN_CLICKED(IDC_GET_ARCHIVE_TYPE, OnGetArchiveType)
	//}}AFX_MSG_MAP
	ON_REGISTERED_MESSAGE(wm_arcextract, OnArcExtract)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy7zTestDlg bZ[W nh

BOOL CMy7zTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ
	
	// TODO: ʂȏs͂̏ꏊɒǉĂB
	for (int i = 0; i < sizeof(lpDllName) / sizeof(char*); ++i)
		m_cmbDllList.AddString(lpDllName[i]);
	m_cmbDllList.SetCurSel(0);
	OnSelchangeDllList();

	m_lcList.InsertColumn(1, _T("t@C"), LVCFMT_LEFT, 50, -1);
	m_lcList.InsertColumn(2, _T("TCY"), LVCFMT_LEFT, 50, -1);
	m_lcList.InsertColumn(3, _T("i[TCY"), LVCFMT_LEFT, 50, -1);
	m_lcList.InsertColumn(4, _T("k"), LVCFMT_LEFT, 50, -1);
	m_lcList.InsertColumn(5, _T("XV"), LVCFMT_LEFT, 50, -1);
	m_lcList.InsertColumn(6, _T(""), LVCFMT_LEFT, 50, -1);
	m_lcList.InsertColumn(7, _T("CRC"), LVCFMT_LEFT, 50, -1);
	m_lcList.InsertColumn(8, _T("MODE"), LVCFMT_LEFT, 50, -1);
	m_lcList.InsertColumn(9, _T("OSType"), LVCFMT_LEFT, 50, -1);
	m_lcList.InsertColumn(10, _T("Flag"), LVCFMT_LEFT, 50, -1);

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CMy7zTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CMy7zTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CMy7zTestDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	::FreeLibrary(m_hArcDll);
}

void CMy7zTestDlg::OnSelchangeDllList() 
{
	if (m_hArcDll)
		::FreeLibrary(m_hArcDll);
	m_nSelectDll = m_cmbDllList.GetCurSel();
	m_hArcDll = ::LoadLibrary(lpDllName[m_nSelectDll]);
	SetDlgItemInt(IDS_RESULT, (int)m_hArcDll);
}

FARPROC CMy7zTestDlg::GetFuncAddress(LPCTSTR lpFuncName)
{
	char lpApiName[256];
	sprintf(lpApiName, "%s%s", lpPrefix[m_nSelectDll], lpFuncName);
	return ::GetProcAddress(m_hArcDll, lpApiName);
}

void CMy7zTestDlg::OnSevenZip() 
{
	UpdateData();
	LPSTR lpMes = m_strOutput.GetBuffer(65536);
	FARPROC f = ::GetProcAddress(m_hArcDll, lpPrefix[m_nSelectDll]);
	IF_PROCEDURE_NOT_FOUND(f);
	typedef int  (WINAPI* SEVEN_ZIP)(const HWND,LPCSTR,LPSTR,const DWORD);
	int nRes = ((SEVEN_ZIP)f)( m_hWnd, (char*)(LPCTSTR)m_strInput, lpMes, 65536);
	m_strOutput.ReleaseBuffer();
	if (nRes < 0x8000)
		SetDlgItemInt(IDS_RESULT, nRes);
	else
	{
		char lpRes[16];
		sprintf(lpRes, "0x%x", nRes);
		SetDlgItemText(IDS_RESULT, lpRes);
	}
	UpdateData(FALSE);
}

void CMy7zTestDlg::OnOpenArchive() 
{
	UpdateData();
	FARPROC f = GetFuncAddress("OpenArchive");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef HARC (WINAPI* OPEN_ARCHIVE)(const HWND, LPCSTR, const DWORD);
	m_hArc = ((OPEN_ARCHIVE)f)(m_hWnd, (char*)(LPCTSTR)m_strInput, 0);
	SetDlgItemInt(IDS_RESULT, (int)m_hArc);
}

void CMy7zTestDlg::OnFindFirst() 
{
	UpdateData();
	INDIVIDUALINFO indiv;
	FARPROC f = GetFuncAddress("FindFirst");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef int (WINAPI* FIND_FIRST)(HARC ,LPCSTR ,INDIVIDUALINFO*);
	int nRes = ((FIND_FIRST)f)(m_hArc, (char*)(LPCTSTR)m_strInput, &indiv);
	if (nRes == 0)
		AddList(&indiv);
	SetDlgItemInt(IDS_RESULT, nRes);
}

void CMy7zTestDlg::OnFindNext() 
{
	UpdateData();
	INDIVIDUALINFO indiv;
	FARPROC f = GetFuncAddress("FindNext");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef int (WINAPI* FIND_NEXT)(HARC ,INDIVIDUALINFO*);
	int nRes = ((FIND_NEXT)f)(m_hArc, &indiv);
	if (nRes == 0)
		AddList(&indiv);
	SetDlgItemInt(IDS_RESULT, nRes);
}

void CMy7zTestDlg::AddList(INDIVIDUALINFO *lpSubInfo)
{
	int nCount = m_lcList.GetItemCount();
	char lpText[256];
	m_lcList.InsertItem(nCount, lpSubInfo->szFileName);
	sprintf(lpText, "%u", lpSubInfo->dwOriginalSize);
	m_lcList.SetItemText(nCount, 1, lpText);
	sprintf(lpText, "%u", lpSubInfo->dwCompressedSize);
	m_lcList.SetItemText(nCount, 2, lpText);
	if (lpSubInfo->wRatio == 0xFFFF)
		strcpy(lpText, "?");
	else
		sprintf(lpText, "%u.%u%", lpSubInfo->wRatio / 10, lpSubInfo->wRatio % 10);
	m_lcList.SetItemText(nCount, 3, lpText);
	sprintf(lpText,
			"%04u-%02u-%02u %02u:%02u:%02u",
			(lpSubInfo->wDate >> 9) + 1980,
			(lpSubInfo->wDate >> 5) & 0x0F,
			(lpSubInfo->wDate & 0x1F),
			(lpSubInfo->wTime >> 11),
			(lpSubInfo->wTime >> 5) & 0x3F,
			(lpSubInfo->wTime & 0x1F) * 2);
	m_lcList.SetItemText(nCount, 4, lpText);
	m_lcList.SetItemText(nCount, 5, lpSubInfo->szAttribute);
	sprintf(lpText, "%08x", lpSubInfo->dwCRC);
	m_lcList.SetItemText(nCount, 6, lpText);
	m_lcList.SetItemText(nCount, 7, lpSubInfo->szMode);
	sprintf(lpText, "%u", lpSubInfo->uOSType);
	m_lcList.SetItemText(nCount, 8, lpText);
	sprintf(lpText, "%u", lpSubInfo->uFlag);
	m_lcList.SetItemText(nCount, 9, lpText);
}

void CMy7zTestDlg::OnCloseArchive() 
{
	FARPROC f = GetFuncAddress("CloseArchive");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef int (WINAPI * CLOSE_ARCHIVE)(HARC);
	int nRes = ((CLOSE_ARCHIVE)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, nRes);
}

void CMy7zTestDlg::OnGetFileCount() 
{
	UpdateData();
	FARPROC f = GetFuncAddress("GetFileCount");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef int (WINAPI * GET_FILE_COUNT)(LPCSTR);
	int nRes = ((GET_FILE_COUNT)f)((LPCSTR)(LPCTSTR)m_strInput);
	SetDlgItemInt(IDS_RESULT, nRes);
}

void CMy7zTestDlg::OnQueryFunctionList() 
{
	UpdateData();
	FARPROC f = GetFuncAddress("QueryFunctionList");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * QUERY_FUNCTION_LIST)(const int);
	BOOL bRes = ((QUERY_FUNCTION_LIST)f)(atoi(m_strInput));
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
}

void CMy7zTestDlg::OnGetVersion() 
{
	FARPROC f = GetFuncAddress("GetVersion");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef WORD (WINAPI * GET_VERSION)();
	WORD wRes = ((GET_VERSION)f)();
	SetDlgItemInt(IDS_RESULT, wRes);
}

void CMy7zTestDlg::OnGetRunning() 
{
	UpdateData();
	FARPROC f = GetFuncAddress("GetRunning");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * GET_RUNNING)();
	BOOL bRes = ((GET_RUNNING)f)();
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
}

void CMy7zTestDlg::OnConfigDialog() 
{
	UpdateData();
	FARPROC f = GetFuncAddress("ConfigDialog");
	IF_PROCEDURE_NOT_FOUND(f);
	LPSTR _szOptionBuffer= m_strOutput.GetBuffer(1024);
	typedef BOOL (WINAPI * CONFIG_DIALOG)(const HWND, LPSTR, const int);
	BOOL bRes = ((CONFIG_DIALOG)f)(m_hWnd, _szOptionBuffer, atoi(m_strInput));
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
	m_strOutput.ReleaseBuffer();
	UpdateData(FALSE);
}

void CMy7zTestDlg::OnCheckArchive() 
{
	UpdateData();
	FARPROC f = GetFuncAddress("CheckArchive");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * CHECK_ARCHIVE)(LPCSTR, const int);
	BOOL bRes = ((CHECK_ARCHIVE)f)((LPCSTR)(LPCTSTR)m_strInput, 0);
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
}

void CMy7zTestDlg::OnGetArcFileName() 
{
	FARPROC f = GetFuncAddress("GetArcFileName");
	IF_PROCEDURE_NOT_FOUND(f);
	LPSTR lpFileName = m_strOutput.GetBuffer(FNAME_MAX32);
	typedef int (WINAPI * GET_ARC_FILE_NAME)(HARC, LPSTR, const int);
	int nRes = ((GET_ARC_FILE_NAME)f)(m_hArc, lpFileName, FNAME_MAX32);
	SetDlgItemInt(IDS_RESULT, nRes);
	m_strOutput.ReleaseBuffer();
	UpdateData(FALSE);
}

void CMy7zTestDlg::OnGetArcFileSize() 
{
	FARPROC f = GetFuncAddress("GetArcFileSize");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef DWORD (WINAPI * GET_ARC_FILE_SIZE)(HARC);
	DWORD dwRes = ((GET_ARC_FILE_SIZE)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, dwRes);
}

void CMy7zTestDlg::OnGetArcOriginalSize() 
{
	FARPROC f = GetFuncAddress("GetArcOriginalSize");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef DWORD (WINAPI * GET_ARC_ORIGINAL_SIZE)(HARC);
	DWORD dwRes = ((GET_ARC_ORIGINAL_SIZE)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, dwRes);
}

void CMy7zTestDlg::OnGetArcCompressedSize() 
{
	FARPROC f = GetFuncAddress("GetArcCompressedSize");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef DWORD (WINAPI * GET_ARC_COMPRESSED_SIZE)(HARC);
	DWORD dwRes = ((GET_ARC_COMPRESSED_SIZE)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, dwRes);
}

void CMy7zTestDlg::OnGetArcRatio() 
{
	FARPROC f = GetFuncAddress("GetArcRatio");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef WORD (WINAPI * GET_ARC_RATIO)(HARC);
	WORD wRes = ((GET_ARC_RATIO)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, wRes);
}

void CMy7zTestDlg::OnGetArcDate() 
{
	FARPROC f = GetFuncAddress("GetArcDate");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef WORD (WINAPI * GET_ARC_DATE)(HARC);
	WORD wRes = ((GET_ARC_DATE)f)(m_hArc);
	char lpDate[16];
	sprintf(lpDate, "%.4u-%.2u-%.2u", (wRes >> 9) + 1980, (wRes >> 5) & 0x0F, (wRes & 0x1F));
	SetDlgItemText(IDS_RESULT, lpDate);
}

void CMy7zTestDlg::OnGetArcTime() 
{
	FARPROC f = GetFuncAddress("GetArcTime");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef WORD (WINAPI * GET_ARC_TIME)(HARC);
	WORD wRes = ((GET_ARC_TIME)f)(m_hArc);
	char lpTime[16];
	sprintf(lpTime, "%.2u:%.2u:%.2u", (wRes >> 11), (wRes >> 5) & 0x3F, (wRes & 0x1F) * 2);
	SetDlgItemText(IDS_RESULT, lpTime);
}

void CMy7zTestDlg::OnGetArcOSType() 
{
	FARPROC f = GetFuncAddress("GetArcOSType");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef UINT (WINAPI * GET_ARC_OS_TYPE)(HARC);
	UINT nRes = ((GET_ARC_OS_TYPE)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, nRes);
}

void CMy7zTestDlg::OnIsSFXFile() 
{
	FARPROC f = GetFuncAddress("IsSFXFile");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef int (WINAPI * IS_SFX_FILE)(HARC);
	int nRes = ((IS_SFX_FILE)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, nRes);
}

void CMy7zTestDlg::OnGetFileName() 
{
	FARPROC f = GetFuncAddress("GetFileName");
	IF_PROCEDURE_NOT_FOUND(f);
	LPSTR lpBuffer = m_strOutput.GetBuffer(256);
	typedef int (WINAPI * GET_FILE_NAME)(HARC, LPSTR, const int);
	int nRes = ((GET_FILE_NAME)f)(m_hArc, lpBuffer, 256);
	SetDlgItemInt(IDS_RESULT, nRes);
	m_strOutput.ReleaseBuffer();
	UpdateData(FALSE);
}

void CMy7zTestDlg::OnGetOriginalSize() 
{
	FARPROC f = GetFuncAddress("GetOriginalSize");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef DWORD (WINAPI * GET_ORIGINAL_SIZE)(HARC);
	DWORD dwRes = ((GET_ORIGINAL_SIZE)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, dwRes);
}

void CMy7zTestDlg::OnGetCompressedSize() 
{
	FARPROC f = GetFuncAddress("GetCompressedSize");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef DWORD (WINAPI * GET_COMPRESSED_SIZE)(HARC);
	DWORD dwRes = ((GET_COMPRESSED_SIZE)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, dwRes);
}

void CMy7zTestDlg::OnGetRatio() 
{
	FARPROC f = GetFuncAddress("GetRatio");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef WORD (WINAPI * GET_RATIO)(HARC);
	WORD wRes = ((GET_RATIO)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, wRes);
}

void CMy7zTestDlg::OnGetDate() 
{
	FARPROC f = GetFuncAddress("GetDate");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef WORD (WINAPI * GET_DATE)(HARC);
	WORD wRes = ((GET_DATE)f)(m_hArc);
	char lpDate[16];
	sprintf(lpDate, "%.4u-%.2u-%.2u", (wRes >> 9) + 1980, (wRes >> 5) & 0x0F, (wRes & 0x1F));
	SetDlgItemText(IDS_RESULT, lpDate);
}

void CMy7zTestDlg::OnGetTime() 
{
	FARPROC f = GetFuncAddress("GetTime");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef WORD (WINAPI * GET_TIME)(HARC);
	WORD wRes = ((GET_TIME)f)(m_hArc);
	char lpTime[16];
	sprintf(lpTime, "%.2u:%.2u:%.2u", (wRes >> 11), (wRes >> 5) & 0x3F, (wRes & 0x1F) * 2);
	SetDlgItemText(IDS_RESULT, lpTime);
}

void CMy7zTestDlg::OnGetCRC() 
{
	FARPROC f = GetFuncAddress("GetCRC");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef DWORD (WINAPI * GET_CRC)(HARC);
	DWORD dwRes = ((GET_CRC)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, dwRes);
}

void CMy7zTestDlg::OnGetAttribute() 
{
	FARPROC f = GetFuncAddress("GetAttribute");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef int (WINAPI * GET_ATTRIBUTE)(HARC);
	int nRes = ((GET_ATTRIBUTE)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, nRes);
}

void CMy7zTestDlg::OnGetOSType() 
{
	FARPROC f = GetFuncAddress("GetOSType");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef UINT (WINAPI * GET_OS_TYPE)(HARC);
	UINT nRes = ((GET_OS_TYPE)f)(m_hArc);
	SetDlgItemInt(IDS_RESULT, nRes);
}

void CMy7zTestDlg::OnGetMethod() 
{
	FARPROC f = GetFuncAddress("GetMethod");
	IF_PROCEDURE_NOT_FOUND(f);
	LPSTR lpString = m_strOutput.GetBuffer(128);
	typedef int (WINAPI * GET_GET_METHOD)(HARC, LPSTR, const int);
	int nRes = ((GET_GET_METHOD)f)(m_hArc, lpString, 128);
	SetDlgItemInt(IDS_RESULT, nRes);
	UpdateData(FALSE);
}

void CMy7zTestDlg::OnGetWriteTime() 
{
	FARPROC f = GetFuncAddress("GetWriteTime");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef DWORD (WINAPI * GET_WRITE_TIME)(HARC);
	DWORD dwRes = ((GET_WRITE_TIME)f)(m_hArc);
	SetDlgItemText(IDS_RESULT, ctime((time_t*)&dwRes));
}

void CMy7zTestDlg::OnGetWriteTimeEx() 
{
	FILETIME ft;
	FARPROC f = GetFuncAddress("GetWriteTimeEx");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * GET_WRITE_TIME_EX)(HARC, FILETIME*);
	BOOL bRes = ((GET_WRITE_TIME_EX)f)(m_hArc, &ft);
	CTime t(ft);
	SetDlgItemText(IDS_RESULT, t.Format("%Y-%m-%d %H:%M:%S"));
}

void CMy7zTestDlg::OnGetArcWriteTimeEx() 
{
	FILETIME ft;
	FARPROC f = GetFuncAddress("GetArcWriteTimeEx");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * GET_ARC_WRITE_TIME_EX)(HARC, FILETIME*);
	BOOL bRes = ((GET_ARC_WRITE_TIME_EX)f)(m_hArc, &ft);
	CTime t(ft);
	SetDlgItemText(IDS_RESULT, t.Format("%Y-%m-%d %H:%M:%S"));
}

void CMy7zTestDlg::OnGetArcCreateTimeEx() 
{
	FILETIME ft;
	FARPROC f = GetFuncAddress("GetArcCreateTimeEx");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * GET_ARC_CREATE_TIME_EX)(HARC, FILETIME*);
	BOOL bRes = ((GET_ARC_CREATE_TIME_EX)f)(m_hArc, &ft);
	CTime t(ft);
	SetDlgItemText(IDS_RESULT, t.Format("%Y-%m-%d %H:%M:%S"));
}

void CMy7zTestDlg::OnGetArcAccessTimeEx() 
{
	FILETIME ft;
	FARPROC f = GetFuncAddress("GetArcAccessTimeEx");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * GET_ARC_ACCESS_TIME_EX)(HARC, FILETIME*);
	BOOL bRes = ((GET_ARC_ACCESS_TIME_EX)f)(m_hArc, &ft);
	CTime t(ft);
	SetDlgItemText(IDS_RESULT, t.Format("%Y-%m-%d %H:%M:%S"));
}

LRESULT CMy7zTestDlg::OnArcExtract(WPARAM wParam, LPARAM lParam)
{
	LPEXTRACTINGINFO lpEai = (LPEXTRACTINGINFO)lParam;
	TRACE("mode %d\n", wParam);
	return 0;
}

BOOL CALLBACK ArchiveProc(HWND _hwnd, UINT _uMsg, UINT _nState, LPVOID _lpEis)
{
	LPEXTRACTINGINFOEX lpEiex = (LPEXTRACTINGINFOEX)_lpEis;
	TRACE("msg=%d state=%d", _uMsg, _nState);
	if (lpEiex)
		TRACE(" fsize=%d wsize=%d sname=%s dname=%s cmp=%d crc=%d os=%d raito=%d date=%d time=%d att=%s mode=%s\n", lpEiex->exinfo.dwFileSize, lpEiex->exinfo.dwWriteSize, lpEiex->exinfo.szSourceFileName, lpEiex->exinfo.szDestFileName, lpEiex->dwCompressedSize, lpEiex->dwCRC, lpEiex->uOSType, lpEiex->wRatio, lpEiex->wDate, lpEiex->wTime, lpEiex->szAttribute, lpEiex->szMode);
	return TRUE;
}

BOOL CALLBACK ArchiveProc32(HWND _hwnd, UINT _uMsg, UINT _nState, LPVOID _lpEis)
{
	LPEXTRACTINGINFOEX32 lpEiex = (LPEXTRACTINGINFOEX32)_lpEis;
	TRACE("msg=%d state=%d thid=%d\n", _uMsg, _nState, ::GetCurrentThreadId());
	if (lpEiex)
		TRACE(" struct=%d fsize=%d wsize=%d sname=%s dname=%s cmp=%d crc=%d os=%d raito=%d write=%d create=%d att=%d mode=%s\n", lpEiex->dwStructSize, lpEiex->dwFileSize, lpEiex->dwWriteSize, lpEiex->szSourceFileName, lpEiex->szDestFileName, lpEiex->dwCompressedSize, lpEiex->dwCRC, lpEiex->uOSType, lpEiex->wRatio, lpEiex->ftWriteTime.dwLowDateTime, lpEiex->ftCreateTime.dwLowDateTime, lpEiex->dwAttributes, lpEiex->szMode);
	return TRUE;
}

BOOL CALLBACK ArchiveProc64(HWND _hwnd, UINT _uMsg, UINT _nState, LPVOID _lpEis)
{
	LPEXTRACTINGINFOEX64 lpEiex = (LPEXTRACTINGINFOEX64)_lpEis;
	TRACE("msg=%d state=%d", _uMsg, _nState);
	if (lpEiex)
		TRACE(" struct=%d fsize=%d wsize=%d sname=%s dname=%s cmp=%d crc=%d os=%d raito=%d write=%d create=%d att=%d mode=%s\n", lpEiex->dwStructSize, (int)lpEiex->llFileSize, (int)lpEiex->llWriteSize, lpEiex->szSourceFileName, lpEiex->szDestFileName, (int)lpEiex->llCompressedSize, lpEiex->dwCRC, lpEiex->uOSType, lpEiex->wRatio, lpEiex->ftWriteTime.dwLowDateTime, lpEiex->ftCreateTime.dwLowDateTime, lpEiex->dwAttributes, lpEiex->szMode);
	return TRUE;
}

void CMy7zTestDlg::OnSetOwnerWindow() 
{
	FARPROC f = GetFuncAddress("SetOwnerWindow");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * SET_OWNER_WINDOW)(HWND);
	BOOL bRes = ((SET_OWNER_WINDOW)f)(m_hWnd);
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
}

void CMy7zTestDlg::OnClearOwnerWindow() 
{
	FARPROC f = GetFuncAddress("ClearOwnerWindow");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * CLEAR_OWNER_WINDOW)();
	BOOL bRes = ((CLEAR_OWNER_WINDOW)f)();
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
}

void CMy7zTestDlg::OnSetOwnerWindowEx() 
{
	FARPROC f = GetFuncAddress("SetOwnerWindowEx");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * SET_OWNER_WINDOW_EX)(HWND, LPARCHIVERPROC);
	BOOL bRes = ((SET_OWNER_WINDOW_EX)f)(m_hWnd, ArchiveProc);
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
}

void CMy7zTestDlg::OnKillOwnerWindowEx() 
{
	FARPROC f = GetFuncAddress("KillOwnerWindowEx");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * KILL_OWNER_WINDOW_EX)(HWND);
	BOOL bRes = ((KILL_OWNER_WINDOW_EX)f)(m_hWnd);
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
}

void CMy7zTestDlg::OnSetOwnerWindowEx64() 
{
	FARPROC f = GetFuncAddress("SetOwnerWindowEx64");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * SET_OWNER_WINDOW_EX64)(HWND, LPARCHIVERPROC, DWORD);
	BOOL bRes = ((SET_OWNER_WINDOW_EX64)f)(m_hWnd, ArchiveProc32, sizeof(EXTRACTINGINFOEX32));
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
}

void CMy7zTestDlg::OnKillOwnerWindowEx64() 
{
	FARPROC f = GetFuncAddress("KillOwnerWindowEx64");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * KILL_OWNER_WINDOW_EX64)(HWND);
	BOOL bRes = ((KILL_OWNER_WINDOW_EX64)f)(m_hWnd);
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
}

void CMy7zTestDlg::OnGetSubVersion() 
{
	FARPROC f = GetFuncAddress("GetSubVersion");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef WORD (WINAPI * GET_SUB_VERSION)();
	WORD wRes = ((GET_SUB_VERSION)f)();
	SetDlgItemInt(IDS_RESULT, wRes);
}

void CMy7zTestDlg::OnGetArcFileSizeEx() 
{
	ULHA_INT64 llSize;
	FARPROC f = GetFuncAddress("GetArcFileSizeEx");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * GET_ARC_FILE_SIZE_EX)(HARC, ULHA_INT64*);
	BOOL bRes = ((GET_ARC_FILE_SIZE_EX)f)(m_hArc, &llSize);
	m_strOutput.Format("%I64u", llSize);
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
	UpdateData(FALSE);
}

void CMy7zTestDlg::OnGetArcOriginalSizeEx() 
{
	ULHA_INT64 llSize;
	FARPROC f = GetFuncAddress("GetArcOriginalSizeEx");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * GET_ARC_ORIGINAL_SIZE_EX)(HARC, ULHA_INT64*);
	BOOL bRes = ((GET_ARC_ORIGINAL_SIZE_EX)f)(m_hArc, &llSize);
	m_strOutput.Format("%I64u", llSize);
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
	UpdateData(FALSE);
}

void CMy7zTestDlg::OnGetArcCompressedSizeEx() 
{
	ULHA_INT64 llSize;
	FARPROC f = GetFuncAddress("GetArcCompressedSizeEx");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * GET_ARC_COMPRESSED_SIZE_EX)(HARC, ULHA_INT64*);
	BOOL bRes = ((GET_ARC_COMPRESSED_SIZE_EX)f)(m_hArc, &llSize);
	m_strOutput.Format("%I64u", llSize);
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
	UpdateData(FALSE);
}

void CMy7zTestDlg::OnGetOriginalSizeEx() 
{
	ULHA_INT64 llSize;
	FARPROC f = GetFuncAddress("GetOriginalSizeEx");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * GET_ORIGINAL_SIZE_EX)(HARC, ULHA_INT64*);
	BOOL bRes = ((GET_ORIGINAL_SIZE_EX)f)(m_hArc, &llSize);
	m_strOutput.Format("%I64u", llSize);
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
	UpdateData(FALSE);
}

void CMy7zTestDlg::OnGetCompressedSizeEx() 
{
	ULHA_INT64 llSize;
	FARPROC f = GetFuncAddress("GetCompressedSizeEx");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef BOOL (WINAPI * GET_COMPRESSED_SIZE_EX)(HARC, ULHA_INT64*);
	BOOL bRes = ((GET_COMPRESSED_SIZE_EX)f)(m_hArc, &llSize);
	m_strOutput.Format("%I64u", llSize);
	SetDlgItemText(IDS_RESULT, bRes ? "TRUE" : "FALSE");
	UpdateData(FALSE);
}

void CMy7zTestDlg::OnGetCreateTime() 
{
	FARPROC f = GetFuncAddress("GetCreateTime");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef DWORD (WINAPI * GET_CREATE_TIME)(HARC);
	DWORD dwRes = ((GET_CREATE_TIME)f)(m_hArc);
	SetDlgItemText(IDS_RESULT, ctime((time_t*)&dwRes));
}

void CMy7zTestDlg::OnGetAccessTime() 
{
	FARPROC f = GetFuncAddress("GetAccessTime");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef DWORD (WINAPI * GET_ACCESS_TIME)(HARC);
	DWORD dwRes = ((GET_ACCESS_TIME)f)(m_hArc);
	SetDlgItemText(IDS_RESULT, ctime((time_t*)&dwRes));
}

void CMy7zTestDlg::OnGetArchiveType() 
{
	UpdateData();
	FARPROC f = GetFuncAddress("GetArchiveType");
	IF_PROCEDURE_NOT_FOUND(f);
	typedef int (WINAPI * GET_ARCHIVE_TYPE)(LPCSTR);
	int nRes = ((GET_ARCHIVE_TYPE)f)(m_strInput);
	SetDlgItemInt(IDS_RESULT, nRes);
	
}


