NVIDIA GameWorks D3D Graphics and Compute Samples
====================================================

The D3D Graphics and Compute Samples pack is a resource for 3D feature examples using DirectX 9, 10 and 11.

The samples target multiple Direct3D versions, including DX10 and DX11, and demonstrate advanced D3D features such as Antialiasing, Tessellation, Interleaved Rendering, Deferred Contexts, Compute Shaders and Instancing.

What to Read Next:
------------------
* [Release Notes](http://docs.nvidia.com/gameworks/index.html#gameworkslibrary/graphicssamples/d3d_samples/d3d_release.htm)
** What's new in this release, along with any known issues.
* [Prerequisites](http://docs.nvidia.com/gameworks/index.html#gameworkslibrary/graphicssamples/d3d_samples/d3d_prereq.htm)
** Details the per-platform requirements for developing with the samples.
* [Setup Guide](http://docs.nvidia.com/gameworks/index.html#gameworkslibrary/graphicssamples/d3d_samples/d3d_setup.htm)
** Details the per-platform steps needed to set up your PC for building and running the D3D samples.
* [Overview of D3D Samples](http://docs.nvidia.com/gameworks/index.html#gameworkslibrary/graphicssamples/d3d_samples/d3d_samples.htm)
** Describes each of the samples in the pack, what they demonstrate, and in some cases further detailed analysis of how they work.

Providing Pull Requests:
------------------------
NVIDIA is happy to review and consider pull requests for merging into the main tree of the samples for bug fixes and features. Before providing a pull request to NVIDIA, please note the following:
* A pull request provided to this repo by a developer constitutes permission from the developer for NVIDIA to merge the provided changes or any NVIDIA modified version of these changes to the repo. NVIDIA may remove or change the code at any time and in any way deemed appropriate.
* Not all pull requests can be or will be accepted. NVIDIA will close pull requests that it does not intend to merge.
* The modified files and any new files must include the unmodified NVIDIA copyright header seen at the top of all shipping files. 
