/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

abstract class CharacterEncoding {
    protected boolean usesEncoding;
    private String charsetName;

    CharacterEncoding() {
    }

    public boolean setCharsetName(String string) {
        if (string == null || string.trim().length() == 0) {
            this.usesEncoding = false;
            this.charsetName = string;
        } else {
            if (!Charset.isSupported(string)) {
                return false;
            }
            this.usesEncoding = true;
            this.charsetName = string;
        }
        return true;
    }

    byte[] encode(String string) {
        if (this.usesEncoding) {
            try {
                return string.getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return string.getBytes();
    }

    String decode(byte[] byArray) {
        if (this.usesEncoding) {
            try {
                return new String(byArray, this.charsetName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return new String(byArray);
    }
}

