/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.ArchiveType;
import jp.sourceforge.armadillo.FileArchiver;
import jp.sourceforge.armadillo.FileExpander;
import jp.sourceforge.armadillo.OptionParser;
import jp.sourceforge.armadillo.Utilities;
import jp.sourceforge.armadillo.Version;

public final class Command {
    static final /* synthetic */ boolean $assertionsDisabled;

    private Command() {
    }

    private static void execute(String[] stringArray) throws IOException, ParseException {
        if (stringArray.length < 2) {
            throw new CommandException("It needs at least 2 parameters");
        }
        OptionParser optionParser = new OptionParser(stringArray);
        char c = optionParser.parseMode();
        File file = optionParser.parseArchiveFile();
        boolean bl = optionParser.parseVerbose();
        String string = optionParser.parseOutputDirectory();
        String[] stringArray2 = optionParser.getRest();
        if (c != 'x' && string.length() > 0) {
            System.out.println("warn: directory option is unnecessary in this mode");
        }
        switch (c) {
            case 'c': {
                if (c == 'c' && file.exists()) {
                    System.out.print("archive file '" + file.getName() + "' already exists, overwrite? (y/N)");
                    String string2 = Utilities.getInput();
                    if (string2 == null || !string2.equals("y")) {
                        if (bl) {
                            System.out.println("cancelled.");
                        }
                        return;
                    }
                }
                Command.archive(file, stringArray2, bl);
                break;
            }
            case 't': {
                Command.list(file, stringArray2, bl);
                break;
            }
            case 'x': {
                if (string.length() == 0) {
                    Command.expand(file, new File("."), stringArray2, bl);
                    break;
                }
                File file2 = new File(string);
                if (file2.isDirectory() && file2.exists()) {
                    Command.expand(file, file2, stringArray2, bl);
                    break;
                }
                throw new CommandException("directory '" + string + "' does not exist");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void archive(File file, String[] stringArray, boolean bl) throws IOException {
        ArchiveType archiveType;
        if (bl) {
            System.out.println("armadillo archiving started.");
        }
        if ((archiveType = ArchiveType.getType(file)) == ArchiveType.UNKNOWN) {
            throw new CommandException("invalid file suffix: " + file.getName());
        }
        if (stringArray.length > 0) {
            FileArchiver fileArchiver = new FileArchiver(file);
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    Command.archive(fileArchiver, new File(stringArray[i]), bl);
                }
            }
            finally {
                fileArchiver.close();
            }
        } else {
            throw new CommandException("archive requires targets");
        }
        if (bl) {
            System.out.println("armadillo archiving terminated.");
        }
    }

    private static void archive(FileArchiver fileArchiver, File file, boolean bl) throws IOException {
        String string = Utilities.getEntryName(file);
        ArchiveEntry archiveEntry = new ArchiveEntry(string);
        try {
            archiveEntry.lastModified = file.lastModified();
            if (file.isDirectory()) {
                if (string.equals(".")) {
                    return;
                }
                fileArchiver.addEntry(archiveEntry, file);
                if (bl) {
                    System.out.println("  " + string + " ... STORED");
                }
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    Command.archive(fileArchiver, fileArray[i], bl);
                }
            } else {
                if (bl) {
                    System.out.print("  " + string + " ... ");
                }
                fileArchiver.addEntry(archiveEntry, file);
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer();
                    long l = archiveEntry.size;
                    long l2 = archiveEntry.compressedSize;
                    if (!($assertionsDisabled || l2 >= 0L && l >= 0L)) {
                        throw new AssertionError();
                    }
                    if (l == 0L || l2 == l) {
                        stringBuffer.append("STORED (");
                        stringBuffer.append(l);
                    } else {
                        stringBuffer.append("COMPRESSED (");
                        int n = l2 == l ? 100 : (int)(l2 * 100L / l);
                        stringBuffer.append(n + "%, " + l + " => " + l2);
                    }
                    stringBuffer.append(')');
                    System.out.println(stringBuffer);
                }
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException(iOException.getMessage() + " : entry=" + string);
            iOException2.setStackTrace(iOException.getStackTrace());
            iOException2.initCause(iOException.getCause());
            throw iOException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expand(File file, File file2, String[] stringArray, boolean bl) throws IOException {
        HashSet<String> hashSet;
        boolean bl2;
        if (bl) {
            System.out.println("armadillo expansion started.");
            System.out.println("  * output directory = [" + file2 + ']');
        }
        if (stringArray != null && stringArray.length > 0) {
            bl2 = false;
            hashSet = new HashSet<String>(Arrays.asList(stringArray));
        } else {
            bl2 = true;
            hashSet = Collections.EMPTY_SET;
        }
        FileExpander fileExpander = new FileExpander(file);
        try {
            Object object;
            ArchiveEntry archiveEntry;
            HashSet<ArchiveEntry> hashSet2 = new HashSet<ArchiveEntry>();
            Iterator iterator = fileExpander.iterator();
            while (iterator.hasNext() && !(archiveEntry = (ArchiveEntry)iterator.next()).isNull()) {
                object = archiveEntry.name;
                if (!bl2 && !hashSet.contains(object)) continue;
                if (bl) {
                    System.out.print("  " + (String)object + " ... ");
                }
                File file3 = new File(file2, (String)object);
                if (archiveEntry.isDirectory()) {
                    if (!file3.exists()) {
                        file3.mkdirs();
                    }
                    hashSet2.add(archiveEntry);
                    if (!bl) continue;
                    System.out.println("CREATED");
                    continue;
                }
                File file4 = file3.getParentFile();
                if (!file4.exists() && !file4.mkdirs()) {
                    throw new IOException("can't mkdir '" + file4 + "'");
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                try {
                    long l = fileExpander.expand(fileOutputStream);
                    if (bl) {
                        System.out.println("EXTRACTED (" + l + ")");
                    }
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
                file3.setLastModified(archiveEntry.lastModified);
            }
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                archiveEntry = (ArchiveEntry)iterator.next();
                object = new File(file2, archiveEntry.name);
                ((File)object).setLastModified(archiveEntry.lastModified);
            }
        }
        finally {
            fileExpander.close();
        }
        if (bl) {
            System.out.println("armadillo expansion terminated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void list(File file, String[] stringArray, boolean bl) throws IOException {
        HashSet<String> hashSet;
        boolean bl2;
        if (bl) {
            System.out.println("armadillo listing started.");
        }
        if (stringArray != null && stringArray.length > 0) {
            bl2 = false;
            hashSet = new HashSet<String>(Arrays.asList(stringArray));
        } else {
            bl2 = true;
            hashSet = Collections.EMPTY_SET;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DecimalFormat decimalFormat = new DecimalFormat("###.0");
        FileExpander fileExpander = new FileExpander(file);
        try {
            Iterator iterator = fileExpander.iterator();
            while (iterator.hasNext()) {
                ArchiveEntry archiveEntry = (ArchiveEntry)iterator.next();
                if (archiveEntry.isNull()) {
                    break;
                }
                String string = archiveEntry.name;
                if (!bl2 && !hashSet.contains(string)) continue;
                String string2 = "";
                if (archiveEntry.isDirectory()) {
                    string2 = string2 + 'D';
                    string2 = string2 + Command.padSpace("", bl ? 24 : 8, false);
                } else {
                    long l = archiveEntry.size;
                    string2 = string2 + Command.padSpace(String.valueOf(l), 8, true);
                    if (bl) {
                        string2 = string2 + ' ';
                        long l2 = archiveEntry.compressedSize;
                        String string3 = l2 > 0L ? String.valueOf(l2) : "";
                        string2 = string2 + Command.padSpace(string3, 8, true);
                        string2 = string2 + ' ';
                        if (l > 0L && l2 > 0L) {
                            float f = (float)l2 / 1.0f / (float)l * 100.0f;
                            string2 = string2 + Command.padSpace(decimalFormat.format(f), 5, true);
                            string2 = string2 + '%';
                        } else {
                            string2 = string2 + "------";
                        }
                    }
                    string2 = string2 + ' ';
                }
                string2 = string2 + Command.padSpace(archiveEntry.method, 6, false).substring(0, 6);
                string2 = string2 + ' ';
                string2 = string2 + simpleDateFormat.format(new Date(archiveEntry.lastModified));
                string2 = string2 + ' ';
                string2 = string2 + string;
                System.out.println(string2);
            }
        }
        finally {
            fileExpander.close();
        }
        if (bl) {
            System.out.println("armadillo listing terminated.");
        }
    }

    private static String padSpace(String string, int n, boolean bl) {
        if (string.length() > n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer("        ");
        while (stringBuffer.length() < n) {
            stringBuffer.append(stringBuffer);
        }
        String string2 = stringBuffer.substring(string.length(), n);
        return bl ? string2 + string : string + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printHelp() {
        Properties properties = new Properties();
        InputStream inputStream = Command.class.getResourceAsStream("about.properties");
        try {
            try {
                properties.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        String string = MessageFormat.format(properties.getProperty("about"), Version.getVersionString(false));
        System.out.println(string);
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2;
        block7: {
            try {
                if (stringArray.length < 1 || stringArray[0].equals("-h") || stringArray[0].equals("--help")) {
                    Command.printHelp();
                } else {
                    Command.execute(stringArray);
                }
                return;
            }
            catch (ParseException parseException) {
                string2 = "option error";
                string = parseException.getMessage();
            }
            catch (CommandException commandException) {
                string2 = "command error";
                string = commandException.getMessage();
            }
            catch (IOException iOException) {
                string2 = "I/O error";
                string = iOException.getMessage();
                String string3 = "jp.sourceforge.armadillo.debug";
                if (System.getProperty(string3, "false").equalsIgnoreCase("false")) break block7;
                System.err.println(string2);
                throw iOException;
            }
        }
        System.err.println();
        String string4 = "armadillo: " + string2;
        if (string != null) {
            string4 = string4 + " - " + string;
        }
        System.err.println(string4);
        System.exit(1);
    }

    static {
        $assertionsDisabled = !Command.class.desiredAssertionStatus();
    }

    private static final class CommandException
    extends RuntimeException {
        CommandException(String string) {
            super(string);
        }
    }
}

