/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.ArchiveType;
import jp.sourceforge.armadillo.Archiver;
import jp.sourceforge.armadillo.LzhArchiver;
import jp.sourceforge.armadillo.TarArchiver;
import jp.sourceforge.armadillo.ZipArchiver;

public final class FileArchiver
implements Archiver {
    private Archiver archiver;

    public FileArchiver(File file) throws IOException {
        this(file, ArchiveType.getType(file));
    }

    public boolean setCharsetName(String string) {
        return this.archiver.setCharsetName(string);
    }

    public FileArchiver(File file, ArchiveType archiveType) throws IOException {
        this.archiver = FileArchiver.getArchiver(file, archiveType);
    }

    public void addEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        this.archiver.addEntry(archiveEntry, file);
    }

    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        this.archiver.addEntry(archiveEntry, inputStream, l);
    }

    public static Archiver getArchiver(File file) throws IOException {
        return FileArchiver.getArchiver(file, ArchiveType.getType(file));
    }

    public static Archiver getArchiver(File file, ArchiveType archiveType) throws IOException {
        if (archiveType == ArchiveType.TAR) {
            return new TarArchiver(file);
        }
        if (archiveType == ArchiveType.TGZ) {
            return new TarArchiver(new GZIPOutputStream(new FileOutputStream(file)));
        }
        if (archiveType == ArchiveType.ZIP) {
            return new ZipArchiver(new FileOutputStream(file));
        }
        if (archiveType == ArchiveType.LZH) {
            return new LzhArchiver(file);
        }
        throw new IllegalStateException(String.valueOf(archiveType));
    }

    public void close() throws IOException {
        this.archiver.close();
    }
}

