/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.ArchiveType;
import jp.sourceforge.armadillo.Expander;
import jp.sourceforge.armadillo.LzhExpander;
import jp.sourceforge.armadillo.TarExpander;
import jp.sourceforge.armadillo.ZipExpander;

public final class FileExpander
implements Expander {
    private Expander expander;

    public FileExpander(File file) throws IOException {
        this(file, ArchiveType.getType(file));
    }

    public FileExpander(File file, ArchiveType archiveType) throws IOException {
        this.expander = FileExpander.getExpander(file, archiveType);
    }

    public Iterator iterator() {
        return new Iterator(){
            private ArchiveEntry entry;

            public boolean hasNext() {
                try {
                    this.entry = FileExpander.this.nextEntry();
                    return !this.entry.isNull();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }

            public Object next() {
                return this.entry;
            }

            public void remove() {
                throw new UnsupportedOperationException("Iterator#remove");
            }
        };
    }

    public boolean setCharsetName(String string) {
        return this.expander.setCharsetName(string);
    }

    public ArchiveEntry nextEntry() throws IOException {
        return this.expander.nextEntry();
    }

    public long expand(OutputStream outputStream) throws IOException {
        return this.expander.expand(outputStream);
    }

    public static Expander getExpander(File file) throws IOException {
        return FileExpander.getExpander(file, ArchiveType.getType(file));
    }

    public static Expander getExpander(File file, ArchiveType archiveType) throws IOException {
        if (archiveType == ArchiveType.TAR) {
            return new TarExpander(new FileInputStream(file));
        }
        if (archiveType == ArchiveType.TGZ) {
            return new TarExpander(new GZIPInputStream(new FileInputStream(file)));
        }
        if (archiveType == ArchiveType.ZIP) {
            return new ZipExpander(file);
        }
        if (archiveType == ArchiveType.LZH) {
            return new LzhExpander(new FileInputStream(file));
        }
        throw new IllegalStateException("File: " + file + ", ArchiverType: " + archiveType);
    }

    public void close() throws IOException {
        this.expander.close();
    }
}

