/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.Archiver;
import jp.sourceforge.armadillo.CharacterEncoding;
import jp.sourceforge.armadillo.Utilities;
import jp.sourceforge.armadillo.io.IOUtilities;
import jp.sourceforge.armadillo.io.VolumetricOutputStream;
import jp.sourceforge.armadillo.lzh.LzhEntry;
import jp.sourceforge.armadillo.lzh.LzhOutputStream;
import jp.sourceforge.armadillo.lzh.LzhQuit;

public final class LzhArchiver
extends CharacterEncoding
implements Archiver {
    private static final byte HEADER_LEVEL = 2;
    private LzhOutputStream los;
    private RandomAccessFile rfile;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LzhArchiver(OutputStream outputStream) {
        this.los = new LzhOutputStream(outputStream instanceof BufferedOutputStream ? outputStream : new BufferedOutputStream(outputStream));
    }

    public LzhArchiver(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        try {
            randomAccessFile.setLength(0L);
            this.los = new LzhOutputStream(Channels.newOutputStream(randomAccessFile.getChannel()));
            this.rfile = randomAccessFile;
        }
        catch (Exception exception) {
            randomAccessFile.close();
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public void addEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        if (file.isDirectory()) {
            this.addDirectoryEntry(archiveEntry);
        } else {
            this.addFileEntry(archiveEntry, file);
        }
        archiveEntry.setAdded(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        if (archiveEntry.isDirectory()) {
            this.addDirectoryEntry(archiveEntry);
        } else {
            File file = IOUtilities.createTemporaryFile();
            if (l > 0L && inputStream != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    IOUtilities.transfer(inputStream, fileOutputStream, l);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            this.addFileEntry(archiveEntry, file);
            file.delete();
        }
        archiveEntry.setAdded(true);
    }

    private void addDirectoryEntry(ArchiveEntry archiveEntry) throws IOException {
        LzhEntry lzhEntry = this.createEntry(archiveEntry);
        lzhEntry.setHeaderLevel((byte)2);
        lzhEntry.setMethod("-lhd-");
        lzhEntry.setCrc((short)0);
        lzhEntry.setSize(0L);
        lzhEntry.setCompressedSize(0L);
        this.los.putNextEntry(lzhEntry);
        this.los.closeEntry();
        archiveEntry.crc = 0L;
        archiveEntry.size = 0L;
        archiveEntry.compressedSize = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        LzhEntry lzhEntry = this.createEntry(archiveEntry);
        lzhEntry.setHeaderLevel((byte)2);
        lzhEntry.setOsIdentifier('J');
        long l = file.length();
        if (l > 0L) {
            lzhEntry.setMethod("-lh5-");
            lzhEntry.setSize(l);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            try {
                long l2;
                if (this.rfile == null) {
                    FileChannel fileChannel = randomAccessFile.getChannel();
                    try {
                        LzhArchiver.tryOut(lzhEntry, fileChannel);
                        if (lzhEntry.getCompressedSize() >= l) {
                            lzhEntry.setMethod("-lh0-");
                        }
                    }
                    catch (LzhQuit lzhQuit) {
                        lzhEntry.setMethod("-lh0-");
                    }
                    this.los.putNextEntry(lzhEntry);
                    l2 = fileChannel.transferTo(0L, l, Channels.newChannel(this.los));
                    if (!$assertionsDisabled && l2 != l) {
                        throw new AssertionError();
                    }
                    this.los.closeEntry();
                } else {
                    boolean bl;
                    this.los.flush();
                    long l3 = this.rfile.getFilePointer();
                    if (!$assertionsDisabled && lzhEntry.getCompressedSize() != 0L) {
                        throw new AssertionError();
                    }
                    this.los.putNextEntry(lzhEntry);
                    long l4 = this.rfile.getFilePointer();
                    try {
                        WritableByteChannel writableByteChannel = Channels.newChannel(this.los);
                        l2 = randomAccessFile.getChannel().transferTo(0L, l, writableByteChannel);
                        bl = false;
                        if (!$assertionsDisabled && l2 != l) {
                            throw new AssertionError();
                        }
                    }
                    catch (LzhQuit lzhQuit) {
                        l2 = 0L;
                        bl = true;
                    }
                    this.los.closeEntry();
                    lzhEntry.setCrc(this.los.getCrc());
                    long l5 = this.rfile.getFilePointer();
                    long l6 = l5 - l4;
                    this.rfile.seek(l3);
                    if (l6 >= l || bl) {
                        lzhEntry.setMethod("-lh0-");
                        lzhEntry.setCompressedSize(l);
                        FileChannel fileChannel = this.rfile.getChannel();
                        this.los.writeHeader(lzhEntry, Channels.newOutputStream(fileChannel));
                        l2 = randomAccessFile.getChannel().transferTo(0L, l, fileChannel);
                        this.rfile.setLength(this.rfile.getFilePointer());
                        if (!$assertionsDisabled && l2 != l) {
                            throw new AssertionError();
                        }
                    } else {
                        lzhEntry.setCompressedSize(l5 - l3);
                        this.los.writeHeader(lzhEntry, Channels.newOutputStream(this.rfile.getChannel()));
                        this.rfile.seek(l5);
                    }
                }
                if (!$assertionsDisabled && l2 != l) {
                    throw new AssertionError();
                }
                archiveEntry.crc = lzhEntry.getCrc();
                archiveEntry.size = lzhEntry.getSize();
                archiveEntry.compressedSize = lzhEntry.getCompressedSize();
            }
            finally {
                randomAccessFile.close();
            }
        }
        this.los.putNextEntry(lzhEntry);
        this.los.closeEntry();
        archiveEntry.crc = 0L;
        archiveEntry.size = 0L;
        archiveEntry.compressedSize = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryOut(LzhEntry lzhEntry, FileChannel fileChannel) throws IOException {
        VolumetricOutputStream volumetricOutputStream = new VolumetricOutputStream();
        LzhOutputStream lzhOutputStream = new LzhOutputStream(volumetricOutputStream);
        try {
            lzhOutputStream.putNextEntry(lzhEntry);
            fileChannel.transferTo(0L, Long.MAX_VALUE, Channels.newChannel(lzhOutputStream));
            lzhOutputStream.closeEntry();
        }
        finally {
            lzhOutputStream.close();
        }
        lzhEntry.setCrc(lzhOutputStream.getCrc());
        lzhEntry.setCompressedSize(volumetricOutputStream.getSize() - 1L);
    }

    private LzhEntry createEntry(ArchiveEntry archiveEntry) {
        String string = archiveEntry.name;
        LzhEntry lzhEntry = new LzhEntry(string);
        if (this.usesEncoding) {
            lzhEntry.setNameAsBytes(this.encode(string));
        }
        long l = archiveEntry.lastModified;
        lzhEntry.setFTime(Utilities.FTime.convert(l));
        lzhEntry.setTimeT(Utilities.TimeT.convert(l));
        lzhEntry.setFileTime(Utilities.FILETIME.convert(l));
        return lzhEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.los.close();
        }
        finally {
            if (this.rfile != null) {
                this.rfile.close();
            }
        }
    }

    static {
        $assertionsDisabled = !LzhArchiver.class.desiredAssertionStatus();
    }
}

