/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.CharacterEncoding;
import jp.sourceforge.armadillo.Expander;
import jp.sourceforge.armadillo.Utilities;
import jp.sourceforge.armadillo.io.IOUtilities;
import jp.sourceforge.armadillo.lzh.LzhEntry;
import jp.sourceforge.armadillo.lzh.LzhInputStream;

public final class LzhExpander
extends CharacterEncoding
implements Expander {
    private LzhInputStream lis;

    public LzhExpander(InputStream inputStream) {
        this.lis = new LzhInputStream(inputStream);
    }

    public ArchiveEntry nextEntry() throws IOException {
        LzhEntry lzhEntry = this.lis.getNextEntry();
        if (lzhEntry == null) {
            return ArchiveEntry.NULL;
        }
        ArchiveEntry archiveEntry = new ArchiveEntry(lzhEntry.getName());
        archiveEntry.method = lzhEntry.getMethod();
        archiveEntry.lastModified = this.getFileTimestamp(lzhEntry);
        archiveEntry.size = lzhEntry.getSize();
        archiveEntry.compressedSize = lzhEntry.getCompressedSize();
        archiveEntry.crc = lzhEntry.getCrc();
        return archiveEntry;
    }

    private long getFileTimestamp(LzhEntry lzhEntry) {
        if (lzhEntry.getFileTime() > 0L) {
            return Utilities.FILETIME.toMillisecond(lzhEntry.getFileTime());
        }
        if (lzhEntry.getTimeT() > 0) {
            return Utilities.TimeT.toMillisecond(lzhEntry.getTimeT());
        }
        return Utilities.FTime.toMillisecond(lzhEntry.getFTime());
    }

    public long expand(OutputStream outputStream) throws IOException {
        return IOUtilities.transferAll(this.lis, outputStream);
    }

    public void close() throws IOException {
        this.lis.close();
    }
}

