/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

final class OptionParser {
    private final List optionList;

    OptionParser(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            char[] cArray;
            String string = stringArray[i];
            if (i == 0) {
                cArray = string.toCharArray();
                for (n = 0; n < cArray.length; ++n) {
                    char c = cArray[n];
                    if (c == '-') continue;
                    arrayList.add("-" + c);
                }
                continue;
            }
            if (string.matches("^-[^-]*")) {
                cArray = string.toCharArray();
                for (n = 1; n < cArray.length; ++n) {
                    arrayList.add("-" + cArray[n]);
                }
                continue;
            }
            arrayList.add(string);
        }
        this.optionList = arrayList;
    }

    String[] getRest() {
        return this.optionList.toArray(new String[this.optionList.size()]);
    }

    char parseMode() throws ParseException {
        int n = -1;
        int n2 = this.optionList.size();
        for (int i = 0; i < n2; ++i) {
            String string = (String)this.optionList.get(i);
            if (!string.matches("-[ctx]")) continue;
            if (n >= 0) {
                Object e = this.optionList.get(n);
                throw new ParseException("ambiguios mode: " + e + ", " + string, n);
            }
            n = i;
        }
        if (n >= 0) {
            return ((String)this.optionList.remove(n)).charAt(1);
        }
        throw new ParseException("armadillo requires mode option (-c, -x, -t)", n);
    }

    File parseArchiveFile() throws ParseException {
        int n = this.optionList.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            String string = (String)this.optionList.get(i);
            if (!string.equals("-f")) continue;
            if (n2 >= 0) {
                throw new ParseException("duplicated option: " + string, n2);
            }
            n2 = i;
        }
        if (n2 >= 0 && n2 < n - 1) {
            String string = (String)this.optionList.remove(n2 + 1);
            this.optionList.remove(n2);
            return new File(string);
        }
        throw new ParseException("no archive-file parameter", n2);
    }

    boolean parseVerbose() throws ParseException {
        int n = -1;
        int n2 = this.optionList.size();
        for (int i = 0; i < n2; ++i) {
            String string = (String)this.optionList.get(i);
            if (!string.equals("-v")) continue;
            if (n >= 0) {
                throw new ParseException("duplicated option: " + string, n);
            }
            n = i;
        }
        if (n >= 0) {
            this.optionList.remove(n);
            return true;
        }
        return false;
    }

    String parseOutputDirectory() throws ParseException {
        int n = this.optionList.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            String string = (String)this.optionList.get(i);
            if (!string.equals("-d")) continue;
            if (n2 >= 0) {
                throw new ParseException("duplicated option: " + string, n2);
            }
            n2 = i;
        }
        if (n2 < 0) {
            return "";
        }
        if (n2 < n - 1) {
            String string = (String)this.optionList.remove(n2 + 1);
            this.optionList.remove(n2);
            return string;
        }
        throw new ParseException("no archive-file parameter", n2);
    }

    public String toString() {
        return this.optionList.toString();
    }
}

