/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.Archiver;
import jp.sourceforge.armadillo.CharacterEncoding;
import jp.sourceforge.armadillo.Utilities;
import jp.sourceforge.armadillo.io.IOUtilities;
import jp.sourceforge.armadillo.tar.TarEntry;
import jp.sourceforge.armadillo.tar.TarOutputStream;

public final class TarArchiver
extends CharacterEncoding
implements Archiver {
    private TarOutputStream tos;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TarArchiver(OutputStream outputStream) {
        this.tos = new TarOutputStream(outputStream);
    }

    public TarArchiver(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        if (file.isDirectory()) {
            this.addDirectoryEntry(archiveEntry);
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                archiveEntry.size = file.length();
                this.addFileEntry(archiveEntry, fileInputStream);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        archiveEntry.setAdded(true);
    }

    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        if (archiveEntry.isDirectory()) {
            this.addDirectoryEntry(archiveEntry);
        } else {
            archiveEntry.size = l;
            this.addFileEntry(archiveEntry, inputStream);
        }
        archiveEntry.setAdded(true);
    }

    private void addDirectoryEntry(ArchiveEntry archiveEntry) throws IOException {
        TarEntry tarEntry = this.createEntry(archiveEntry);
        tarEntry.setMode(0);
        this.tos.putNextEntry(tarEntry);
        this.tos.closeEntry();
        archiveEntry.crc = 0L;
        archiveEntry.size = 0L;
        archiveEntry.compressedSize = 0L;
    }

    private void addFileEntry(ArchiveEntry archiveEntry, InputStream inputStream) throws IOException {
        TarEntry tarEntry = this.createEntry(archiveEntry);
        tarEntry.setSize(archiveEntry.size);
        this.tos.putNextEntry(tarEntry);
        long l = IOUtilities.transferAll(inputStream, this.tos);
        tarEntry.setSize(l);
        this.tos.closeEntry();
        if (!$assertionsDisabled && l != archiveEntry.size) {
            throw new AssertionError((Object)"file size");
        }
        if (!$assertionsDisabled && tarEntry.getSize() != archiveEntry.size) {
            throw new AssertionError((Object)"file size");
        }
        archiveEntry.crc = 0L;
        archiveEntry.size = l;
        archiveEntry.compressedSize = l;
    }

    private TarEntry createEntry(ArchiveEntry archiveEntry) {
        String string = archiveEntry.name;
        TarEntry tarEntry = new TarEntry(string);
        if (this.usesEncoding) {
            tarEntry.setNameAsBytes(this.encode(string));
        }
        tarEntry.setTimeT(Utilities.TimeT.convert(archiveEntry.lastModified));
        return tarEntry;
    }

    public void close() throws IOException {
        this.tos.close();
    }

    static {
        $assertionsDisabled = !TarArchiver.class.desiredAssertionStatus();
    }
}

