/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Calendar;

public final class Utilities {
    private Utilities() {
    }

    public static String getEntryName(File file) {
        String string = file.getPath().replace('\\', '/');
        if (file.isDirectory() && !string.endsWith(String.valueOf('/'))) {
            string = string + '/';
        }
        return string;
    }

    public static String getInput() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        return bufferedReader.readLine();
    }

    public static final class WindowsTime {
        private WindowsTime() {
        }

        public static long toMilliSeconds(long l) {
            return ((l >>> 1) - 58222368000000000L) / 5000L;
        }
    }

    public static final class DosTime {
        private DosTime() {
        }

        public static int getValue(long l) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l);
            return calendar.get(1) - 1980 << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) / 2;
        }

        public static long toMilliSeconds(int n) {
            int n2 = (n >>> 25 & 0x7F) + 1980;
            int n3 = n >>> 21 & 0xF;
            int n4 = n >>> 16 & 0x1F;
            int n5 = n >>> 11 & 0x1F;
            int n6 = n >>> 5 & 0x3F;
            int n7 = (n & 0x1F) * 2;
            Calendar calendar = Calendar.getInstance();
            calendar.set(n2, n3 - 1, n4, n5, n6, n7);
            return calendar.getTimeInMillis();
        }
    }

    public static final class FILETIME {
        private static final long DIFFERENCE = 116444736000000000L;

        private FILETIME() {
        }

        public static long convert(long l) {
            return l * 10000L + 116444736000000000L;
        }

        public static long toMillisecond(long l) {
            return (l - 116444736000000000L) / 10000L;
        }
    }

    public static final class FTime {
        private FTime() {
        }

        public static int convert(long l) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l);
            return calendar.get(1) - 1980 << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) / 2;
        }

        public static long toMillisecond(int n) {
            int n2 = (n >>> 25 & 0x7F) + 1980;
            int n3 = n >>> 21 & 0xF;
            int n4 = n >>> 16 & 0x1F;
            int n5 = n >>> 11 & 0x1F;
            int n6 = n >>> 5 & 0x3F;
            int n7 = (n & 0x1F) * 2;
            Calendar calendar = Calendar.getInstance();
            calendar.set(n2, n3 - 1, n4, n5, n6, n7);
            return calendar.getTimeInMillis();
        }
    }

    public static final class TimeT {
        private TimeT() {
        }

        public static int convert(long l) {
            return (int)(l / 1000L & 0xFFFFFFFFFFFFFFFFL);
        }

        public static long toMillisecond(int n) {
            return (long)n * 1000L;
        }
    }
}

