/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.Archiver;
import jp.sourceforge.armadillo.CharacterEncoding;
import jp.sourceforge.armadillo.Utilities;
import jp.sourceforge.armadillo.io.IOUtilities;
import jp.sourceforge.armadillo.io.VolumetricOutputStream;
import jp.sourceforge.armadillo.zip.ZipEntry;
import jp.sourceforge.armadillo.zip.ZipOutputStream;

public final class ZipArchiver
extends CharacterEncoding
implements Archiver {
    private ZipOutputStream zos;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZipArchiver(OutputStream outputStream) {
        this.zos = new ZipOutputStream(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        long l = file.length();
        if (file.isDirectory()) {
            this.addDirectoryEntry(archiveEntry);
        } else {
            archiveEntry.size = l;
            if (l > 0L) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                try {
                    FileChannel fileChannel = randomAccessFile.getChannel();
                    InputStream inputStream = Channels.newInputStream(fileChannel);
                    ArchiveEntry archiveEntry2 = new ArchiveEntry(archiveEntry.name);
                    this.tryOut(archiveEntry2, inputStream);
                    archiveEntry.crc = archiveEntry2.crc;
                    long l2 = archiveEntry2.compressedSize;
                    fileChannel.position(0L);
                    archiveEntry.compressedSize = l2 < l ? l2 : l;
                    this.addFileEntry(archiveEntry, inputStream);
                }
                finally {
                    randomAccessFile.close();
                }
            } else {
                this.addFileEntry(archiveEntry, null);
            }
        }
        archiveEntry.setAdded(true);
    }

    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        if (archiveEntry.isDirectory()) {
            this.addDirectoryEntry(archiveEntry);
        } else {
            archiveEntry.size = l;
            this.addFileEntry(archiveEntry, inputStream);
        }
        archiveEntry.setAdded(true);
    }

    private void addDirectoryEntry(ArchiveEntry archiveEntry) throws IOException {
        ZipEntry zipEntry = this.createEntry(archiveEntry);
        zipEntry.setMethod(0);
        zipEntry.setCrc(0L);
        zipEntry.setSize(0L);
        zipEntry.setCompressedSize(0L);
        zipEntry.setFTime(Utilities.TimeT.convert(archiveEntry.lastModified));
        this.zos.putNextEntry(zipEntry);
        this.zos.closeEntry();
    }

    private void addFileEntry(ArchiveEntry archiveEntry, InputStream inputStream) throws IOException {
        long l = archiveEntry.size;
        long l2 = archiveEntry.compressedSize;
        ZipEntry zipEntry = this.createEntry(archiveEntry);
        if (l2 <= 0L) {
            zipEntry.setOption((short)8);
        }
        if (l2 > 0L && l2 < l) {
            zipEntry.setMethod(8);
        } else {
            zipEntry.setMethod(0);
        }
        zipEntry.setCrc(archiveEntry.crc);
        zipEntry.setSize(l);
        zipEntry.setCompressedSize(archiveEntry.compressedSize);
        this.zos.putNextEntry(zipEntry);
        long l3 = 0L;
        if (l > 0L) {
            l3 = IOUtilities.transferAll(inputStream, this.zos);
        }
        this.zos.closeEntry();
        if (!$assertionsDisabled && l3 != l) {
            throw new AssertionError((Object)"file size");
        }
        if (!$assertionsDisabled && zipEntry.getSize() != l) {
            throw new AssertionError((Object)"file size");
        }
        if (!$assertionsDisabled && zipEntry.getCompressedSize() != l2) {
            throw new AssertionError((Object)"comp size");
        }
        archiveEntry.crc = zipEntry.getCrc();
        archiveEntry.size = l3;
        archiveEntry.compressedSize = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryOut(ArchiveEntry archiveEntry, InputStream inputStream) throws IOException {
        ZipEntry zipEntry = this.createEntry(archiveEntry);
        VolumetricOutputStream volumetricOutputStream = new VolumetricOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(volumetricOutputStream);
        try {
            zipEntry.setOption((short)8);
            zipEntry.setMethod(8);
            zipOutputStream.putNextEntry(zipEntry);
            IOUtilities.transferAll(inputStream, zipOutputStream);
            zipOutputStream.closeEntry();
        }
        finally {
            zipOutputStream.close();
        }
        if (!$assertionsDisabled && zipEntry.getCompressedSize() != volumetricOutputStream.getSize()) {
            throw new AssertionError();
        }
        archiveEntry.crc = zipEntry.getCrc();
        archiveEntry.size = zipEntry.getSize();
        archiveEntry.compressedSize = zipEntry.getCompressedSize();
    }

    private ZipEntry createEntry(ArchiveEntry archiveEntry) {
        String string = archiveEntry.name;
        ZipEntry zipEntry = new ZipEntry(string);
        if (this.usesEncoding) {
            zipEntry.setNameAsBytes(this.encode(string));
        }
        zipEntry.setFTime(Utilities.FTime.convert(archiveEntry.lastModified));
        return zipEntry;
    }

    public void close() throws IOException {
        this.zos.close();
    }

    static {
        $assertionsDisabled = !ZipArchiver.class.desiredAssertionStatus();
    }
}

