/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BitInputStream
extends FilterInputStream {
    private static final int INT_BITSIZE = 32;
    private static final int INPUT_BITSIZE = 8;
    private boolean closed = false;
    private int buffer = 0;
    private int remaining = 0;
    private boolean eof = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BitInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    public int readBits(int n) throws IOException {
        this.ensureOpen();
        if (n < 1 || 32 < n) {
            throw new IllegalArgumentException("bit length: " + n);
        }
        if (this.remaining < n) {
            this.fillBuffer(n);
            if (this.remaining == 0) {
                return -1;
            }
            if (this.remaining < n) {
                throw new IOException("requred=" + n + ", remaining=" + this.remaining);
            }
        }
        int n2 = this.buffer >>> 32 - n;
        this.remaining -= n;
        this.buffer <<= n;
        return n2;
    }

    public int readBit() throws IOException {
        return this.readBits(1);
    }

    public int prefetchBits(int n) throws IOException {
        this.ensureOpen();
        if (n > 32) {
            throw new IllegalArgumentException("overflow: " + n);
        }
        if (this.remaining < n) {
            this.fillBuffer(n);
        }
        return this.buffer >>> 32 - n;
    }

    public int prefetch() throws IOException {
        return this.prefetchBits(8);
    }

    private void fillBuffer(int n) throws IOException {
        if (!($assertionsDisabled || n >= 1 && n <= 32)) {
            throw new AssertionError();
        }
        int n2 = 0;
        while (!this.eof && this.remaining < n) {
            int n3 = super.read();
            if (n3 == -1) {
                this.eof = true;
                return;
            }
            if (!$assertionsDisabled && (this.buffer | (n3 <<= 24 - this.remaining)) != this.buffer + n3) {
                throw new AssertionError();
            }
            this.buffer |= n3;
            this.remaining += 8;
            n2 += 8;
        }
    }

    public void clearBuffer() {
        this.buffer = 0;
        this.remaining = 0;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public int getRemaining() {
        return this.remaining;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public int read() throws IOException {
        return this.readBits(8);
    }

    public void close() throws IOException {
        this.ensureOpen();
        this.closed = true;
        super.close();
    }

    static {
        $assertionsDisabled = !BitInputStream.class.desiredAssertionStatus();
    }
}

