/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import jp.sourceforge.armadillo.lzh.CRC16;
import jp.sourceforge.armadillo.lzh.LzhEntry;
import jp.sourceforge.armadillo.lzh.LzhException;
import jp.sourceforge.armadillo.lzh.LzhMethod;

public final class LzhHeader {
    public static final byte HEADER_LEVEL_0 = 0;
    public static final byte HEADER_LEVEL_1 = 1;
    public static final byte HEADER_LEVEL_2 = 2;
    private static final int BUFFER_SIZE = 1024;
    private static final int LEVEL_OFFSET = 20;
    private static final byte FILETYPE_FILE = 32;
    private static final byte PLATFORM_JAVA = 74;
    private static final byte PATH_DELIMITER = -1;
    private static final String ISO_8859_1 = "iso-8859-1";
    private static final String ERROR_PREFIX = "invalid header: ";
    private ByteBuffer buffer = ByteBuffer.allocate(1024).order(ByteOrder.LITTLE_ENDIAN);
    static final /* synthetic */ boolean $assertionsDisabled;

    public LzhEntry read(InputStream inputStream) throws IOException {
        LzhEntry lzhEntry;
        int n;
        this.buffer.clear();
        this.buffer.limit(21);
        Channels.newChannel(inputStream).read(this.buffer);
        int n2 = this.buffer.position();
        if (n2 == 0 || n2 == 1 && this.buffer.get(0) == 0 || n2 <= 21 && this.buffer.getShort(0) == 0) {
            return null;
        }
        if (n2 != 21) {
            return null;
        }
        byte by = this.buffer.get(20);
        this.buffer.rewind();
        switch (by) {
            case 0: 
            case 1: {
                n = (this.buffer.get() & 0xFF) + 2;
                break;
            }
            case 2: {
                n = this.buffer.getShort() & 0xFFFF;
                break;
            }
            default: {
                throw new LzhException("unsupported header level (=" + by + ")");
            }
        }
        if (n == 0) {
            return null;
        }
        if (!($assertionsDisabled || n >= 0 && n < 1024)) {
            throw new AssertionError((Object)("header length = " + n));
        }
        this.buffer.limit(n);
        this.buffer.position(21);
        Channels.newChannel(inputStream).read(this.buffer);
        if (this.buffer.position() != n) {
            throw new LzhException("invalid header: header length = " + n);
        }
        switch (by) {
            case 0: {
                lzhEntry = this.readLevel0();
                break;
            }
            case 1: {
                lzhEntry = this.readLevel1(inputStream);
                break;
            }
            case 2: {
                lzhEntry = this.readLevel2();
                break;
            }
            default: {
                throw new IllegalStateException("unexpected state");
            }
        }
        if (!$assertionsDisabled && lzhEntry.headerLength != n) {
            throw new AssertionError();
        }
        if (!lzhEntry.directory && (lzhEntry.name.endsWith("/") || lzhEntry.getMethod().equals("-lhd-"))) {
            lzhEntry.directory = true;
        }
        return lzhEntry;
    }

    private LzhEntry readLevel0() throws LzhException {
        this.buffer.position(0);
        LzhEntry lzhEntry = new LzhEntry();
        lzhEntry.headerLength = (this.buffer.get() & 0xFF) + 2;
        lzhEntry.checksum = this.buffer.get() & 0xFF;
        lzhEntry.calculatedChecksum = this.calculateChecksum(2, this.buffer.limit());
        lzhEntry.method = new String(this.getBytes(5));
        lzhEntry.compressedSize = this.buffer.getInt();
        lzhEntry.size = this.buffer.getInt();
        lzhEntry.ftime = this.buffer.getInt();
        lzhEntry.type = this.buffer.get();
        lzhEntry.headerLevel = this.buffer.get();
        if (!$assertionsDisabled && lzhEntry.headerLevel != 0) {
            throw new AssertionError();
        }
        int n = this.buffer.get() & 0xFF;
        byte[] byArray = this.getBytes(n);
        lzhEntry.name = new String(byArray);
        lzhEntry.nameAsBytes = byArray;
        if (this.buffer.limit() > this.buffer.position() + 2) {
            lzhEntry.crc = this.buffer.getShort();
        } else if (this.buffer.limit() > this.buffer.position() + 1) {
            lzhEntry.crc = this.buffer.get();
        }
        return lzhEntry;
    }

    private LzhEntry readLevel1(InputStream inputStream) throws IOException {
        this.buffer.position(0);
        LzhEntry lzhEntry = new LzhEntry();
        lzhEntry.headerLength = (this.buffer.get() & 0xFF) + 2;
        lzhEntry.checksum = this.buffer.get() & 0xFF;
        lzhEntry.calculatedChecksum = this.calculateChecksum(2, this.buffer.limit());
        lzhEntry.method = new String(this.getBytes(5));
        int n = this.buffer.getInt();
        lzhEntry.size = this.buffer.getInt();
        lzhEntry.ftime = this.buffer.getInt();
        byte by = this.buffer.get();
        if (!$assertionsDisabled && by != 32) {
            throw new AssertionError();
        }
        lzhEntry.headerLevel = this.buffer.get();
        if (!$assertionsDisabled && lzhEntry.headerLevel != 1) {
            throw new AssertionError();
        }
        int n2 = this.buffer.get() & 0xFF;
        byte[] byArray = this.getBytes(n2);
        lzhEntry.name = new String(byArray);
        lzhEntry.nameAsBytes = byArray;
        lzhEntry.crc = this.buffer.getShort();
        lzhEntry.type = this.buffer.get();
        int n3 = 0;
        lzhEntry.compressedSize = n - n3;
        return lzhEntry;
    }

    private LzhEntry readLevel2() throws IOException {
        this.buffer.position(0);
        LzhEntry lzhEntry = new LzhEntry();
        lzhEntry.headerLength = this.buffer.getShort();
        lzhEntry.method = new String(this.getBytes(5));
        lzhEntry.compressedSize = this.buffer.getInt();
        lzhEntry.size = this.buffer.getInt();
        lzhEntry.timeT = this.buffer.getInt();
        byte by = this.buffer.get();
        if (!$assertionsDisabled && by != 32) {
            throw new AssertionError();
        }
        lzhEntry.headerLevel = this.buffer.get();
        if (!$assertionsDisabled && lzhEntry.headerLevel != 2) {
            throw new AssertionError();
        }
        lzhEntry.crc = this.buffer.getShort();
        lzhEntry.osIdentifier = (char)this.buffer.get();
        int n = 0;
        short s = 0;
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((s = this.buffer.getShort()) > 0) {
            int n2 = s - 3;
            byte by2 = this.buffer.get();
            this.buffer.mark();
            switch (by2) {
                case 0: {
                    this.buffer.getShort();
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(this.nextPath(n2));
                    bl = false;
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(this.nextPath(n2));
                    bl = true;
                    break;
                }
                case 57: {
                    ++n;
                    break;
                }
                case 65: {
                    this.buffer.getLong();
                    lzhEntry.fileTime = this.buffer.getLong();
                    this.buffer.getLong();
                    break;
                }
                case 66: {
                    lzhEntry.compressedSize = this.buffer.getLong();
                    lzhEntry.size = this.buffer.getLong();
                    break;
                }
                case 84: {
                    lzhEntry.timeT = this.buffer.get();
                    break;
                }
            }
            this.buffer.reset();
            this.buffer.position(this.buffer.position() + n2);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        lzhEntry.name = new String(byArray);
        lzhEntry.nameAsBytes = byArray;
        lzhEntry.directory = bl;
        if (!$assertionsDisabled && n != 0) {
            throw new AssertionError();
        }
        return lzhEntry;
    }

    public void write(OutputStream outputStream, LzhEntry lzhEntry) throws IOException {
        if (!lzhEntry.method.matches("-l[hz][a-z0-9]-")) {
            throw new LzhException("invalid compression type: " + lzhEntry.method);
        }
        if (lzhEntry.compressedSize > Integer.MAX_VALUE) {
            throw new LzhException("too large compressed size: " + lzhEntry.compressedSize);
        }
        if (lzhEntry.size > Integer.MAX_VALUE) {
            throw new LzhException("too large size: " + lzhEntry.size);
        }
        this.buffer.clear();
        switch (lzhEntry.headerLevel) {
            case 0: {
                this.writeLevel0(lzhEntry);
                break;
            }
            case 1: {
                this.writeLevel1(lzhEntry);
                break;
            }
            case 2: {
                this.writeLevel2(lzhEntry);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid header: header-level=" + lzhEntry.headerLevel);
            }
        }
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
    }

    private void writeLevel0(LzhEntry lzhEntry) throws IOException {
        int n;
        if (!($assertionsDisabled || lzhEntry.compressedSize >= 0L && lzhEntry.compressedSize <= Integer.MAX_VALUE)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || lzhEntry.size >= 0L && lzhEntry.size <= Integer.MAX_VALUE)) {
            throw new AssertionError();
        }
        byte[] byArray = this.getNameAsByte(lzhEntry);
        byte by = (byte)(byArray.length & 0xFF);
        this.buffer.position(2);
        this.buffer.put(lzhEntry.method.getBytes(ISO_8859_1));
        this.buffer.putInt(0);
        this.buffer.putInt((int)lzhEntry.size);
        this.buffer.putInt(lzhEntry.ftime);
        this.buffer.put((byte)32);
        this.buffer.put((byte)0);
        this.buffer.put(by);
        this.buffer.put(byArray);
        this.buffer.putShort(lzhEntry.crc);
        int n2 = n = this.buffer.position();
        if (!($assertionsDisabled || n2 >= 20 && n2 < 256)) {
            throw new AssertionError();
        }
        this.buffer.put(0, (byte)(n2 - 2));
        if (lzhEntry.compressedSize > 0L) {
            this.buffer.putInt(7, LzhHeader.calculateSkipSize(lzhEntry, n2, 0));
        }
        int n3 = this.calculateChecksum(2, n);
        this.buffer.put(1, (byte)(n3 & 0xFF));
    }

    private void writeLevel1(LzhEntry lzhEntry) throws IOException {
        int n;
        if (!($assertionsDisabled || lzhEntry.compressedSize >= 0L && lzhEntry.compressedSize <= Integer.MAX_VALUE)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || lzhEntry.size >= 0L && lzhEntry.size <= Integer.MAX_VALUE)) {
            throw new AssertionError();
        }
        byte[] byArray = this.getNameAsByte(lzhEntry);
        byte by = (byte)(byArray.length & 0xFF);
        this.buffer.position(2);
        this.buffer.put(lzhEntry.method.getBytes(ISO_8859_1));
        this.buffer.putInt(0);
        this.buffer.putInt((int)lzhEntry.size);
        this.buffer.putInt(lzhEntry.ftime);
        this.buffer.put((byte)32);
        this.buffer.put((byte)1);
        this.buffer.put(by);
        this.buffer.put(byArray);
        this.buffer.putShort(lzhEntry.crc);
        this.buffer.put((byte)74);
        this.buffer.putShort((short)0);
        this.buffer.put((byte)0);
        int n2 = n = this.buffer.position();
        if (!($assertionsDisabled || n2 >= 20 && n2 < 256)) {
            throw new AssertionError();
        }
        this.buffer.put(0, (byte)(n2 - 2));
        if (lzhEntry.compressedSize > 0L) {
            this.buffer.putInt(7, LzhHeader.calculateSkipSize(lzhEntry, n2, 0));
        }
        int n3 = this.calculateChecksum(2, n);
        this.buffer.put(1, (byte)(n3 & 0xFF));
    }

    private void writeLevel2(LzhEntry lzhEntry) throws IOException {
        int n;
        int n2;
        if (!($assertionsDisabled || lzhEntry.compressedSize >= 0L && lzhEntry.compressedSize <= Integer.MAX_VALUE)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || lzhEntry.size >= 0L && lzhEntry.size <= Integer.MAX_VALUE)) {
            throw new AssertionError();
        }
        this.buffer.position(2);
        this.buffer.put(lzhEntry.method.getBytes(ISO_8859_1));
        this.buffer.putInt(0);
        this.buffer.putInt((int)lzhEntry.size);
        this.buffer.putInt(lzhEntry.timeT);
        this.buffer.put((byte)32);
        this.buffer.put((byte)2);
        this.buffer.putShort(lzhEntry.crc);
        this.buffer.put((byte)74);
        byte[] byArray = this.getNameAsByte(lzhEntry);
        int n3 = 0;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            n = byArray[n2];
            if (n != 47 && n != 92) continue;
            byArray[n2] = -1;
            n3 = n2;
        }
        n2 = n3 + 1;
        this.buffer.putShort((short)5);
        this.buffer.put((byte)0);
        n = this.buffer.position();
        this.buffer.putShort((short)0);
        this.buffer.putShort((short)(n2 + 3));
        this.buffer.put((byte)2);
        this.buffer.put(byArray, 0, n2);
        int n4 = byArray.length - n2;
        this.buffer.putShort((short)(n4 + 3));
        this.buffer.put((byte)1);
        this.buffer.put(byArray, n2, n4);
        this.buffer.putShort((short)0);
        short s = 0;
        s = (short)(s + this.buffer.position());
        if (s % 256 == 0) {
            this.buffer.put((byte)0);
            s = (short)(s + 1);
        }
        this.buffer.putShort(0, s);
        if (lzhEntry.compressedSize > 0L) {
            this.buffer.putInt(7, LzhHeader.calculateSkipSize(lzhEntry, s, 0));
        }
        CRC16 cRC16 = new CRC16();
        cRC16.reset();
        cRC16.update(this.buffer.array(), 0, s);
        this.buffer.putShort(n, cRC16.getShortValue());
    }

    private int calculateChecksum(int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 += this.buffer.get(i);
        }
        return n3;
    }

    private static int calculateSkipSize(LzhEntry lzhEntry, int n, int n2) throws LzhException {
        if (!($assertionsDisabled || lzhEntry.compressedSize >= 0L && lzhEntry.compressedSize <= Integer.MAX_VALUE)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || lzhEntry.size >= 0L && lzhEntry.size <= Integer.MAX_VALUE)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || n >= 0 && n2 >= 0)) {
            throw new AssertionError();
        }
        int n3 = 0;
        if (LzhMethod.isCompressing(lzhEntry.getMethod())) {
            n3 = (int)((long)n3 + lzhEntry.compressedSize);
            n3 -= n;
        } else {
            n3 = (int)((long)n3 + lzhEntry.size);
        }
        if (!$assertionsDisabled && (n3 += n2) < 0) {
            throw new AssertionError((Object)("skip size = " + n3));
        }
        return n3;
    }

    private byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.buffer.get();
        }
        return byArray;
    }

    private byte[] nextPath(int n) {
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFFFFFFFF) != -1) continue;
            byArray[i] = 47;
        }
        return byArray;
    }

    private byte[] getNameAsByte(LzhEntry lzhEntry) {
        if (lzhEntry.nameAsBytes == null) {
            lzhEntry.nameAsBytes = lzhEntry.name.getBytes();
        }
        return (byte[])lzhEntry.nameAsBytes.clone();
    }

    static {
        $assertionsDisabled = !LzhHeader.class.desiredAssertionStatus();
    }
}

