/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.armadillo.io.BitInputStream;
import jp.sourceforge.armadillo.lzh.LzhException;
import jp.sourceforge.armadillo.lzh.LzssDecoderReadable;

final class LzhHuffmanDecoder
implements LzssDecoderReadable {
    private static final int WORK_TABLE_BITLENGTH = 17;
    private BitInputStream bin;
    private int blockSize;
    private int symbolMaxBitLength;
    private short[] symbolLengthTable;
    private short[] symbolCodeTable;
    private int offsetMaxBitLength;
    private short[] offsetLengthTable;
    private short[] offsetCodeTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LzhHuffmanDecoder(InputStream inputStream) {
        this(inputStream, -1L);
    }

    public LzhHuffmanDecoder(final InputStream inputStream, final long l) {
        this.bin = l < 0L ? new BitInputStream(inputStream) : new BitInputStream(new InputStream(){
            private long remaining;
            {
                this.remaining = l;
            }

            public int read() throws IOException {
                if (this.remaining <= 0L) {
                    return -1;
                }
                int n = inputStream.read();
                if (n != -1) {
                    --this.remaining;
                }
                return n;
            }
        });
        this.blockSize = 0;
    }

    public int read() throws IOException {
        try {
            int n;
            if (!$assertionsDisabled && this.blockSize < 0) {
                throw new AssertionError();
            }
            if (this.blockSize == 0) {
                if (this.bin.prefetch() == -1) {
                    return -1;
                }
                n = this.bin.readBits(16);
                if (n == -1) {
                    return -1;
                }
                this.blockSize = n;
                if (!$assertionsDisabled && this.blockSize <= 0) {
                    throw new AssertionError((Object)("block size = " + this.blockSize));
                }
                this.createSymbolTables();
                this.createOffsetTables();
            }
            --this.blockSize;
            n = this.bin.prefetchBits(this.symbolMaxBitLength);
            if (!$assertionsDisabled && n == -1) {
                throw new AssertionError();
            }
            short s = this.symbolCodeTable[n];
            this.bin.readBits(this.symbolLengthTable[s]);
            if (!($assertionsDisabled || s >= 0 && s < 511)) {
                throw new AssertionError();
            }
            return s;
        }
        catch (RuntimeException runtimeException) {
            throw new LzhException("decode error", runtimeException);
        }
    }

    public int readOffset() throws IOException {
        try {
            int n = this.bin.prefetchBits(this.offsetMaxBitLength);
            if (!$assertionsDisabled && n == -1) {
                throw new AssertionError();
            }
            int n2 = this.offsetCodeTable[n];
            short s = this.offsetLengthTable[n2];
            if (s > 0) {
                this.bin.readBits(s);
            }
            if (!($assertionsDisabled || n2 >= 0 && s >= 0)) {
                throw new AssertionError();
            }
            int n3 = n2 > 1 ? 1 << n2 - 1 | this.bin.readBits(n2 - 1) : n2;
            if (!$assertionsDisabled && n3 < 0) {
                throw new AssertionError();
            }
            return n3;
        }
        catch (RuntimeException runtimeException) {
            throw new LzhException("decode error", runtimeException);
        }
    }

    private void createSymbolTables() throws IOException {
        short[] sArray = this.readCodeLengthList(5, 3);
        int n = LzhHuffmanDecoder.getMaxBitSize(sArray);
        short[] sArray2 = LzhHuffmanDecoder.createCodeTable(sArray, n);
        int n2 = this.bin.readBits(9);
        if (n2 < 1) {
            throw new LzhException("invalid compressed data: number of code lengths=" + n2);
        }
        short[] sArray3 = new short[n2];
        int n3 = 0;
        block5: while (n3 < sArray3.length) {
            int n4 = this.bin.prefetchBits(n);
            if (n4 == -1) {
                throw new LzhException("EOF appeared while reading symbol length list");
            }
            short s = sArray2[n4];
            short s2 = sArray[s];
            this.bin.readBits(s2);
            switch (s) {
                case 0: {
                    ++n3;
                    continue block5;
                }
                case 1: {
                    n3 += this.bin.readBits(4) + 3;
                    continue block5;
                }
                case 2: {
                    n3 += this.bin.readBits(9) + 20;
                    continue block5;
                }
            }
            sArray3[n3++] = (short)(s - 2);
        }
        this.symbolMaxBitLength = n3 = LzhHuffmanDecoder.getMaxBitSize(sArray3);
        this.symbolLengthTable = sArray3;
        this.symbolCodeTable = LzhHuffmanDecoder.createCodeTable(sArray3, n3);
    }

    private void createOffsetTables() throws IOException {
        short[] sArray = this.readCodeLengthList(4, -1);
        if (sArray.length == 0) {
            int n = this.bin.readBits(4);
            sArray = new short[n + 1];
            short[] sArray2 = new short[]{(short)n, (short)n};
            this.offsetMaxBitLength = 1;
            this.offsetLengthTable = sArray;
            this.offsetCodeTable = sArray2;
        } else {
            int n;
            this.offsetMaxBitLength = n = LzhHuffmanDecoder.getMaxBitSize(sArray);
            this.offsetLengthTable = sArray;
            this.offsetCodeTable = LzhHuffmanDecoder.createCodeTable(sArray, n);
        }
    }

    private short[] readCodeLengthList(int n, int n2) throws IOException {
        int n3 = this.bin.readBits(n);
        short[] sArray = new short[n3];
        for (int i = 0; i < n3; ++i) {
            int n4;
            if (i == n2) {
                i += this.bin.readBits(2);
            }
            if ((n4 = this.bin.readBits(3)) == 7) {
                while (this.bin.readBit() == 1) {
                    ++n4;
                }
            }
            sArray[i] = (short)n4;
        }
        return sArray;
    }

    private static int getMaxBitSize(short[] sArray) {
        short s = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] <= s) continue;
            s = sArray[i];
        }
        return s;
    }

    private static short[] createCodeTable(short[] sArray, int n) {
        int[] nArray = LzhHuffmanDecoder.createCodeList(sArray);
        int n2 = 1 << n;
        short[] sArray2 = new short[n2];
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] <= 0) continue;
            int n3 = n - sArray[i];
            int n4 = nArray[i] << n3;
            int n5 = n4 + (1 << n3);
            for (int j = n4; j < n5; ++j) {
                sArray2[j] = (short)i;
            }
        }
        return sArray2;
    }

    private static int[] createCodeList(short[] sArray) {
        if (!$assertionsDisabled && sArray.length <= 0) {
            throw new AssertionError();
        }
        if (sArray.length == 1) {
            return new int[1];
        }
        int[] nArray = new int[17];
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            nArray[s] = nArray[s] + 1;
        }
        int[] nArray2 = new int[17];
        for (int i = 0; i < 16; ++i) {
            nArray2[i + 1] = nArray2[i] + nArray[i + 1] << 1;
        }
        if (!$assertionsDisabled && nArray2[16] != 131072) {
            throw new AssertionError(nArray2[16]);
        }
        int[] nArray3 = new int[sArray.length];
        for (int i = 0; i < nArray3.length; ++i) {
            short s = sArray[i];
            if (s <= 0) continue;
            int n = s - 1;
            nArray2[n] = nArray2[n] + 1;
        }
        return nArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.bin.close();
        }
        finally {
            this.bin = null;
            this.symbolLengthTable = null;
            this.symbolCodeTable = null;
            this.offsetLengthTable = null;
            this.offsetCodeTable = null;
        }
    }

    static {
        $assertionsDisabled = !LzhHuffmanDecoder.class.desiredAssertionStatus();
    }
}

