/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import jp.sourceforge.armadillo.io.BitOutputStream;
import jp.sourceforge.armadillo.lzh.LzhException;
import jp.sourceforge.armadillo.lzh.LzhHuffmanTable;
import jp.sourceforge.armadillo.lzh.LzhQuit;
import jp.sourceforge.armadillo.lzh.LzssEncoderWritable;

public final class LzhHuffmanEncoder
implements LzssEncoderWritable {
    private static final int BUFFER_SIZE = 4096;
    private BitOutputStream out;
    private int threshold;
    private int index;
    private int[] symbolBuffer;
    private int[] offsetBuffer;
    private int[] frequencyTable;
    private int[] ct1;
    private int[] lt1;
    private int[] ct2;
    private int[] lt2;
    private int[] ct3;
    private int[] lt3;
    private int t1size;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LzhHuffmanEncoder(OutputStream outputStream, int n) {
        this.out = new BitOutputStream(new FilterOutputStream(outputStream){

            public void close() throws IOException {
            }
        });
        this.threshold = n;
        this.index = 0;
        this.symbolBuffer = new int[4096];
        this.offsetBuffer = new int[4096];
        this.frequencyTable = new int[512];
    }

    public void write(int n) throws IOException {
        int n2 = n;
        this.frequencyTable[n2] = this.frequencyTable[n2] + 1;
        this.symbolBuffer[this.index++] = n;
        if (this.index >= 4096) {
            this.encode();
        }
    }

    public void writeMatched(int n, int n2) throws IOException {
        int n3;
        if (!$assertionsDisabled && n2 < this.threshold) {
            throw new AssertionError();
        }
        int n4 = n3 = n2 - this.threshold + 256;
        this.frequencyTable[n4] = this.frequencyTable[n4] + 1;
        this.symbolBuffer[this.index] = n3;
        this.offsetBuffer[this.index++] = n - 1;
        if (this.index >= 4096) {
            this.encode();
        }
    }

    public void flush() throws IOException {
        this.encode();
    }

    private void encode() throws IOException {
        if (this.index == 0) {
            return;
        }
        try {
            this.createTables();
            this.outputCodes();
        }
        catch (LzhQuit lzhQuit) {
            throw lzhQuit;
        }
        catch (RuntimeException runtimeException) {
            LzhException lzhException = new LzhException("huffman encoding error");
            lzhException.initCause(runtimeException);
            throw lzhException;
        }
        finally {
            this.index = 0;
            this.ct1 = null;
            this.lt1 = null;
            this.ct2 = null;
            this.lt2 = null;
            this.ct3 = null;
            this.lt3 = null;
            Arrays.fill(this.frequencyTable, 0);
        }
    }

    private void createTables() {
        int n;
        LzhHuffmanTable lzhHuffmanTable = LzhHuffmanTable.build(this.frequencyTable);
        this.ct1 = lzhHuffmanTable.codeTable;
        this.lt1 = lzhHuffmanTable.codeLengthTable;
        this.t1size = LzhHuffmanEncoder.getTrimmedSize(this.lt1);
        int n2 = LzhHuffmanEncoder.getTrimmedSize(this.lt1);
        int[] nArray = new int[512];
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if ((n4 = this.lt1[n3++]) == 0) {
                n = 1;
                while (n3 < n2 && this.lt1[n3] == 0) {
                    ++n3;
                    ++n;
                }
                if (n <= 2) {
                    nArray[0] = nArray[0] + n;
                    continue;
                }
                if (n <= 18) {
                    nArray[1] = nArray[1] + 1;
                    continue;
                }
                if (n == 19) {
                    nArray[0] = nArray[0] + 1;
                    nArray[1] = nArray[1] + 1;
                    continue;
                }
                nArray[2] = nArray[2] + 1;
                continue;
            }
            int n5 = n = n4 + 2;
            nArray[n5] = nArray[n5] + 1;
        }
        LzhHuffmanTable lzhHuffmanTable2 = LzhHuffmanTable.build(nArray);
        this.ct2 = lzhHuffmanTable2.codeTable;
        this.lt2 = lzhHuffmanTable2.codeLengthTable;
        int[] nArray2 = new int[17];
        for (n = 0; n < this.index; ++n) {
            if (this.symbolBuffer[n] < 256) continue;
            int n6 = this.offsetBuffer[n];
            int n7 = 0;
            while (n6 >= 1 << n7) {
                ++n7;
            }
            int n8 = n7;
            nArray2[n8] = nArray2[n8] + 1;
        }
        LzhHuffmanTable lzhHuffmanTable3 = LzhHuffmanTable.build(nArray2);
        this.ct3 = lzhHuffmanTable3.codeTable;
        this.lt3 = lzhHuffmanTable3.codeLengthTable;
    }

    private void outputCodes() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = LzhHuffmanEncoder.getTrimmedSize(this.lt2);
        this.out.writeBits(this.index, 16);
        this.out.writeBits(n4, 5);
        int n5 = 0;
        while (n5 < n4) {
            if ((n3 = this.lt2[n5++]) <= 6) {
                this.out.writeBits(n3, 3);
            } else {
                this.out.writeBits(-1, n3 - 4);
                this.out.writeBits(0, 1);
            }
            if (n5 != 3) continue;
            while (n5 < 6 && this.lt2[n5] == 0) {
                ++n5;
            }
            this.out.writeBits(n5 - 3, 2);
        }
        this.out.writeBits(this.t1size, 9);
        n5 = 0;
        while (n5 < this.t1size) {
            if ((n3 = this.lt1[n5++]) == 0) {
                n2 = 1;
                while (n5 < this.t1size && this.lt1[n5] == 0) {
                    ++n5;
                    ++n2;
                }
                if (n2 <= 2) {
                    for (n = 0; n < n2; ++n) {
                        this.out.writeBits(this.ct2[0], this.lt2[0]);
                    }
                    continue;
                }
                if (n2 <= 18) {
                    this.out.writeBits(this.ct2[1], this.lt2[1]);
                    this.out.writeBits(n2 - 3, 4);
                    continue;
                }
                if (n2 == 19) {
                    this.out.writeBits(this.ct2[0], this.lt2[0]);
                    this.out.writeBits(this.ct2[1], this.lt2[1]);
                    this.out.writeBits(15, 4);
                    continue;
                }
                this.out.writeBits(this.ct2[2], this.lt2[2]);
                this.out.writeBits(n2 - 20, 9);
                continue;
            }
            this.out.writeBits(this.ct2[n3 + 2], this.lt2[n3 + 2]);
        }
        n5 = LzhHuffmanEncoder.getTrimmedSize(this.lt3);
        this.out.writeBits(n5, 4);
        if (n5 == 0) {
            this.out.writeBits(0, 4);
        } else {
            n3 = 0;
            while (n3 < n5) {
                if ((n2 = this.lt3[n3++]) <= 6) {
                    this.out.writeBits(n2, 3);
                    continue;
                }
                this.out.writeBits(-1, n2 - 4);
                this.out.writeBits(0, 1);
            }
        }
        for (n3 = 0; n3 < this.index; ++n3) {
            n2 = this.symbolBuffer[n3];
            this.out.writeBits(this.ct1[n2], this.lt1[n2]);
            if (n2 < 256) continue;
            n = this.offsetBuffer[n3];
            int n6 = 1;
            while (n >= 1 << n6) {
                ++n6;
            }
            if (n == 0) {
                n6 = 0;
            }
            this.out.writeBits(this.ct3[n6], this.lt3[n6]);
            if (n6 <= 1) continue;
            this.out.writeBits(n, n6 - 1);
        }
        this.out.flush();
    }

    private static int getTrimmedSize(int[] nArray) {
        int n;
        for (n = nArray.length; n > 0 && nArray[n - 1] == 0; --n) {
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.out.close();
        }
    }

    static {
        $assertionsDisabled = !LzhHuffmanEncoder.class.desiredAssertionStatus();
    }
}

