/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import jp.sourceforge.armadillo.lzh.LzhException;

public final class LzhMethod {
    public static final String LHD = "-lhd-";
    public static final String LH0 = "-lh0-";
    public static final String LH4 = "-lh4-";
    public static final String LH5 = "-lh5-";
    public static final String LH6 = "-lh6-";
    public static final String LH7 = "-lh7-";
    private final String methodName;
    private final int dictionarySize;
    private final int matchSize;
    private final int threshold;

    public LzhMethod(String string) throws LzhException {
        this.methodName = string;
        this.dictionarySize = LzhMethod.detectDictionarySize(string);
        this.matchSize = this.dictionarySize == 0 ? 0 : 256;
        this.threshold = this.dictionarySize == 0 ? 0 : 3;
    }

    private static int detectDictionarySize(String string) throws LzhException {
        if (string.matches("-lh[d0]-")) {
            return 0;
        }
        if (string.matches("-lh[4567]-")) {
            switch (string.charAt(3)) {
                case '4': {
                    return 4096;
                }
                default: {
                    return 8192;
                }
                case '6': {
                    return 32768;
                }
                case '7': 
            }
            return 65536;
        }
        throw new LzhException("unsupported method: " + string);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public int getMatchSize() {
        return this.matchSize;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public boolean isCompressing() {
        return this.dictionarySize > 0;
    }

    public static boolean isCompressing(String string) throws LzhException {
        return LzhMethod.detectDictionarySize(string) > 0;
    }
}

