/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import java.io.IOException;
import java.io.OutputStream;
import jp.sourceforge.armadillo.io.ArchiveOutputStream;
import jp.sourceforge.armadillo.lzh.CRC16;
import jp.sourceforge.armadillo.lzh.LzhEntry;
import jp.sourceforge.armadillo.lzh.LzhHeader;
import jp.sourceforge.armadillo.lzh.LzhHuffmanEncoder;
import jp.sourceforge.armadillo.lzh.LzhMethod;
import jp.sourceforge.armadillo.lzh.LzssOutputStream;

public final class LzhOutputStream
extends ArchiveOutputStream {
    private LzhHeader header = new LzhHeader();
    private CRC16 crc = new CRC16();

    public LzhOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.frontStream = outputStream;
    }

    public void putNextEntry(LzhEntry lzhEntry) throws IOException {
        String string = lzhEntry.getMethod();
        LzhMethod lzhMethod = new LzhMethod(string);
        this.frontStream = lzhMethod.isCompressing() ? new LzssOutputStream(new LzhHuffmanEncoder(this.out, lzhMethod.getThreshold()), lzhMethod.getDictionarySize(), lzhMethod.getMatchSize(), lzhMethod.getThreshold()) : this.out;
        this.writeHeader(lzhEntry);
        this.crc.reset();
    }

    public void writeHeader(LzhEntry lzhEntry) throws IOException {
        this.header.write(this.out, lzhEntry);
    }

    public void writeHeader(LzhEntry lzhEntry, OutputStream outputStream) throws IOException {
        this.header.write(outputStream, lzhEntry);
    }

    public void write(int n) throws IOException {
        super.write(n);
        this.crc.update(n);
    }

    public void write(byte[] byArray) throws IOException {
        super.write(byArray);
        this.crc.update(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
    }

    public short getCrc() {
        return this.crc.getShortValue();
    }

    public void closeEntry() throws IOException {
        this.frontStream.flush();
        if (this.frontStream != this.out) {
            this.frontStream.close();
        }
        this.frontStream = this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flush();
            super.write(0);
            super.flush();
        }
        finally {
            this.header = null;
            super.close();
        }
    }
}

